/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.rail;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.b2b.rest.common.RestTrainToken;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdCategory;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdGetTrainSeatsParameters;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTrain;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTrainWithCategories;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.ibecorp.travelPolicy.TravelPolicyParameters;
import com.gridnine.xtrip.common.model.ibecorp.trip.IBusTripContextKeys;
import com.gridnine.xtrip.common.model.ibecorp.trip.TripParameters;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.CarriageInfo;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.SeatsParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.Train;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.rail.IBusRestRailContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.search.IBusIbecorpB2BSearchCtxKeys;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonRestHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.CommonRailRestHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.model.TrainSegment;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.IBusTravelPolicyContextKeys;
import com.gridnine.xtrip.server.ibus.IbusHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.time.LocalDateTime;

public class TrainSeatsPrepareProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SeatsParameters parameters = (SeatsParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        RzdGetTrainSeatsParameters res = (RzdGetTrainSeatsParameters)IbusHelper.getForceObject((MessageContext)ctx, (Enum)IBusRailwayContextKeys.RAILWAY_GET_TRAIN_SEATS_PARAMETERS, (Object)new RzdGetTrainSeatsParameters());
        if (parameters.getTrain() == null) {
            throw Xeption.forDeveloper((String)"missing train", (Object[])new Object[0]);
        }
        Train restTrain = parameters.getTrain();
        String carriageVariantUid = parameters.getCarriageVariantUid();
        RestTrainToken restTrainToken = this.decodeRestToken(restTrain);
        RzdTrain rzdTrain = this.decodeRzdTrain(restTrain);
        CommonRailRestHelper.fillCommonSeatsRequest(restTrain, salesContext, DateUtils.toJavaDate((LocalDateTime)((TrainSegment)restTrain.getSegments().get(0)).getDepartureDate()), restTrainToken, res, rzdTrain);
        this.collectCarriages(restTrain, carriageVariantUid, restTrainToken, res);
        RzdTrainWithCategories rzdTrainWithCategories = this.convertToRzdTrainWithCategories(restTrain);
        ctx.putObject((Enum)IBusRailwayContextKeys.RAILWAY_TRAIN, (Object)rzdTrainWithCategories.getTrain());
        ctx.putObject((Enum)IBusRailwayContextKeys.RAILWAY_TRAIN_CATEGORY, (Object)this.getRzdCategory(carriageVariantUid, rzdTrainWithCategories));
        ctx.putObject((Enum)IBusRestRailContextKeys.REST_TRAIN_TOKEN, (Object)restTrainToken);
        ctx.putObject((Enum)IBusIbecorpB2BSearchCtxKeys.SELECTED_PASSENGERS, (Object)restTrainToken.getSelectedPassengers());
        if (restTrainToken.getClient() != null) {
            TravelPolicyParameters travelPolicyParams = new TravelPolicyParameters();
            travelPolicyParams.setClientRef(restTrainToken.getClient());
            travelPolicyParams.getPersons().addAll(restTrainToken.getSelectedPassengers());
            ctx.putObject((Enum)IBusTravelPolicyContextKeys.TRAVEL_POLICY_PARAMETERS, (Object)travelPolicyParams);
        }
        if (restTrainToken.getBookingFile() != null) {
            TripParameters tripParams = new TripParameters();
            tripParams.setBookingFileRef(restTrainToken.getBookingFile());
            ctx.putObject((Enum)IBusTripContextKeys.TRIP_PARAMETERS, (Object)tripParams);
        }
    }

    protected RzdCategory getRzdCategory(String carriageVariantUid, RzdTrainWithCategories rzdTrainWithCategories) {
        return (RzdCategory)CollectionUtil.find((Iterable)rzdTrainWithCategories.getCategories(), (String)carriageVariantUid);
    }

    protected RzdTrainWithCategories convertToRzdTrainWithCategories(Train restTrain) {
        return CommonRailRestHelper.convertRestToRzdTrainWithCategories(restTrain);
    }

    private void collectCarriages(Train restTrain, String carriageVariantUid, RestTrainToken restTrainToken, RzdGetTrainSeatsParameters midofficeIbusRequest) {
        if (TextUtil.isBlank((String)carriageVariantUid)) {
            return;
        }
        if (restTrainToken.getCarriageInfos().containsKey(carriageVariantUid)) {
            for (CarriageInfo carriageInfo : restTrain.getCarriageInfos()) {
                if (!carriageInfo.getUid().equals(carriageVariantUid)) continue;
                midofficeIbusRequest.setCarriageType(carriageInfo.getType());
            }
            if (midofficeIbusRequest.getCarriageType() == null) {
                throw Xeption.forDeveloper((String)"no category", (Object[])new Object[0]);
            }
            String trainNumber = (String)restTrainToken.getCarriageInfos().get(carriageVariantUid);
            if (!TextUtil.isBlank((String)trainNumber)) {
                midofficeIbusRequest.setTrainNumber(trainNumber);
            }
        } else {
            throw Xeption.forDeveloper((String)"can't find categories", (Object[])new Object[0]);
        }
    }

    protected RzdTrain decodeRzdTrain(Train restTrain) {
        return CommonRailRestHelper.convertRestToRzdTrain(restTrain);
    }

    protected RestTrainToken decodeRestToken(Train train) {
        return CommonRestHelper.decodeToken(train.getToken(), RestTrainToken.class);
    }
}

