/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.rail.booking;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.CurrencyHelper;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.rest.InformationMessage;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.B2BRestHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.PricingResult;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.IBusIbecorpRailContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;

public class CheckBookingPriceProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        BigDecimal newPrice;
        PricingResult pricingResult = (PricingResult)ctx.getMandatoryObject((Enum)IBusIbecorpRailContextKeys.ITEM);
        List reservations = (List)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_RESERVATIONS_PERFORMED);
        final SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        BigDecimal oldPrice = pricingResult.getPrice().getTotal().getAmount();
        if (pricingResult.getPriceBack() != null) {
            oldPrice = MiscUtil.sum((BigDecimal[])new BigDecimal[]{oldPrice, pricingResult.getPriceBack().getTotal().getAmount()});
        }
        if ((newPrice = reservations.stream().map(res -> BookingHelper.getTotalPrice((Reservation)res, (ContractType)ContractType.CLIENT)).reduce((xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})).orElse(BigDecimal.ZERO)).compareTo(oldPrice) != 0) {
            InformationMessage message = new InformationMessage(){

                public String getCode() {
                    return "priceChanged";
                }

                public String getText() {
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("newPrice", newPrice.toString());
                    params.put("currency", CurrencyHelper.getCurrency((EntityReference)salesContext.getSubagency(), (EntityReference)salesContext.getClient(), (ContractType)ContractType.CLIENT));
                    return TextUtil.formatNamed((String)L10nResourcesManager.getStr((String)"IBE_RAIL_ORDER_VALUE_CHANGED", (Object[])new Object[0]), params);
                }

                public InformationMessage.Severity getSeverity() {
                    return InformationMessage.Severity.WARNING;
                }
            };
            B2BRestHelper.addMessage(ctx, message);
        }
    }
}

