/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.rail.booking;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.RzdReservationCreationParameters;
import com.gridnine.xtrip.common.ibecorp.model.RzdTraveller;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.rest.Validatable;
import com.gridnine.xtrip.common.model.standard.helpers.ValidatableUtil;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.common.model.validation.ValidationMessage;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.PricingParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.RestPassport;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.model.RailBonusCard;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.model.RailTraveller;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.web.rest.ValidationHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class CreateBookingValidationAdvice
extends BaseAdvice {
    List<CommunicationType> PHONE_TYPES = Arrays.asList(CommunicationType.HOME_PHONE, CommunicationType.WORK_PHONE, CommunicationType.MOBILE, CommunicationType.FAX, CommunicationType.AGENCY, CommunicationType.CELL, CommunicationType.HOTEL);

    public boolean handleException(Throwable e, MessageContext ctx) {
        if (e instanceof ValidationException) {
            PricingParameters pricingParameters = (PricingParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_ENTITY);
            RzdReservationCreationParameters creationParameters = (RzdReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
            Collection travellers = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
            Customer customer = (Customer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.CUSTOMER);
            this.copyValidationMessages(creationParameters, travellers, pricingParameters);
            if (ValidationHelper.isValid((Validatable)pricingParameters)) {
                throw Xeption.forDeveloper((String)this.getFirstValidationMessage(creationParameters, customer, travellers), (Object[])new Object[0]);
            }
            return true;
        }
        return false;
    }

    private String getFirstValidationMessage(RzdReservationCreationParameters creationParameters, Customer customer, Collection<Traveller> travellers) {
        String prefix = "params";
        List errors = ValidatableUtil.getValidateStrings((com.gridnine.xtrip.common.model.Validatable)creationParameters);
        if (errors.isEmpty()) {
            prefix = "customer";
            errors = ValidatableUtil.getValidateStrings((com.gridnine.xtrip.common.model.Validatable)customer);
        }
        if (errors.isEmpty()) {
            prefix = "travellers";
            errors = ValidatableUtil.getValidateStrings(travellers, (String)"");
        }
        if (errors.isEmpty()) {
            throw Xeption.forDeveloper((String)"validation advise error", (Object[])new Object[0]);
        }
        return prefix.concat(TextUtil.join((String)"; ", (Iterable)errors));
    }

    private void copyValidationMessages(RzdReservationCreationParameters creationParameters, Collection<Traveller> travellers, PricingParameters pricingParameters) {
        if (!com.gridnine.xtrip.common.model.validation.ValidationHelper.isValid((com.gridnine.xtrip.common.model.Validatable)creationParameters)) {
            this.copy(creationParameters.getValidationContext().getRzdTravellersValidationMessages(), pricingParameters.getValidationContext().getCommonMessagesValidationMessages());
        }
        if (!CollectionUtil.isEmpty((Collection)pricingParameters.getTravellers())) {
            int i = 0;
            for (RzdTraveller rzdTraveller : creationParameters.getRzdTravellers()) {
                Traveller traveller = (Traveller)CollectionUtil.find(travellers, (String)rzdTraveller.getTravellerUid());
                RailTraveller railTraveller = (RailTraveller)pricingParameters.getTravellers().get(i);
                this.copyMessages(rzdTraveller, railTraveller);
                this.copyMessages(traveller, railTraveller);
                ++i;
            }
        }
    }

    private void copyMessages(RzdTraveller rzdTraveller, RailTraveller railTraveller) {
        this.copy(rzdTraveller.getValidationContext().getTariffValidationMessages(), railTraveller.getValidationContext().getTariffValidationMessages());
    }

    private void copyMessages(Traveller traveller, RailTraveller railTraveller) {
        if (!com.gridnine.xtrip.common.model.validation.ValidationHelper.isValid((com.gridnine.xtrip.common.model.Validatable)traveller)) {
            if (!this.copy(traveller.getValidationContext().getPassportValidationMessages(), railTraveller.getValidationContext().getPassportValidationMessages())) {
                this.copyMessages(traveller.getPassport().getValidationContext(), railTraveller.getPassport().getValidationContext());
            }
            if (!CollectionUtil.isEmpty((Collection)traveller.getValidationContext().getRailwayBonusCardValidationMessages())) {
                if (railTraveller.getRailBonusCard() == null) {
                    railTraveller.setRailBonusCard(new RailBonusCard());
                }
                this.copy(traveller.getValidationContext().getRailwayBonusCardValidationMessages(), railTraveller.getRailBonusCard().getValidationContext().getNumberValidationMessages());
            }
            this.copy(traveller.getValidationContext().getIINValidationMessages(), railTraveller.getValidationContext().getIINValidationMessages());
            if (!CollectionUtil.isEmptyMap((Map)traveller.getValidationContext().getCommunicationsListValidationMessages())) {
                if (TextUtil.isBlank((String)railTraveller.getEmail())) {
                    railTraveller.setEmail("");
                }
                this.copyEmailMessages(traveller.getCommunications(), traveller.getValidationContext().getCommunicationsListValidationMessages(), railTraveller.getValidationContext().getEmailValidationMessages());
                this.copyPhoneMessages(traveller.getCommunications(), traveller.getValidationContext().getCommunicationsListValidationMessages(), railTraveller.getValidationContext().getPhoneValidationMessages());
            }
        }
    }

    private void copyMessages(Passport.PassportValidationContext vcFrom, RestPassport.RestPassportValidationContext vcTo) {
        this.copy(vcFrom.getGenderValidationMessages(), vcTo.getGenderValidationMessages());
        this.copy(vcFrom.getBirthdayValidationMessages(), vcTo.getBirthDateValidationMessages());
        this.copy(vcFrom.getBirthPlaceValidationMessages(), vcTo.getBirthPlaceValidationMessages());
        this.copy(vcFrom.getCitizenshipValidationMessages(), vcTo.getCitizenshipValidationMessages());
        this.copy(vcFrom.getFirstNameValidationMessages(), vcTo.getFirstNameValidationMessages());
        this.copy(vcFrom.getSecondNameValidationMessages(), vcTo.getSecondNameValidationMessages());
        this.copy(vcFrom.getLastNameValidationMessages(), vcTo.getLastNameValidationMessages());
        this.copy(vcFrom.getMiddleNameValidationMessages(), vcTo.getMiddleNameValidationMessages());
        this.copy(vcFrom.getNumberValidationMessages(), vcTo.getNumberValidationMessages());
        this.copy(vcFrom.getOriginCountryValidationMessages(), vcTo.getOriginCountryValidationMessages());
        this.copy(vcFrom.getExpiredValidationMessages(), vcTo.getExpiredDateValidationMessages());
        this.copy(vcFrom.getTypeValidationMessages(), vcTo.getTypeValidationMessages());
    }

    private void copyEmailMessages(List<Communication> communications, Map<Integer, Collection<ValidationMessage>> mapFrom, Collection<ValidationMessage> to) {
        if (!CollectionUtil.isEmptyMap(mapFrom)) {
            int ci = -1;
            for (int j = 0; j < communications.size(); ++j) {
                if (communications.get(j).getType() != CommunicationType.EMAIL) continue;
                ci = j;
                break;
            }
            if (mapFrom.containsKey(ci)) {
                to.addAll(mapFrom.get(ci));
            }
        }
    }

    private void copyPhoneMessages(List<Communication> communications, Map<Integer, Collection<ValidationMessage>> mapFrom, Collection<ValidationMessage> to) {
        if (!CollectionUtil.isEmptyMap(mapFrom)) {
            int ci = -1;
            for (int j = 0; j < communications.size(); ++j) {
                if (!this.PHONE_TYPES.contains(communications.get(j).getType())) continue;
                ci = j;
                break;
            }
            if (mapFrom.containsKey(ci)) {
                to.addAll(mapFrom.get(ci));
            }
        }
    }

    private boolean copy(Collection<ValidationMessage> from, Collection<ValidationMessage> to) {
        return ValidationHelper.copy(from, to);
    }
}

