/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.rail.booking.getBookingForm;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.b2b.rest.common.RestCarriageToken;
import com.gridnine.xtrip.common.ibecorp.model.b2b.rest.common.RestTrainToken;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdBonusCardType;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdCar;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdPrice;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTariff;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.ibecorp.AckMessage;
import com.gridnine.xtrip.common.model.ibecorp.railway.BaseRailGdsAccount;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMStep3Settings;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.profile.ReasonCodeType;
import com.gridnine.xtrip.common.model.rules.TransliterationType;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyImpositionResult;
import com.gridnine.xtrip.common.system.model.RegionalType;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.RestBookingHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.getBookingForm.BaseBookingFormSettingsProcessor;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.BookingFormSettings;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.booking.RailBookingFormSettings;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.booking.RailBookingFormSettingsParams;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.booking.TariffDescription;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.rail.IBusRestRailContextKeys;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonRestHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.SiteConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.RestTraveller;
import com.gridnine.xtrip.server.ibecorp.ibus.tasks.autoticketing.IBusAuthorizationContextKeys;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class RailBookingFormSettingsProcessor
extends BaseBookingFormSettingsProcessor {
    public void process(MessageContext ctx) throws Exception {
        RailBookingFormSettingsParams params = (RailBookingFormSettingsParams)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityReference site = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        SMSiteType siteType = (SMSiteType)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE_TYPE);
        PersonType authUserType = (PersonType)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER_PERSON_TYPE);
        RestTrainToken trainToken = (RestTrainToken)ctx.getObject((Enum)IBusRestRailContextKeys.REST_TRAIN_TOKEN);
        AckMessage searchDuplicatesMessage = (AckMessage)ctx.getObject((Enum)IBusAuthorizationContextKeys.SEARCH_DUPLICATES_MESSAGE);
        RestCarriageToken carriageToken = CommonRestHelper.decodeToken(params.getTokens().getCarriageToken(), RestCarriageToken.class);
        RailBookingFormSettings result = new RailBookingFormSettings();
        this.setSearchDuplicatesMessageData((BookingFormSettings)result, searchDuplicatesMessage);
        CommonConverterHelper.setCustomerAndOrder((BookingFormSettings)result, (EntityReference<BookingFile>)trainToken.getBookingFile());
        BookingFile bookingFile = null;
        if (result.getOrder() != null) {
            bookingFile = (BookingFile)EntityStorage.get().load(BookingFile.class, result.getOrder().getBookingUid()).getEntity();
        }
        EntityReference clientRef = trainToken.getClient();
        EntityContainer clientCtr = EntityStorage.get().resolve(clientRef);
        salesContext.setClient(clientRef);
        result.setContactAutocompleteAvailable(this.isContactAutocompleteAvailable(siteType, (EntityContainer<Organization>)clientCtr));
        result.getCorporatePassengers().addAll(this.getPassengers(bookingFile, trainToken.getSelectedPassengers(), Collections.emptyMap(), (EntityReference<Organization>)clientRef));
        result.getOrganizationCostCodes().addAll(RestBookingHelper.getOrganizationCostCodes((EntityContainer<Organization>)clientCtr, params.getTraveller()));
        TravelPolicyImpositionResult tpImpositionResult = carriageToken.getPrice().getTravelPolicyImpositionResult();
        result.setReasonCode(RailBookingFormSettingsProcessor.getReasonCode((EntityContainer<Organization>)clientCtr, tpImpositionResult, ReasonCodeType.REASON_CODE_RAIL));
        RailBookingFormSettingsProcessor.setKeyContact((BookingFormSettings)result, (EntityContainer<Organization>)clientCtr, tpImpositionResult);
        this.collectPassportTypesFromSiteSettings(result, (EntityReference<SMSite>)site, carriageToken.getPrice());
        RzdCar rzdCar = carriageToken.getPrice().getCars().stream().filter(car -> car.getUid().equals(carriageToken.getCarUid())).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"can't find rzdCar with carUid {0}", (Object[])new Object[]{carriageToken.getCarUid()}));
        this.getDataFromTokens(params, carriageToken, result);
        for (RzdTariff tariff : result.getTariffs()) {
            result.getTariffDescriptions().put(tariff, this.createTariffDescription(tariff, rzdCar));
        }
        result.setBeddingEnabled(rzdCar.isBeddingEnabled());
        if (params.getTokensBack() != null) {
            RestCarriageToken carriageTokenBack = CommonRestHelper.decodeToken(params.getTokensBack().getCarriageToken(), RestCarriageToken.class);
            RzdCar rzdCarBack = carriageTokenBack.getPrice().getCars().stream().filter(car -> car.getUid().equals(carriageTokenBack.getCarUid())).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"can't find back rzdCar with carUid {0}", (Object[])new Object[]{carriageTokenBack.getCarUid()}));
            result.setBeddingBackEnabled(rzdCarBack.isBeddingEnabled());
        }
        EntityReference gdsAccount = trainToken.getGdsAccount();
        GdsName gdsName = ((BaseRailGdsAccount)EntityStorage.get().resolve(gdsAccount).getEntity()).getGds();
        result.setIinEnabled(this.isIinEnabled(gdsName, params.getTraveller()));
        TransliterationType transliterationType = this.getTransliterationType(params.getTraveller());
        result.setLangRegistrationFullName(transliterationType);
        result.setLangRegistrationDocument(transliterationType);
        RailBookingFormSettingsProcessor.setTravellerData((BookingFormSettings)result, salesContext, TravelSubject.RAILWAY);
        RailBookingFormSettingsProcessor.setContactPersonData((BookingFormSettings)result, authUserType, salesContext);
        if (bookingFile == null) {
            RailBookingFormSettingsProcessor.setExternalSystemsData((BookingFormSettings)result, salesContext);
        }
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    private boolean isIinEnabled(GdsName gdsName, RestTraveller traveller) {
        return gdsName == GdsName.RAIL_KZ && SystemHelper.containsInRegionalSettings((RegionalType)RegionalType.KZ) && traveller != null && traveller.getPassport() != null && RzdCommonHelper.isKzCitizenship((DictionaryReference)traveller.getPassport().getCitizenship());
    }

    private void collectPassportTypesFromSiteSettings(RailBookingFormSettings result, EntityReference<SMSite> site, RzdPrice rzdPrice) {
        SMStep3Settings thirdStepSettings = Objects.requireNonNull(CommonHelper.getStep3Settings(site));
        ArrayList allowedPassportTypesBySettings = new ArrayList(thirdStepSettings.getAllowedDocuments());
        allowedPassportTypesBySettings.retainAll(rzdPrice.getAvailableDocuments());
        List<DictionaryReference<PassengerType>> types = SiteConverterHelper.getBasePassengerTypes();
        result.getPassengerTypeDocument().addAll(types.stream().map(pt -> SiteConverterHelper.convertPassengerTypeDocuments2Rest((DictionaryReference<PassengerType>)pt, allowedPassportTypesBySettings)).collect(Collectors.toList()));
    }

    private void getDataFromTokens(RailBookingFormSettingsParams params, RestCarriageToken carriageToken, RailBookingFormSettings result) {
        Set availableTariffs = carriageToken.getPrice().getAvailableTariffs();
        List passportTypes = carriageToken.getAvailablePassportTypes();
        List availableBonusCards = carriageToken.getPrice().getAvailableBonusCards();
        if (params.getTokensBack() != null) {
            RestCarriageToken carriageTokenBack = CommonRestHelper.decodeToken(params.getTokensBack().getCarriageToken(), RestCarriageToken.class);
            availableTariffs.retainAll(carriageTokenBack.getPrice().getAvailableTariffs());
            passportTypes.retainAll(carriageTokenBack.getAvailablePassportTypes());
            availableBonusCards.retainAll(carriageTokenBack.getPrice().getAvailableBonusCards());
        }
        result.getTariffs().addAll(availableTariffs);
        result.setBonusCardAvailable(availableBonusCards.contains(RzdBonusCardType.RZHD_BONUS));
        result.getPassengerTypeDocument().forEach(ptd -> ptd.getPassportTypes().retainAll(passportTypes));
    }

    private TariffDescription createTariffDescription(RzdTariff tariff, RzdCar rzdCar) {
        TariffDescription result = new TariffDescription();
        DictionaryReference passengerType = RzdCommonHelper.rzdTariffToPassengerType((RzdTariff)tariff);
        result.setPassengerType(passengerType);
        if (!passengerType.equals((Object)DictHelper.getInfantPassengerType())) {
            result.setNonRefundableTariff(rzdCar.isHasNonRefundableTariff());
        }
        return result;
    }

    private TransliterationType getTransliterationType(RestTraveller traveller) {
        TransliterationType defaultResult = TransliterationType.CYRILLIC;
        if (traveller == null || traveller.getPassport() == null) {
            return defaultResult;
        }
        PassportType passportType = traveller.getPassport().getType();
        if (passportType == null) {
            return defaultResult;
        }
        DictionaryReference citizenshipRef = traveller.getPassport().getCitizenship();
        switch (passportType) {
            case INTERNAL: 
            case MILITARYID: 
            case MILITARYCERTIFICATE: 
            case BIRTHDAY_NOTIFICATION: 
            case PASSPORTLOSSCERTIFICATE: 
            case CERTIFICATEOFRELEASE: 
            case INTERIMCERTIFICATE: {
                return TransliterationType.CYRILLIC;
            }
            case FOREIGN: {
                return TransliterationType.LATIN;
            }
            case PASSPORT: {
                if (RzdCommonHelper.isByCitizenship((DictionaryReference)citizenshipRef)) {
                    return TransliterationType.LATIN_AND_CYRILLIC;
                }
                return TransliterationType.LATIN;
            }
            case IDENTITYCARD: {
                if (!RzdCommonHelper.isKzCitizenship((DictionaryReference)citizenshipRef)) break;
                return TransliterationType.CYRILLIC;
            }
        }
        return TransliterationType.LATIN_AND_CYRILLIC;
    }

    private boolean isRuPassportAllowed(DictionaryReference<RailwayStation> stationRef) {
        RailwayStation station = (RailwayStation)DictHelper.resolve(stationRef);
        if (station == null) {
            return false;
        }
        DictionaryReference countryRef = station.getCountry();
        Country country = (Country)DictHelper.resolve((DictionaryReference)countryRef);
        return country != null && country.isRuPassportAllowed();
    }
}

