/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.rail.pricing;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.CommonIbecorpHelper;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.b2b.rest.common.RestCarriageToken;
import com.gridnine.xtrip.common.ibecorp.model.b2b.rest.common.RestTrainToken;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTariff;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdValidationMessages;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMStep3Settings;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.ReasonCode;
import com.gridnine.xtrip.common.model.profile.ReasonCodeType;
import com.gridnine.xtrip.common.model.system.StandardValidationMessages;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyImpositionResult;
import com.gridnine.xtrip.common.model.validation.ValidationMessage;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.RestBookingHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.BookingRouteInfo;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.CarPlaceTypeData;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.PricingParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.SeatsRequest;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonRestHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.CreateBookingParametersValidationMessages;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.RailRestValidationHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.model.RailTraveller;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.model.ValidationMessages;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.BooleanUtils;

public class PricingValidator
extends BaseProcessor {
    public void process(MessageContext ctx) {
        TravelPolicyImpositionResult travelPolicyImpositionResult2;
        PricingParameters parameters = (PricingParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        ReasonCode reasonCode = (ReasonCode)ctx.getObject((Enum)IBusIbecorpContextKeys.REASON_CODE);
        SMStep3Settings step3Settings = Objects.requireNonNull(CommonHelper.getStep3Settings((EntityReference<SMSite>)((EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE))));
        if (parameters.getTravellers().isEmpty()) {
            throw Xeption.forDeveloper((String)"no travellers", (Object[])new Object[0]);
        }
        RestTrainToken token = CommonRestHelper.decodeToken(parameters.getRouteInfo().getTrain().getToken(), RestTrainToken.class);
        EntityContainer bfCtr = EntityStorage.get().resolve(token.getBookingFile());
        EntityReference clientRef = salesContext.getClient();
        Organization client = (Organization)EntityStorage.get().resolve(clientRef).getEntity();
        for (RailTraveller railTraveller : parameters.getTravellers()) {
            Collection<ValidationMessage> messages;
            if (railTraveller.getPassport() != null && !railTraveller.getPassport().isWithoutMiddleName() && TextUtil.isBlank((String)railTraveller.getPassport().getMiddleName())) {
                railTraveller.getPassport().getValidationContext().getMiddleNameValidationMessages().add(ValidationMessages.getMissingRequiredField());
            }
            if (!TextUtil.isBlank((String)railTraveller.getEmail()) && !RailRestValidationHelper.validateEmail(railTraveller.getEmail(), true)) {
                railTraveller.getValidationContext().getEmailValidationMessages().add(ValidationMessages.getEmailFormatError());
            }
            if (!RailRestValidationHelper.isBlank(railTraveller.getPhone()) && !(messages = RailRestValidationHelper.validateContactPhone(railTraveller.getPhone())).isEmpty()) {
                railTraveller.getValidationContext().getPhoneValidationMessages().addAll(messages);
            }
            if (TextUtil.isBlank((String)railTraveller.getEmail()) && RailRestValidationHelper.isBlank(railTraveller.getPhone())) {
                railTraveller.getValidationContext().getPhoneValidationMessages().add(RzdValidationMessages.getMissingTravellerPhoneAndEmail());
                railTraveller.getValidationContext().getEmailValidationMessages().add(RzdValidationMessages.getMissingTravellerPhoneAndEmail());
            }
            if (railTraveller.getTariff() == RzdTariff.SCHOOL && !BooleanUtils.isTrue((Boolean)railTraveller.isSchoolTariffConfirmation())) {
                railTraveller.getValidationContext().getSchoolTariffConfirmationValidationMessages().add(ValidationMessages.getMissingRequiredField());
            }
            RestBookingHelper.validateRestCodeCodes(railTraveller.getCostCodes(), client);
        }
        RestBookingHelper.validateRestCommonCostCodes(parameters.getTravellers(), client, (EntityContainer<BookingFile>)bfCtr);
        int requiredNonRefundableSeats = (int)parameters.getTravellers().stream().filter(RailTraveller::isNonRefundableTariff).count();
        this.checkNonRefundableSeats(parameters.getRouteInfo(), requiredNonRefundableSeats);
        this.checkNonRefundableSeats(parameters.getRouteInfoBack(), requiredNonRefundableSeats);
        RestCarriageToken restCarriageToken1 = CommonRestHelper.decodeToken(parameters.getRouteInfo().getCarriage().getToken(), RestCarriageToken.class);
        TravelPolicyImpositionResult travelPolicyImpositionResult1 = restCarriageToken1.getPrice().getTravelPolicyImpositionResult();
        if (parameters.getRouteInfoBack() != null) {
            RestCarriageToken restCarriageToken2 = CommonRestHelper.decodeToken(parameters.getRouteInfoBack().getCarriage().getToken(), RestCarriageToken.class);
            travelPolicyImpositionResult2 = restCarriageToken2.getPrice().getTravelPolicyImpositionResult();
        } else {
            travelPolicyImpositionResult2 = null;
        }
        if (CommonIbecorpHelper.mustHaveReasonCode((EntityReference)clientRef, (TravelPolicyImpositionResult)travelPolicyImpositionResult1, travelPolicyImpositionResult2, (ReasonCodeType)ReasonCodeType.REASON_CODE_RAIL) && null == reasonCode) {
            parameters.getValidationContext().getReasonCodeValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
        }
        if ((CommonIbecorpHelper.mustHaveKeyContact((TravelPolicyImpositionResult)travelPolicyImpositionResult1) || CommonIbecorpHelper.mustHaveKeyContact((TravelPolicyImpositionResult)travelPolicyImpositionResult2)) && parameters.getKeyContact() == null) {
            parameters.getValidationContext().getKeyContactValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
        }
        if (!step3Settings.isDisablePersonalDataRules() && !parameters.isAcceptSecurityRules()) {
            parameters.getValidationContext().getAcceptSecurityRulesValidationMessages().add(CreateBookingParametersValidationMessages.getSecurityRulesNotAccepted());
        }
        this.checkCarPlaceType(parameters.getRouteInfo());
        this.checkCarPlaceType(parameters.getRouteInfoBack());
        ctx.putObject((Enum)IBusRestContextKeys.REST_ENTITY, (Object)parameters);
    }

    private void checkNonRefundableSeats(BookingRouteInfo routeInfo, int requiredNonRefundableSeats) {
        if (routeInfo == null || requiredNonRefundableSeats == 0) {
            return;
        }
        Integer start = routeInfo.getSeatsRequest().getRange().getFirst();
        Integer end = routeInfo.getSeatsRequest().getRange().getSecond();
        long existsNonRefundableSeats = routeInfo.getCarriage().getCarPlaceData().stream().filter(CarPlaceTypeData::hasNonRefundableTariff).map(CarPlaceTypeData::getAvailableSeats).flatMap(Collection::stream).map(Integer::valueOf).filter(seatNmb -> start != null && seatNmb >= start).filter(seatNmb -> end != null && seatNmb <= end).distinct().count();
        if ((long)requiredNonRefundableSeats > existsNonRefundableSeats) {
            throw Xeption.forEndUser((String)"REQUESTED_NON_REFUNDABLE_SEATS_NUMBER_EXCEED_AVAILABLE", (Object[])new Object[]{requiredNonRefundableSeats, existsNonRefundableSeats});
        }
    }

    private void checkCarPlaceType(BookingRouteInfo routeInfo) {
        if (routeInfo == null) {
            return;
        }
        SeatsRequest seatsRequest = routeInfo.getSeatsRequest();
        ArrayList<String> seats = new ArrayList<String>();
        for (int i = seatsRequest.getRange().getFirst().intValue(); i <= seatsRequest.getRange().getSecond(); ++i) {
            seats.add(String.valueOf(i));
        }
        Set carPlaceTypes = routeInfo.getCarriage().getCarPlaceData().stream().filter(placeData -> seats.stream().anyMatch(seat -> placeData.getAvailableSeats().contains(seat))).map(CarPlaceTypeData::getCarPlaceType).collect(Collectors.toSet());
        if (seatsRequest.getAmount() != null) {
            if (!MiscUtil.guarded((Integer)seatsRequest.getAmount().getLower()).equals(0)) {
                if (carPlaceTypes.stream().noneMatch(RzdCommonHelper.LOWER_CAR_PLACE_TYPES::contains)) {
                    throw Xeption.forDeveloper((String)String.format("no lower seats in the selected seat range %s - %s", seatsRequest.getRange().getFirst(), seatsRequest.getRange().getSecond()), (Object[])new Object[0]);
                }
            }
            if (!MiscUtil.guarded((Integer)seatsRequest.getAmount().getUpper()).equals(0)) {
                if (carPlaceTypes.stream().noneMatch(RzdCommonHelper.UPPER_CAR_PLACE_TYPES::contains)) {
                    throw Xeption.forDeveloper((String)String.format("no upper seats in the selected seat range %s - %s", seatsRequest.getRange().getFirst(), seatsRequest.getRange().getSecond()), (Object[])new Object[0]);
                }
            }
        }
    }
}

