/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.rail.pricing;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.RzdReservationCreationParameters;
import com.gridnine.xtrip.common.ibecorp.model.RzdTraveller;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdBookingSegmentParams;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdGdsParameters;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.BookingRouteInfo;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.PricingParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.RestTraveller;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.common.createReservation.RzdPricingReservationCreationWrapperParamsProvider;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.common.createReservation.RzdReservationCreationWrapperProvider;
import com.gridnine.xtrip.server.ibus.IbusConfigurationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RailPricingCreateParamsBuilder
extends BaseProcessor {
    private boolean isBack;

    public void configure(Map<String, String> parameters) {
        String isBackStr = IbusConfigurationHelper.getOptionalParameter(parameters, (String)"isBack", (String)"false");
        this.isBack = Boolean.parseBoolean(isBackStr);
    }

    public void process(MessageContext ctx) throws Exception {
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        RzdGdsParameters gdsParams = (RzdGdsParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS);
        EntityReference supplierRef = (EntityReference)ctx.getObject((Enum)IBusRailwayContextKeys.RAILWAY_SUPPLIER_REF);
        PricingParameters pricingParameters = (PricingParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        PaymentType paymentType = (PaymentType)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.PAYMENT_TYPE);
        RzdReservationCreationParameters creationParameters = (RzdReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        List travellers = (List)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        ctx.putObject((Enum)IBusRailwayContextKeys.RAILWAY_CREATE_RESERVATION_PARAMETERS, (Object)this.buildCreateReservationParams(salesContext, creationParameters, gdsParams, travellers, (EntityReference<Organization>)supplierRef, pricingParameters, paymentType));
    }

    private RzdReservationCreationWrapperProvider buildCreateReservationParams(SalesContext salesContext, RzdReservationCreationParameters params, RzdGdsParameters gdsParams, List<Traveller> travellers, EntityReference<Organization> supplier, PricingParameters pricingParameters, PaymentType paymentType) throws Exception {
        RzdBookingSegmentParams segmentParams = this.isBack ? params.getSegmentBack() : params.getSegment();
        BookingRouteInfo routeInfo = this.isBack ? pricingParameters.getRouteInfoBack() : pricingParameters.getRouteInfo();
        int travellersSeatsCount = (int)pricingParameters.getTravellers().stream().map(RestTraveller::getType).filter(pt -> !DictHelper.isInfantPassengerTypeCategory((DictionaryReference)pt)).count();
        int seatsAmount = MiscUtil.guarded((Integer)segmentParams.getPlacing().getSeatsAmount());
        if (seatsAmount > travellersSeatsCount) {
            ArrayList<Traveller> newTravellers = new ArrayList<Traveller>(travellers);
            RzdReservationCreationParameters newParams = (RzdReservationCreationParameters)XCloneHelper.clone((XCloneable)params);
            RzdTraveller adult = newParams.getRzdTravellers().stream().filter(tr -> DictHelper.isAdultPassengerTypeCategory((DictionaryReference)tr.getPassengerType())).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"can't find adult traveller", (Object[])new Object[0]));
            Traveller traveller = (Traveller)CollectionUtil.find(travellers, (String)adult.getTravellerUid());
            for (int i = 0; i < seatsAmount - travellersSeatsCount; ++i) {
                RzdTraveller rzdTravellerClone = (RzdTraveller)XCloneHelper.clone((XCloneable)adult, (boolean)true);
                Traveller travellerClone = (Traveller)XCloneHelper.clone((XCloneable)traveller, (boolean)true);
                rzdTravellerClone.setTravellerUid(travellerClone.getUid());
                newParams.getRzdTravellers().add(rzdTravellerClone);
                newTravellers.add(travellerClone);
            }
            return new RzdPricingReservationCreationWrapperParamsProvider(salesContext, gdsParams, newParams, segmentParams, routeInfo, newTravellers, supplier, paymentType);
        }
        return new RzdPricingReservationCreationWrapperParamsProvider(salesContext, gdsParams, params, segmentParams, routeInfo, travellers, supplier, paymentType);
    }
}

