/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.rail.pricing;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.RzdReservationCreationParameters;
import com.gridnine.xtrip.common.ibecorp.model.helpers.TravelPolicyAuthorizationHelper;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdBookingSegmentParams;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdPrice;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.IntentionStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyImpositionResult;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.rest.InformationMessage;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.B2BRestHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.BookingRouteInfo;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.CarPlaceTypeData;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.PricingParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.PricingResult;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.RailInformationMessages;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.SeatRange;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.SeatsRequest;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.components.ReservationPriceComponents;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.HasTravelPolicyCompliance;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.Price;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.IBusTravelPolicyContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.BooleanUtils;

public class RailPricingResultBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) {
        PricingParameters parameters = (PricingParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityContainer bookingFile = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        RzdReservationCreationParameters createParams = (RzdReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        PriceComponentsParameters priceComponentsParams = PriceComponentsParameters.getB2BComponentsParameters((EntityReference<Person>)((EntityReference)ctx.getObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER)), salesContext);
        PricingResult result = this.buildResult((BookingFile)bookingFile.getEntity(), parameters, priceComponentsParams, createParams);
        Boolean isAutoTicketing = (Boolean)ctx.getObject((Enum)IBusTravelPolicyContextKeys.IS_TICKETING_AFTER_AUTHORIZATION_APPROVAL);
        if (BooleanUtils.isTrue((Boolean)isAutoTicketing)) {
            Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
            Reservation intentionReservation = (Reservation)ctx.getMandatoryObject((Enum)IBusRailwayContextKeys.INTENTION_OLD_RESERVATION);
            BigDecimal oldPrice = BookingHelper.getTotalPrice((Reservation)intentionReservation, (ContractType)ContractType.CLIENT);
            BigDecimal newPrice = BookingHelper.getTotalPrice((Reservation)reservation, (ContractType)ContractType.CLIENT);
            if (!TravelPolicyAuthorizationHelper.isPriceChangingInLimit((Reservation)intentionReservation, (BigDecimal)newPrice, (BigDecimal)oldPrice)) {
                reservation.setIntentionStatus(IntentionStatus.VARIANT_PRICE_CHANGED);
                ctx.putObject((Enum)IBusMidofficeContextKeys.PRICE_CHANGED, (Object)true);
                throw Xeption.forDeveloper((String)"\u0426\u0435\u043d\u0430 \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u0438\u0437\u043c\u0435\u043d\u0438\u043b\u0430\u0441\u044c \u0438 \u043d\u0435 \u0432\u0445\u043e\u0434\u0438\u0442 \u0432 \u043b\u0438\u043c\u0438\u0442 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u0438", (Object[])new Object[0]);
            }
        }
        this.setPriceUnknown(ctx, createParams, result);
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    private PricingResult buildResult(BookingFile booking, PricingParameters parameters, PriceComponentsParameters priceComponentsParams, RzdReservationCreationParameters createParams) {
        PricingResult result = new PricingResult();
        List reservations = BookingHelper.getReservationsForProduct((BookingFile)booking, (Class[])new Class[]{RailwayProduct.class});
        Reservation firstReservation = (Reservation)reservations.get(0);
        result.setPrice(this.buildPrice(firstReservation, priceComponentsParams, parameters.getRouteInfo()));
        if (parameters.getRouteInfoBack() != null) {
            result.setPriceBack(this.buildPrice((Reservation)reservations.get(1), priceComponentsParams, parameters.getRouteInfoBack()));
        }
        result.setTotalPrice(B2BRestHelper.calcTotalMoney(result.getPrice(), result.getPriceBack()));
        result.getTravellers().addAll(parameters.getTravellers());
        BookingStreamHelper.getProductsStream((Reservation)firstReservation, RailwayProduct.class).forEach(rp -> {
            TravelPolicyImpositionResult tpImpositionResult = TravelPolicyAuthorizationHelper.getTravelPolicyImpositionResult((BaseProduct)rp);
            CommonConverterHelper.mergeTravelPolicyInfo(tpImpositionResult, (HasTravelPolicyCompliance)result);
            RzdPrice tpImpositionResultHolder = createParams.getSegment().getRzdPrice();
            tpImpositionResultHolder.setTravelPolicyImpositionResult(tpImpositionResult);
        });
        return result;
    }

    private Price buildPrice(Reservation reservation, PriceComponentsParameters priceComponentsParams, BookingRouteInfo routeInfo) {
        Price result = ReservationPriceComponents.builder(reservation, priceComponentsParams).build().createPrice();
        result.setMinPriceRangeComponent(Boolean.valueOf(this.isMinPrice(routeInfo, reservation.getProducts().stream().filter(bp -> bp instanceof RailwayProduct).map(bp -> (RailwayProduct)bp).collect(Collectors.toList()))));
        return result;
    }

    private boolean isMinPrice(BookingRouteInfo routeInfo, List<RailwayProduct> products) {
        SeatRange range = routeInfo.getSeatsRequest().getRange();
        if (range == null || range.getFirst() == null || range.getSecond() == null) {
            return false;
        }
        if (this.requestedSeatWithPriceRange(routeInfo.getSeatsRequest(), routeInfo.getCarriage().getCarPlaceData())) {
            return true;
        }
        if (routeInfo.getCarriage().getSeatsGroupSize() > 1) {
            return false;
        }
        boolean hasChildPassenger = products.stream().anyMatch(product -> {
            List passengerTypes = RailwayProductHelper.getPassengerTypes((RailwayProduct)product);
            return !passengerTypes.contains(DictHelper.getAdultPassengerType()) && passengerTypes.contains(DictHelper.getChildPassengerType());
        });
        boolean seatsWithDifferentPriceRequested = this.seatsWithDifferentPriceRequested(routeInfo.getSeatsRequest(), routeInfo.getCarriage().getCarPlaceData());
        if (hasChildPassenger && seatsWithDifferentPriceRequested) {
            return true;
        }
        int numberOfSeatsRequested = range.getSecond() - range.getFirst() + 1;
        long adultPassengersCount = products.stream().filter(prod -> RailwayProductHelper.getPassengerTypes((RailwayProduct)prod).contains(DictHelper.getAdultPassengerType())).count();
        return !hasChildPassenger && seatsWithDifferentPriceRequested && (long)numberOfSeatsRequested > adultPassengersCount;
    }

    private boolean requestedSeatWithPriceRange(SeatsRequest seatsRequest, List<CarPlaceTypeData> carPlaceTypeDataList) {
        int start = seatsRequest.getRange().getFirst();
        int end = seatsRequest.getRange().getSecond();
        block0: for (int i = start; i <= end; ++i) {
            String seat = String.valueOf(i);
            for (CarPlaceTypeData carPlaceTypeData : carPlaceTypeDataList) {
                for (String availableSeat : carPlaceTypeData.getAvailableSeats()) {
                    if (!seat.equals(availableSeat)) continue;
                    if (carPlaceTypeData.getPrice().getPriceRange() == null) continue block0;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean seatsWithDifferentPriceRequested(SeatsRequest seatsRequest, List<CarPlaceTypeData> carPlaceTypeDataList) {
        int start = seatsRequest.getRange().getFirst();
        int end = seatsRequest.getRange().getSecond();
        BigDecimal price = null;
        block0: for (int i = start; i <= end; ++i) {
            String seat = String.valueOf(i);
            for (CarPlaceTypeData carPlaceTypeData : carPlaceTypeDataList) {
                for (String availableSeat : carPlaceTypeData.getAvailableSeats()) {
                    if (!seat.equals(availableSeat)) continue;
                    if (price == null) {
                        price = carPlaceTypeData.getPrice().getPriceGds();
                        continue block0;
                    }
                    if (price.equals(carPlaceTypeData.getPrice().getPriceGds())) continue block0;
                    return true;
                }
            }
        }
        return false;
    }

    private void setPriceUnknown(MessageContext ctx, RzdReservationCreationParameters createParams, PricingResult pricingResult) {
        pricingResult.setUnknownPrice(this.priceUnknown(createParams));
        if (pricingResult.isUnknownPrice()) {
            Collection<InformationMessage> messages = B2BRestHelper.getMessages(ctx);
            messages.add(this.getTrailerCarUnknownPriceWarning());
        }
    }

    private InformationMessage getTrailerCarUnknownPriceWarning() {
        return RailInformationMessages.getTrailerCarUnknownPriceWarning();
    }

    private boolean priceUnknown(RzdReservationCreationParameters createParams) {
        return this.priceUnknown(createParams.getSegment()) || this.priceUnknown(createParams.getSegmentBack());
    }

    private boolean priceUnknown(RzdBookingSegmentParams segmentParams) {
        return segmentParams != null && segmentParams.getRzdPrice() != null && segmentParams.getRzdPrice().getPrice() != null && segmentParams.getRzdPrice().getPrice().getOriginalMin() != null && BigDecimal.ZERO.compareTo(segmentParams.getRzdPrice().getPrice().getOriginalMin()) == 0;
    }
}

