/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.rail.sendToApprove;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.RzdReservationCreationParameters;
import com.gridnine.xtrip.common.ibecorp.model.RzdTraveller;
import com.gridnine.xtrip.common.ibecorp.model.b2b.rest.common.RestTrainToken;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdBookingSegmentParams;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.StandardValidationMessages;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.B2BRestHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.ApproveBookingRouteInfo;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.BookingRouteInfo;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.RailwaySendToApproveParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.rail.ReservationParamsConverter;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonRestHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonValidationHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.IBusIbeCorpContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RailwayCreateIntentionParametersConverter
extends ReservationParamsConverter {
    @Override
    public void process(MessageContext ctx) throws Exception {
        ArrayList<Traveller> availableTravellers;
        RestTrainToken token;
        RailwaySendToApproveParameters parameters = (RailwaySendToApproveParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        if (parameters.isSendEmail()) {
            CommonValidationHelper.validationEmailMessages(parameters.getEmails(), parameters.getValidationContext().getEmailsListValidationMessages());
        }
        if (!parameters.getRouteInfos().isEmpty()) {
            token = CommonRestHelper.decodeToken(((ApproveBookingRouteInfo)parameters.getRouteInfos().get(0)).getRouteInfo().getTrain().getToken(), RestTrainToken.class);
            if (token.getClient() != null) {
                salesContext.setClient(token.getClient());
            }
        } else {
            parameters.getValidationContext().getRouteInfosValidationMessages().add(StandardValidationMessages.getEmptyCollection());
            throw new ValidationException();
        }
        List passengers = token.getSelectedPassengers();
        Map passengersTypes = token.getPassengersTypes();
        EntityReference bookingFile = token.getBookingFile();
        ArrayList<Traveller> travellers = new ArrayList<Traveller>();
        HashMap<Traveller, Object> tm = new HashMap<Traveller, Object>();
        EntityContainer bfCtr = EntityStorage.get().resolve(bookingFile);
        ArrayList<Object> arrayList = availableTravellers = bfCtr != null ? new ArrayList<Traveller>(((BookingFile)bfCtr.getEntity()).getTravellers()) : new ArrayList();
        if (null == passengers || passengers.isEmpty()) {
            for (Map.Entry entry : passengersTypes.entrySet()) {
                DictionaryReference type = (DictionaryReference)entry.getKey();
                int count = (Integer)entry.getValue();
                for (int i = 0; i < count; ++i) {
                    Traveller traveller = CommonConverterHelper.getIfEmptyTraveller(travellers, availableTravellers);
                    tm.put(traveller, type);
                }
            }
        } else {
            for (EntityReference personRef : passengers) {
                CommonConverterHelper.getTraveller(travellers, availableTravellers, (EntityReference<Person>)personRef);
            }
        }
        ArrayList<RzdReservationCreationParameters> reservationCreationParameters = new ArrayList<RzdReservationCreationParameters>();
        HashMap<RzdBookingSegmentParams, BookingRouteInfo> routeInfoMap = new HashMap<RzdBookingSegmentParams, BookingRouteInfo>();
        for (ApproveBookingRouteInfo approveBookingInfo : parameters.getRouteInfos()) {
            BookingRouteInfo routeInfo = approveBookingInfo.getRouteInfo();
            RzdReservationCreationParameters railwayParameters = new RzdReservationCreationParameters();
            RzdBookingSegmentParams segmentParams = this.buildBookingSegment(routeInfo, null);
            railwayParameters.setSegment(segmentParams);
            railwayParameters.setGdsAccount(railwayParameters.getSegment().getTrain().getGdsAccount());
            for (Traveller traveller : travellers) {
                RzdTraveller rzdTraveller = new RzdTraveller();
                DictionaryReference passengerType = (DictionaryReference)tm.get(traveller);
                if (null == passengerType) {
                    passengerType = DictHelper.getAdultPassengerType();
                }
                rzdTraveller.setPassengerType(passengerType);
                rzdTraveller.setTariff(RzdCommonHelper.getRzdTariff((DictionaryReference)passengerType));
                rzdTraveller.setTravellerUid(traveller.getUid());
                rzdTraveller.setNonRefundableTariff(false);
                railwayParameters.getRzdTravellers().add(rzdTraveller);
            }
            reservationCreationParameters.add(railwayParameters);
            routeInfoMap.put(segmentParams, routeInfo);
        }
        Customer customer = B2BRestHelper.createCustomer((Traveller)travellers.get(0), salesContext);
        ctx.putObject((Enum)IBusMidofficeContextKeys.TRAVELLERS, travellers);
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATIONS_CREATION_PARAMETERS, reservationCreationParameters);
        ctx.putObject((Enum)IBusRailwayContextKeys.ROUTE_INFO, routeInfoMap);
        ctx.putObject((Enum)IBusMidofficeContextKeys.CUSTOMER, (Object)customer);
        if (bookingFile != null) {
            ctx.putObject((Enum)IBusMidofficeContextKeys.ADD_TO_BOOKING_FILE, (Object)bookingFile);
        }
        ctx.putObject((Enum)IBusIbeCorpContextKeys.IS_PROPOSAL, (Object)Boolean.TRUE);
    }
}

