/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.search;

import com.gridnine.xtrip.common.gds.model.RouteType;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.B2BRestHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.SearchTrainsResponse;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.search.IBusIbecorpB2BSearchCtxKeys;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.BaseRoute;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.CommonSearchParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class AviaSearchParametersToRailConverter
extends BaseProcessor {
    public void process(MessageContext ctx) {
        Set<RailwayStation> departureStations;
        BaseRoute route;
        Set<RailwayStation> arrivalStations;
        CommonSearchParameters commonParams = (CommonSearchParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        List<CommonSearchParameters> multiSearchParams = this.splitIntoManySearchParameters(commonParams, arrivalStations = B2BRestHelper.getRailwayStationsFromGeolocationCode((route = (BaseRoute)commonParams.getRoutes().get(0)).getArrivalCode()), departureStations = B2BRestHelper.getRailwayStationsFromGeolocationCode(route.getDepartureCode()));
        if (multiSearchParams == null) {
            ctx.putObject((Enum)IBusIbecorpB2BSearchCtxKeys.RAIL_REST_RESULT, (Object)new SearchTrainsResponse());
            this.log.warn("Cant find railway stations in dictionary from current geolocations: " + route.getDepartureCode() + "-" + route.getArrivalCode());
            return;
        }
        ctx.putObject((Enum)IBusRestContextKeys.REST_PARAMS, multiSearchParams);
    }

    private List<CommonSearchParameters> splitIntoManySearchParameters(CommonSearchParameters params, Set<RailwayStation> arrivalStations, Set<RailwayStation> departureStations) {
        RailwayStation departureStation;
        RailwayStation arrivalStation = B2BRestHelper.getMostRelevantRailwayStation(arrivalStations);
        if (arrivalStation != null) {
            arrivalStations = Collections.singleton(arrivalStation);
        }
        if ((departureStation = B2BRestHelper.getMostRelevantRailwayStation(departureStations)) != null) {
            departureStations = Collections.singleton(departureStation);
        }
        if (arrivalStations.isEmpty() || departureStations.isEmpty()) {
            return null;
        }
        Set<RailwayStation> departureStationsForLambda = departureStations;
        return arrivalStations.stream().flatMap(as -> departureStationsForLambda.stream().map(ds -> {
            CommonSearchParameters p = this.copyCommonSearchParameters(params);
            BaseRoute route = (BaseRoute)p.getRoutes().get(0);
            route.setArrivalCode(as.getCode());
            route.setDepartureCode(ds.getCode());
            if (p.getRouteType() == RouteType.ROUNDTRIP) {
                BaseRoute routeBack = (BaseRoute)p.getRoutes().get(1);
                routeBack.setDepartureCode(as.getCode());
                routeBack.setArrivalCode(ds.getCode());
            }
            return p;
        })).collect(Collectors.toList());
    }

    private CommonSearchParameters copyCommonSearchParameters(CommonSearchParameters params) {
        CommonSearchParameters p = new CommonSearchParameters();
        p.setClassOfService(params.getClassOfService());
        p.setDirect(params.isDirect());
        p.setRouteType(params.getRouteType());
        p.setSearchType(params.getSearchType());
        p.getRoutes().addAll(params.getRoutes().stream().map(r -> {
            BaseRoute cloneRoute = new BaseRoute();
            cloneRoute.setDate(r.getDate());
            cloneRoute.setDepartureTimeWindowEnd(r.getDepartureTimeWindowEnd());
            cloneRoute.setDepartureTimeWindowStart(r.getDepartureTimeWindowStart());
            return cloneRoute;
        }).collect(Collectors.toList()));
        return p;
    }
}

