/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.search;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.CommonSearchParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.MessageResult;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.ServiceType;
import com.gridnine.xtrip.server.ibecorp.helpers.IbecorpRulesHelper;
import com.gridnine.xtrip.server.ibecorp.l10n.Messages;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public class CheckSearchParametersProcessor
extends BaseProcessor {
    private static final EnumSet CHECK_MISSING_PARAMS_SEARCH_TYPES = EnumSet.of(ServiceType.AVIA, ServiceType.RAIL);
    private static final Map<ServiceType, TravelSubject> serviceType2TravelSubjectMap = new HashMap<ServiceType, TravelSubject>();

    public void process(MessageContext ctx) throws Exception {
        CommonSearchParameters parameters = (CommonSearchParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        salesContext.setClient(parameters.getClient());
        Collection personRefs = MiscUtil.guarded((Collection)parameters.getPassengers());
        List<Person> persons = personRefs.stream().distinct().map(arg_0 -> ((EntityStorage)EntityStorage.get()).resolve(arg_0)).filter(EntityStorageHelper::nonEmpty).map(EntityContainer::getEntity).collect(Collectors.toList());
        MessageResult result = new MessageResult();
        if (this.hasEmptyMandatoryPersonField(persons) && IbecorpRulesHelper.getBookingTravellersEditingActionsSet(salesContext, CheckSearchParametersProcessor.convertServiceTypeToTravelSubject(parameters.getSearchType())).isForbidTravellerEditing()) {
            result.setMessage(L10nResourcesManager.getStr((String)Messages.MISSING_MANDATORY_PERSON_DATA, (Object[])new Object[0]));
            result.setAbortProcess(Boolean.valueOf(true));
        } else if (CHECK_MISSING_PARAMS_SEARCH_TYPES.contains(parameters.getSearchType())) {
            String message = persons.stream().map(this::getMissingParameters).filter(TextUtil::nonBlank).collect(Collectors.joining("<br>"));
            result.setMessage(message);
        }
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    private String buildMessageForPerson(Person person, List<String> missingParameters) {
        return L10nResourcesManager.getStr((String)Messages.MISSING_FROM_PASSENGER_PROFILE, (Object[])new Object[]{MiscUtil.guarded((String)person.getLastName().toString()), MiscUtil.guarded((String)person.getFirstName().toString()), MiscUtil.guarded((String)person.getMiddleName().toString()), String.join((CharSequence)", ", missingParameters)});
    }

    private String getMissingParameters(Person person) {
        List passports;
        ArrayList<String> missingParameters = new ArrayList<String>();
        Date birthday = person.getBirthday();
        if (birthday == null) {
            missingParameters.add(L10nResourcesManager.getStr((String)Messages.MISSING_BIRTHDAY, (Object[])new Object[0]));
        }
        if (CollectionUtil.isEmpty((Collection)(passports = person.getPassports()))) {
            missingParameters.add(L10nResourcesManager.getStr((String)Messages.MISSING_PASSPORT, (Object[])new Object[0]));
        } else {
            String numberPassports = this.checkDocType(passports);
            if (TextUtil.nonBlank((String)numberPassports)) {
                missingParameters.add(L10nResourcesManager.getStr((String)Messages.MISSING_DOCUMENT_TYPE, (Object[])new Object[]{numberPassports}));
            }
        }
        return missingParameters.isEmpty() ? null : this.buildMessageForPerson(person, missingParameters);
    }

    private String checkDocType(List<Passport> passports) {
        return passports.stream().filter(passport -> passport.getType() == null).map(Passport::getNumber).filter(TextUtil::nonBlank).collect(Collectors.joining(", "));
    }

    private boolean hasEmptyMandatoryPersonField(List<Person> persons) {
        return persons.stream().anyMatch(p -> !this.hasMandatoryPersonValues((Person)p));
    }

    private boolean hasMandatoryPersonValues(Person person) {
        for (Locale locale : Arrays.asList(LocaleUtil.LOCALE_EN, LocaleUtil.LOCALE_RU)) {
            String lastName = L10nStringHelper.getValue((L10nString)person.getLastName(), (Locale)locale, (boolean)true);
            String firstName = L10nStringHelper.getValue((L10nString)person.getFirstName(), (Locale)locale, (boolean)true);
            if (!TextUtil.nonBlank((String)lastName) || !TextUtil.nonBlank((String)firstName)) continue;
            return true;
        }
        return false;
    }

    private static TravelSubject convertServiceTypeToTravelSubject(ServiceType serviceType) {
        return serviceType2TravelSubjectMap.get(serviceType);
    }

    static {
        serviceType2TravelSubjectMap.put(ServiceType.AVIA, TravelSubject.AIR);
        serviceType2TravelSubjectMap.put(ServiceType.RAIL, TravelSubject.RAILWAY);
        serviceType2TravelSubjectMap.put(ServiceType.HOTEL, TravelSubject.HOTEL_RESERVATION);
        serviceType2TravelSubjectMap.put(ServiceType.TRANSFER, TravelSubject.TRANSFER);
    }
}

