/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.search;

import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.autocomplete.organizations.CorporateClientHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.SearchFlightsParametersValidationMessages;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.BaseSearchParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

public class CommonSearchCorporateDataParametersValidator
extends BaseProcessor {
    public void process(MessageContext ctx) {
        BookingFile bookingFile;
        BaseSearchParameters params = (BaseSearchParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityReference currentOrgRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.CURRENT_ORGANIZATION);
        EntityContainer currentOrg = EntityStorage.get().resolve(currentOrgRef);
        EntityReference client = params.getClient();
        boolean isAgency = ((Organization)currentOrg.getEntity()).getTypes().contains(OrganizationType.AGENCY);
        if (params.getBooking() != null && !Objects.equals((bookingFile = (BookingFile)EntityStorage.get().resolve(params.getBooking()).getEntity()).getCustomerProfile(), client)) {
            params.getValidationContext().getClientValidationMessages().add(SearchFlightsParametersValidationMessages.getWrongClientAdditionalProduct((String)bookingFile.getNumber()));
        }
        if (!isAgency || CorporateClientHelper.hasOrganizationCorporateClients((EntityContainer<Organization>)currentOrg)) {
            EntityContainer defaultRetailClient;
            if (client == null) {
                params.getValidationContext().getClientValidationMessages().add(SearchFlightsParametersValidationMessages.getInvalidClient());
            }
            if (CollectionUtil.isEmpty((Collection)params.getPassengers()) && ((defaultRetailClient = ProfileHelper.getRetailProfileContainer()) == null || !defaultRetailClient.toReference().equals((Object)client))) {
                params.getValidationContext().getPassengersValidationMessages().add(SearchFlightsParametersValidationMessages.getInvalidPassenger());
            }
            for (int i = 0; i < params.getPassengers().size(); ++i) {
                EntityReference personRef = (EntityReference)params.getPassengers().get(i);
                if (personRef != null && !TextUtil.isBlank((String)personRef.getUid())) continue;
                params.getValidationContext().getPassengersListValidationMessages().put(i, Collections.singletonList(SearchFlightsParametersValidationMessages.getInvalidPassenger()));
            }
            if (!params.getValidationContext().getPassengersListValidationMessages().isEmpty()) {
                throw new ValidationException();
            }
        }
    }
}

