/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.search;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.midoffice.model.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.OperationBatch;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSearchParameters;
import com.gridnine.xtrip.common.model.ibecorp.sm.AviaDuplicatesCheckParameters;
import com.gridnine.xtrip.common.model.ibecorp.sm.BaseDuplicatesCheckParameters;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMBookingControlSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.duplicates.DupesMessageHelper;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.MessageResult;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.SearchDuplicatesParameters;
import com.gridnine.xtrip.server.ibecorp.l10n.Messages;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class GetSearchDuplicatesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SearchDuplicatesParameters params = (SearchDuplicatesParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        SalesContext salesCtx = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        SMBookingControlSettings bookingControlSettings = Objects.requireNonNull(CommonHelper.getBookingControlSettings((EntityReference<SMSite>)salesCtx.getSite()));
        List parameters = bookingControlSettings.getDuplicatesCheckParameters().stream().filter(p -> p.getProductType() != ProductType.AIR_TICKET).collect(Collectors.toList());
        parameters.addAll(bookingControlSettings.getDuplicatesCheckParameters().stream().filter(p -> p.getProductType() == ProductType.AIR_TICKET).map(p -> (AviaDuplicatesCheckParameters)p).filter(p -> p.getAirline() == null).collect(Collectors.toList()));
        MessageResult result = new MessageResult();
        if (CollectionUtil.isEmpty((Collection)params.getTravellers()) || params.getFirstTravelDate() == null || params.getLastTravelDate() == null) {
            ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
            return;
        }
        ArrayList dupesMessages = new ArrayList();
        String linkPath = DupesMessageHelper.getPath((SMSite)EntityStorage.get().resolve(salesCtx.getSite()).getEntity());
        SearchResult searchResult = new SearchResult();
        for (EntityReference traveller : params.getTravellers()) {
            if (traveller == null) continue;
            for (BaseDuplicatesCheckParameters parameter : parameters) {
                SearchQuery query = this.createSearchQuery((EntityReference<Person>)traveller, MiscUtil.clearTime((Date)DateUtils.toJavaDate((LocalDate)params.getFirstTravelDate())), MiscUtil.setDayEndTime((Date)DateUtils.toJavaDate((LocalDate)params.getLastTravelDate())), parameter.getProductType(), new HashSet<ProductStatus>(parameter.getCheckedStatuses()));
                query.getPreferredProperties().add(CommonProductIndex.Property.productType.name());
                query.getPreferredProperties().add(CommonProductIndex.Property.bookingNumber.name());
                SearchResult travellerResult = EntityStorage.get().search(CommonProductIndex.class, query, (EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true));
                if (CollectionUtil.isEmpty((Collection)travellerResult.getData())) continue;
                searchResult.getData().addAll(travellerResult.getData());
            }
        }
        Map<EntityReference, List<CommonProductIndex>> map = searchResult.getData().stream().collect(Collectors.groupingBy(CommonProductIndex::getSource));
        map.forEach((key, value) -> {
            String service = value.size() > 1 ? "\u0443\u0441\u043b\u0443\u0433\u0438" : "\u0443\u0441\u043b\u0443\u0433\u0430";
            Map<ProductType, List<CommonProductIndex>> typesMap = value.stream().collect(Collectors.groupingBy(CommonProductIndex::getProductType));
            StringBuilder sb = new StringBuilder();
            typesMap.forEach((k, v) -> {
                sb.append(k.toString().toLowerCase());
                sb.append(", ");
            });
            String types = typesMap.size() > 1 ? "\u0442\u0438\u043f\u044b" : "\u0442\u0438\u043f";
            dupesMessages.add(String.format("%s (%s: %s\u0437\u0430\u043a\u0430\u0437 %s)", service, types, sb, DupesMessageHelper.getDupeLink(linkPath, key.getUid(), key.getCaption())));
        });
        if (CollectionUtil.isEmpty(dupesMessages)) {
            ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
            return;
        }
        String dateMessage = params.getFirstTravelDate().equals(params.getLastTravelDate()) ? params.getFirstTravelDate().toString() : L10nResourcesManager.getStr((String)Messages.SEARCH_DUPES_INTERVAL_MESSAGE, (Object[])new Object[]{params.getFirstTravelDate(), params.getLastTravelDate()});
        String message = L10nResourcesManager.getStr((String)Messages.SEARCH_DUPES_MESSAGE, (Object[])new Object[]{dateMessage, String.join((CharSequence)", ", dupesMessages)});
        result.setMessage(message);
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    private SearchQuery createSearchQuery(EntityReference<Person> passenger, Date firstDate, Date lastDate, ProductType productType, Set<ProductStatus> statuses) {
        SearchQuery searchQuery = new SearchQuery();
        List searchCriterions = searchQuery.getCriteria().getCriterions();
        ArrayList<SearchCriterion> statusCriterions = new ArrayList<SearchCriterion>();
        if (statuses.remove(ProductStatus.SELL)) {
            statusCriterions.add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)CommonProductIndex.Property.status.name(), (Object)ProductStatus.SELL), SearchCriterion.ne((String)CommonProductIndex.Property.operationBatch.name(), (Object)OperationBatch.EXCHANGE)}));
        }
        for (ProductStatus status : statuses) {
            statusCriterions.add(SearchCriterion.eq((String)CommonProductIndex.Property.status.name(), (Object)status));
        }
        searchCriterions.add(SearchCriterion.or((SearchCriterion[])statusCriterions.toArray(new SearchCriterion[0])));
        searchCriterions.add(SearchCriterion.eq((String)CommonProductIndex.Property.productType.name(), (Object)productType));
        searchCriterions.add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)CommonProductIndex.Property.hotelCheckOutDate.name(), (Object)firstDate), SearchCriterion.le((String)CommonProductIndex.Property.hotelCheckInDate.name(), (Object)lastDate)}), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)CommonProductIndex.Property.lastArrivalDate.name(), (Object)firstDate), SearchCriterion.le((String)CommonProductIndex.Property.firstDepartureDate.name(), (Object)lastDate)}), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)CommonProductIndex.Property.lastTravelDate.name(), null), SearchCriterion.ge((String)CommonProductIndex.Property.firstTravelDate.name(), (Object)firstDate), SearchCriterion.le((String)CommonProductIndex.Property.firstTravelDate.name(), (Object)lastDate)})}));
        searchCriterions.add(SearchCriterion.contains((String)CommonProductIndex.Property.passengers.name(), passenger));
        searchCriterions.add(SearchCriterion.isEmpty((String)CommonProductIndex.Property.nextProductUid.name()));
        return searchQuery;
    }
}

