/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.search;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.entity.EntityActualizer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.search.SearchFormDataHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.Order;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.OrderRoute;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.RoutePoint;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.SearchFormDataOrder;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.SearchFormDataParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.SearchFormDataResult;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.ServiceType;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class GetSearchFormDataBuildOrderProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        RailwaySegment firstSegment;
        OrderRoute route3;
        List segments;
        SearchFormDataParameters params = (SearchFormDataParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        SearchFormDataResult result = new SearchFormDataResult();
        EntityActualizer actualizer = EntityActualizer.newInstance();
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
        if (params.getBooking() == null) {
            return;
        }
        EntityContainer bookingFileCtr = EntityStorage.get().resolve(params.getBooking());
        BookingFile bookingFile = (BookingFile)bookingFileCtr.getEntity();
        SearchFormDataOrder order = new SearchFormDataOrder();
        CommonConverterHelper.populateOrder((Order)order, (EntityContainer<BookingFile>)bookingFileCtr);
        order.setClient(bookingFile.getCustomerProfile());
        bookingFile.getTravellers().stream().map(Traveller::getPassenger).filter(Objects::nonNull).peek(arg_0 -> ((EntityActualizer)actualizer).actualize(arg_0)).forEach(order.getPassengers()::add);
        ServiceType fromType = null;
        BaseProduct product = bookingFile.getReservations().stream().flatMap(r -> r.getProducts().stream()).findFirst().orElse(null);
        if (product instanceof Product) {
            fromType = ServiceType.AVIA;
            Product air = (Product)product;
            segments = air.getSegmentTariffs().stream().flatMap(s -> s.getSegments().stream()).collect(Collectors.toList());
            if (!segments.isEmpty()) {
                route3 = new OrderRoute();
                firstSegment = (Segment)segments.get(0);
                route3.setDeparturePoint(SearchFormDataHelper.getGeoCity((DictionaryReference<GeoLocation>)firstSegment.getDepartureLocation()));
                route3.setDate(MiscUtil.toLocalDate((Date)firstSegment.getStartDate()));
                RoutePoint arrivePoint = SearchFormDataHelper.getGeoCity((DictionaryReference<GeoLocation>)((Segment)segments.get(segments.size() - 1)).getArriveLocation());
                if (route3.getDeparturePoint() != null && arrivePoint != null && !Objects.equals(route3.getDeparturePoint().getCode(), arrivePoint.getCode()) || route3.getDeparturePoint() != null && arrivePoint == null || route3.getDeparturePoint() == null && arrivePoint != null) {
                    route3.setArrivalPoint(arrivePoint);
                } else {
                    route3.setArrivalPoint(SearchFormDataHelper.getGeoCity((DictionaryReference<GeoLocation>)firstSegment.getArriveLocation()));
                }
                order.getRoutes().add(route3);
            }
        } else if (product instanceof RailwayProduct) {
            fromType = ServiceType.RAIL;
            RailwayProduct rail = (RailwayProduct)product;
            segments = rail.getSegments();
            if (!segments.isEmpty()) {
                route3 = new OrderRoute();
                firstSegment = (RailwaySegment)segments.get(0);
                route3.setDeparturePoint(SearchFormDataHelper.getStationCity((DictionaryReference<RailwayStation>)firstSegment.getDepartureStation()));
                route3.setDate(MiscUtil.toLocalDate((Date)firstSegment.getDepartureDate()));
                route3.setArrivalPoint(SearchFormDataHelper.getStationCity((DictionaryReference<RailwayStation>)firstSegment.getArriveStation()));
                order.getRoutes().add(route3);
            }
        } else if (product instanceof HotelProduct) {
            fromType = ServiceType.HOTEL;
            HotelProduct hotel = (HotelProduct)product;
            OrderRoute route2 = new OrderRoute();
            route2.setDate(MiscUtil.toLocalDate((Date)HotelProductHelper.getCheckInDate((HotelProduct)hotel)));
            route2.setArrivalPoint(SearchFormDataHelper.getHotelCity((DictionaryReference<GeoLocation>)hotel.getHotelLocation()));
            order.getRoutes().add(route2);
        }
        ServiceType toType = params.getSearchType();
        if (SearchFormDataHelper.convertNeeded(fromType, toType)) {
            for (OrderRoute route3 : order.getRoutes()) {
                route3.setDeparturePoint(SearchFormDataHelper.convert(route3.getDeparturePoint(), fromType, toType));
                route3.setArrivalPoint(SearchFormDataHelper.convert(route3.getArrivalPoint(), fromType, toType));
            }
        }
        result.setOrder(order);
    }
}

