/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.search;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.entity.EntityActualizer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.search.SearchFormDataHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.search.SegmentHolder;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.search.TravelerGroupRoutesHolder;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.Order;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.OrderRoute;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.SearchFormDataOrder;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.SearchFormDataParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.SearchFormDataResult;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class GetSearchFormDataBuildOrderToHotelProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SearchFormDataParameters params = (SearchFormDataParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        SearchFormDataResult result = new SearchFormDataResult();
        EntityActualizer actualizer = EntityActualizer.newInstance();
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
        if (params.getBooking() == null) {
            return;
        }
        EntityContainer bookingFileCtr = EntityStorage.get().resolve(params.getBooking());
        BookingFile bookingFile = (BookingFile)bookingFileCtr.getEntity();
        SearchFormDataOrder order = new SearchFormDataOrder();
        CommonConverterHelper.populateOrder((Order)order, (EntityContainer<BookingFile>)bookingFileCtr);
        order.setClient(bookingFile.getCustomerProfile());
        HashMap travellerMap = new HashMap();
        List products = BookingHelper.getProducts((BookingFile)bookingFile);
        products = products.stream().filter(product -> {
            ProductStatus status = ProductHandler.of((BaseProduct)product).getStatus(product);
            return status == ProductStatus.SELL || status == ProductStatus.BOOKING || status == ProductStatus.INTENTION;
        }).filter(product -> {
            BaseProduct nextProduct = ProductHandler.of((BaseProduct)product).getNextProduct(product);
            return nextProduct == null;
        }).collect(Collectors.toList());
        for (BaseProduct product2 : products) {
            ProductHandler.of((BaseProduct)product2).getTravellers(product2).forEach(traveller -> {
                Traveller key = traveller;
                for (Traveller k : travellerMap.keySet()) {
                    boolean equalsPassengers = MiscUtil.equals((Object)k.getPassenger(), (Object)traveller.getPassenger(), (boolean)false);
                    if (!k.equals(traveller) && !equalsPassengers) continue;
                    key = k;
                }
                travellerMap.computeIfAbsent(key, t -> new ArrayList()).add(product2);
            });
        }
        List holders = travellerMap.entrySet().stream().map(entry -> new TravelerGroupRoutesHolder((Traveller)entry.getKey(), (List)entry.getValue())).collect(Collectors.toList());
        LinkedList<MiscUtil.Pair> segmentHolderPairs = new LinkedList<MiscUtil.Pair>();
        block1: for (TravelerGroupRoutesHolder holder : holders) {
            Iterator<SegmentHolder> iterator = holder.getRoutes().iterator();
            while (iterator.hasNext()) {
                boolean hotelExist;
                SegmentHolder segmentHolder = iterator.next();
                DictionaryReference<GeoLocation> arrivalPoint = segmentHolder.getArrivalPoint();
                Date arriveDate = MiscUtil.clearTime((Date)segmentHolder.getArriveDate());
                Date startDate = MiscUtil.addDaysToDate((Date)arriveDate, (int)-1);
                Date endDate = MiscUtil.addDaysToDate((Date)arriveDate, (int)1);
                List<HotelProduct> hotelProducts = holder.getHotelProducts().get(arrivalPoint);
                if (hotelProducts != null && (hotelExist = hotelProducts.stream().map(HotelProductHelper::getCheckInDate).anyMatch(checkInDate -> MiscUtil.isBetween((Date)startDate, (Date)endDate, (Date)checkInDate)))) continue;
                SegmentHolder backSegmentHolder = null;
                while (iterator.hasNext()) {
                    SegmentHolder nextSegmentHolder = iterator.next();
                    if (!MiscUtil.equals(arrivalPoint, nextSegmentHolder.getDeparturePoint(), (boolean)false)) continue;
                    backSegmentHolder = nextSegmentHolder;
                    break;
                }
                segmentHolderPairs.add(MiscUtil.Pair.of((Object)segmentHolder, backSegmentHolder));
                continue block1;
            }
        }
        SegmentHolder segmentHolder = null;
        SegmentHolder backSegmentHolder = null;
        MiscUtil.Pair firstPair = (MiscUtil.Pair)CollectionUtil.head(segmentHolderPairs);
        if (firstPair != null) {
            segmentHolder = (SegmentHolder)firstPair.getFirst();
            backSegmentHolder = (SegmentHolder)firstPair.getSecond();
        }
        if (segmentHolder != null) {
            OrderRoute route = new OrderRoute();
            route.setDeparturePoint(SearchFormDataHelper.getHotelCity(segmentHolder.getDeparturePoint()));
            route.setArrivalPoint(SearchFormDataHelper.getHotelCity(segmentHolder.getArrivalPoint()));
            route.setDate(MiscUtil.toLocalDate((Date)segmentHolder.getArriveDate()));
            route.setEndDate(backSegmentHolder != null ? MiscUtil.toLocalDate((Date)backSegmentHolder.getDepartureDate()) : null);
            order.getRoutes().add(route);
            for (MiscUtil.Pair holderPair : segmentHolderPairs) {
                SegmentHolder firstSegmentHolder = (SegmentHolder)holderPair.getFirst();
                if (!MiscUtil.equals((Object)segmentHolder, (Object)firstSegmentHolder)) continue;
                Collection travellers = ProductHandler.of((BaseProduct)firstSegmentHolder.getProduct()).getTravellers(firstSegmentHolder.getProduct());
                travellers.stream().map(Traveller::getPassenger).filter(Objects::nonNull).peek(arg_0 -> ((EntityActualizer)actualizer).actualize(arg_0)).forEach(order.getPassengers()::add);
            }
        }
        result.setOrder(order);
    }
}

