/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.search;

import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictSearchCriterion;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.B2BRestHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.GeoLocationReference;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.RoutePoint;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.ServiceType;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class SearchFormDataHelper {
    public static RoutePoint getHotelCity(DictionaryReference<GeoLocation> hotelLocation) {
        GeoLocation city = (GeoLocation)DictHelper.resolve(hotelLocation);
        if (null == city) {
            return null;
        }
        RoutePoint result = new RoutePoint();
        result.setCode((String)city.getCodeVariants().get(CodeSystem.HOTEL_AGGREGATOR.name()));
        result.setCaption(city.toString(LocaleManager.get().getCurrentLocale()));
        return result;
    }

    public static boolean convertNeeded(ServiceType fromType, ServiceType toType) {
        return fromType != toType;
    }

    public static RoutePoint convert(RoutePoint point, ServiceType fromType, ServiceType toType) {
        RailwayStation railwayStation;
        DictionaryReference location;
        if (null == point || null == fromType) {
            return null;
        }
        switch (fromType) {
            case AVIA: {
                Set gls = DictionaryCache.get().lookup(GeoLocation.class, point.getCode(), new String[]{CodeSystem.IATA.name(), CodeSystem.CRT.name()});
                location = !gls.isEmpty() ? DictHelper.getCity((DictionaryReference)((GeoLocation)gls.iterator().next()).toReference()) : null;
                break;
            }
            case RAIL: {
                railwayStation = (RailwayStation)DictionaryCache.get().findByCode(RailwayStation.class, point.getCode());
                location = railwayStation != null ? DictHelper.getCity((DictionaryReference)railwayStation.getGeoLocation()) : null;
                break;
            }
            case HOTEL: {
                Set gls2 = DictionaryCache.get().lookup(GeoLocation.class, point.getCode(), new String[]{CodeSystem.HOTEL_AGGREGATOR.name()});
                location = !gls2.isEmpty() ? ((GeoLocation)gls2.iterator().next()).toReference() : null;
                break;
            }
            default: {
                return null;
            }
        }
        if (null == location) {
            return null;
        }
        switch (toType) {
            case AVIA: {
                return SearchFormDataHelper.getGeoCity((DictionaryReference<GeoLocation>)location);
            }
            case RAIL: {
                Set<RailwayStation> stations = B2BRestHelper.getRailwayStationsFromGeolocationCode((DictionaryReference<GeoLocation>)location);
                if (stations.size() == 1) {
                    railwayStation = stations.iterator().next();
                } else {
                    railwayStation = stations.stream().filter(s -> Boolean.TRUE.equals(s.getMainCityStation())).findFirst().orElse(null);
                    if (null == railwayStation && TextUtil.nonBlank((String)location.getCaption())) {
                        railwayStation = stations.stream().filter(s -> s.getTranslations().values().stream().anyMatch(n -> location.getCaption().compareToIgnoreCase((String)n) == 0)).findFirst().orElse(null);
                    }
                }
                return railwayStation != null ? SearchFormDataHelper.getRailwayStationPoint(railwayStation) : null;
            }
            case HOTEL: {
                return SearchFormDataHelper.getHotelCity((DictionaryReference<GeoLocation>)location);
            }
        }
        return null;
    }

    public static RoutePoint getRailwayStationPoint(RailwayStation railwayStation) {
        RoutePoint result = new RoutePoint();
        result.setCode(railwayStation.getCode());
        result.setCaption((String)MiscUtil.findByLocale((Map)railwayStation.getTranslations(), (Locale)LocaleManager.get().getCurrentLocale()));
        return result;
    }

    public static RoutePoint getGeoCity(DictionaryReference<GeoLocation> geoLocationRef) {
        GeoLocation city;
        GeoLocation geoLocation = (GeoLocation)DictHelper.resolve(geoLocationRef);
        if (null == geoLocation) {
            return null;
        }
        if (geoLocation.getType() != LocationType.CITY && (city = DictHelper.findCity((GeoLocation)geoLocation)) != null) {
            geoLocation = city;
        }
        GeoLocationReference loc = AviaConverterHelper.convertGeoLocationReference2Rest(geoLocation, LocaleHelper.getCurrentLocale());
        RoutePoint result = new RoutePoint();
        result.setCode(TextUtil.isBlank((String)loc.getIataCode()) ? loc.getCrtCode() : loc.getIataCode());
        result.setCaption(TextUtil.isBlank((String)loc.getAirportCaption()) ? loc.getCityCaption() : loc.getAirportCaption());
        return result;
    }

    public static RoutePoint getStationCity(DictionaryReference<RailwayStation> stationRef) {
        RailwayStation station = (RailwayStation)DictionaryCache.get().resolveReference(stationRef);
        if (null == station) {
            return null;
        }
        RailwayStation city = Boolean.TRUE.equals(station.getMainCityStation()) ? station : DictionaryCache.get().search(RailwayStation.class, DictSearchCriterion.eq((String)RailwayStation.Property.geoLocation.name(), (Object)station.getGeoLocation())).stream().filter(s -> Boolean.TRUE.equals(s.getMainCityStation())).findFirst().orElse(station);
        return SearchFormDataHelper.getRailwayStationPoint(city);
    }

    public static DictionaryReference<GeoLocation> getGeoCityByAir(DictionaryReference<GeoLocation> geoLocationRef) {
        GeoLocation city;
        if (null == geoLocationRef) {
            return null;
        }
        GeoLocation geoLocation = (GeoLocation)DictHelper.resolve(geoLocationRef);
        if (null == geoLocation) {
            return null;
        }
        if (geoLocation.getType() != LocationType.CITY && (city = DictHelper.findCity((GeoLocation)geoLocation)) != null) {
            geoLocation = city;
        }
        return geoLocation.toReference();
    }

    public static DictionaryReference<GeoLocation> getStationCityByRail(DictionaryReference<RailwayStation> stationRef) {
        RailwayStation station = (RailwayStation)DictionaryCache.get().resolveReference(stationRef);
        if (null == station) {
            return null;
        }
        RailwayStation city = Boolean.TRUE.equals(station.getMainCityStation()) ? station : DictionaryCache.get().search(RailwayStation.class, DictSearchCriterion.eq((String)RailwayStation.Property.geoLocation.name(), (Object)station.getGeoLocation())).stream().filter(s -> Boolean.TRUE.equals(s.getMainCityStation())).findFirst().orElse(station);
        return city.getGeoLocation();
    }
}

