/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.search;

import com.gridnine.xtrip.common.midoffice.model.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.ProfileKeyContactPerson;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.TravellerEmailsResult;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.TravellersSearchParams;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;

public class SearchTravellerEmailsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        TravellersSearchParams params = (TravellersSearchParams)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        HashSet<TravellerEmailsResult> emails = new HashSet<TravellerEmailsResult>();
        EntityContainer organizationCtr = EntityStorage.get().resolve(params.getOrgRef());
        if (EntityStorageHelper.nonEmpty((EntityContainer)organizationCtr)) {
            Organization organization = (Organization)organizationCtr.getEntity();
            ArrayList<String> uids = new ArrayList<String>();
            uids.add(salesContext.getAgent().getUid());
            if (!ProfileHelper.isRetailProfile((Organization)organization)) {
                this.addUids(uids, organization, params);
            }
            this.searchEmails(this.buildQuery(uids), emails);
        }
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, emails);
    }

    private SearchQuery buildQuery(List<String> uids) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchQueryHelper.buildOrEqStringCriterion((String)"containerUid", uids));
        query.getPreferredProperties().add(PersonIndex.Property.name.name());
        query.getPreferredProperties().add(PersonIndex.Property.emails.name());
        return query;
    }

    private void searchEmails(SearchQuery query, Set<TravellerEmailsResult> resultEmails) {
        List personIndices = EntityStorage.get().search(PersonIndex.class, query).getData();
        for (PersonIndex personIndex : personIndices) {
            TravellerEmailsResult emailRes = new TravellerEmailsResult();
            emailRes.getEmails().addAll(personIndex.getEmails());
            emailRes.setFio(personIndex.getName());
            resultEmails.add(emailRes);
        }
    }

    private void addUids(List<String> uids, Organization organization, TravellersSearchParams params) {
        Stream.concat(organization.getKeyContacts().stream().map(ProfileKeyContactPerson::getPerson), params.getTravellers().stream()).filter(Objects::nonNull).map(EntityReference::getUid).forEach(uids::add);
    }
}

