/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.search;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.RouteType;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.ibecorp.rules.SearchResultSortTypeProperty;
import com.gridnine.xtrip.common.ibecorp.rules.Targets;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.rest.InformationMessage;
import com.gridnine.xtrip.common.util.BooleanUtil;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.ApprovalHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.avia.B2BSearchFlightsResult;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.SearchTrainsResponse;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.search.IBusIbecorpB2BSearchCtxKeys;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.CommonSearchParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.ServiceType;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.TransportSearchCommonData;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.TransportSearchResultWrapper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TransportSearchResultBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        ServiceType searchType = (ServiceType)ctx.getMandatoryObject((Enum)IBusIbecorpB2BSearchCtxKeys.SEARCH_TYPE);
        SMSiteType siteType = (SMSiteType)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE_TYPE);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        TransportSearchResultWrapper res = new TransportSearchResultWrapper();
        Targets target = null;
        boolean hasTravelPolicy = false;
        switch (searchType) {
            case AVIA: {
                res.getAvia().add(ctx.getMandatoryObject((Enum)IBusIbecorpB2BSearchCtxKeys.AVIA_REST_RESULT));
                target = Targets.SEARCH_RESULT_SORT_TYPE_AVIA;
                hasTravelPolicy = res.getAvia().stream().filter(B2BSearchFlightsResult.class::isInstance).map(B2BSearchFlightsResult.class::cast).anyMatch(B2BSearchFlightsResult::hasTravelPolicy);
                break;
            }
            case RAIL: {
                res.getRail().add(ctx.getMandatoryObject((Enum)IBusIbecorpB2BSearchCtxKeys.RAIL_REST_RESULT));
                target = Targets.SEARCH_RESULT_SORT_TYPE_RAILWAY;
                hasTravelPolicy = res.getRail().stream().anyMatch(SearchTrainsResponse::hasTravelPolicy);
                break;
            }
            case COMBINED: {
                Map results = (Map)ctx.getMandatoryObject((Enum)IBusIbecorpB2BSearchCtxKeys.COMBINED_REST_RESULT);
                res.getAvia().add(((MessageContext)results.get(ServiceType.AVIA)).getMandatoryObject((Enum)IBusIbecorpB2BSearchCtxKeys.AVIA_REST_RESULT));
                res.getRail().add(((MessageContext)results.get(ServiceType.RAIL)).getMandatoryObject((Enum)IBusIbecorpB2BSearchCtxKeys.RAIL_REST_RESULT));
                List aviaMessages = (List)((MessageContext)results.get(ServiceType.AVIA)).getMandatoryObject((Enum)IBusIbecorpB2BSearchCtxKeys.COMBINED_REST_MESSAGES);
                List railMessages = (List)((MessageContext)results.get(ServiceType.RAIL)).getMandatoryObject((Enum)IBusIbecorpB2BSearchCtxKeys.COMBINED_REST_MESSAGES);
                CommonSearchParameters params = (CommonSearchParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
                List msg = (List)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_MESSAGES);
                msg.addAll(this.mergeRestMessages(this.removeDuplicatedRestMessages(aviaMessages), this.removeDuplicatedRestMessages(railMessages)));
                this.handleMulticallEmptyTrainsError(msg, res.getRail(), params.getRouteType());
            }
        }
        TransportSearchResultBuilder.fillTransportSearchCommonData((TransportSearchCommonData)res, siteType, salesContext, target, hasTravelPolicy);
        res.getMessages().clear();
        res.getMessages().addAll(this.collectMessages(ctx));
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)res);
    }

    public static void fillTransportSearchCommonData(TransportSearchCommonData res, SMSiteType siteType, SalesContext salesContext, Targets target, boolean hasTravelPolicy) throws Exception {
        res.setSearchResultSortType(SearchResultSortTypeProperty.builder((SalesContext)salesContext, (Targets)target).setHasTravelPolicy(hasTravelPolicy).build());
        if (siteType == SMSiteType.B2B) {
            res.setIssueAllowed(CabinetHelper.isBookingGranted());
            res.setApprovalAllowed(ApprovalHelper.isApprovalGranted());
        } else {
            res.setIssueAllowed(true);
            res.setApprovalAllowed(false);
        }
    }

    private List<InformationMessage> removeDuplicatedRestMessages(List<InformationMessage> msg) {
        HashMap uniqueMessagesMap = new HashMap();
        msg.forEach(m -> uniqueMessagesMap.put(m.getText(), m));
        return new ArrayList<InformationMessage>(uniqueMessagesMap.values());
    }

    private List<InformationMessage> mergeRestMessages(List<InformationMessage> aviaMsg, List<InformationMessage> railMsg) {
        ArrayList<InformationMessage> result = new ArrayList<InformationMessage>();
        result.addAll(aviaMsg);
        result.addAll(railMsg);
        return result;
    }

    private void handleMulticallEmptyTrainsError(List<InformationMessage> msg, List<SearchTrainsResponse> trains, RouteType routeType) {
        SearchTrainsResponse resp = trains.get(0);
        if (!resp.getTrains().isEmpty() && (routeType == RouteType.ONEWAY || routeType == RouteType.ROUNDTRIP && !resp.getTrainsBack().isEmpty()) && msg.stream().anyMatch(m -> m.getCode().equals("310"))) {
            InformationMessage message = msg.stream().filter(m -> m.getCode().equals("310")).findFirst().orElse(null);
            msg.remove(message);
        }
    }

    private List<String> collectMessages(MessageContext ctx) {
        if (BooleanUtil.nullAsFalse((Boolean)((Boolean)ctx.getObject((Enum)IBusGdsSirenaContextKeys.BONUS_CARDS_IGNORED)))) {
            return Collections.singletonList("\u0411\u043e\u043d\u0443\u0441\u043d\u0430\u044f \u043a\u0430\u0440\u0442\u0430 \u043d\u0435 \u0431\u044b\u043b\u0430 \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0430. \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043a\u043e\u0434 \u043a\u0430\u0440\u0442\u044b.");
        }
        return Collections.emptyList();
    }
}

