/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.search;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.search.SearchFormDataHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.search.SegmentHolder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class TravelerGroupRoutesHolder {
    private final Traveller traveller;
    private final TreeSet<SegmentHolder> routePoints = new TreeSet();
    private final Map<DictionaryReference<GeoLocation>, List<HotelProduct>> hotelProducts = new HashMap<DictionaryReference<GeoLocation>, List<HotelProduct>>();

    public TravelerGroupRoutesHolder(Traveller traveller, List<BaseProduct> travellerProducts) {
        this.traveller = traveller;
        for (BaseProduct pr : travellerProducts) {
            RailwayProduct rail;
            List<Segment> segments;
            if (pr instanceof HotelProduct) {
                HotelProduct hotel = (HotelProduct)pr;
                if (hotel.getHotelLocation() == null) continue;
                this.addHotelProducts((DictionaryReference<GeoLocation>)hotel.getHotelLocation(), hotel);
                continue;
            }
            ArrayList<SegmentHolder> segmentHolder = new ArrayList<SegmentHolder>();
            if (pr instanceof Product) {
                Product air = (Product)pr;
                segments = air.getSegmentTariffs().stream().flatMap(s -> s.getSegments().stream()).collect(Collectors.toList());
                if (!segments.isEmpty()) {
                    segments.forEach(segment -> {
                        SegmentHolder holder = new SegmentHolder();
                        holder.setProduct((BaseProduct)air);
                        holder.setDepartureDate(MiscUtil.clearTime((Date)segment.getStartDate()));
                        holder.setDeparturePoint(SearchFormDataHelper.getGeoCityByAir((DictionaryReference<GeoLocation>)segment.getDepartureLocation()));
                        holder.setArriveDate(MiscUtil.clearTime((Date)segment.getEndDate()));
                        holder.setArrivalPoint(SearchFormDataHelper.getGeoCityByAir((DictionaryReference<GeoLocation>)segment.getArriveLocation()));
                        segmentHolder.add(holder);
                    });
                }
            } else if (pr instanceof RailwayProduct && !(segments = (rail = (RailwayProduct)pr).getSegments()).isEmpty()) {
                SegmentHolder holder = new SegmentHolder();
                RailwaySegment firstSegment = (RailwaySegment)segments.get(0);
                holder.setProduct((BaseProduct)rail);
                holder.setDepartureDate(MiscUtil.clearTime((Date)firstSegment.getDepartureDate()));
                holder.setDeparturePoint(SearchFormDataHelper.getStationCityByRail((DictionaryReference<RailwayStation>)firstSegment.getDepartureStation()));
                holder.setArriveDate(MiscUtil.clearTime((Date)firstSegment.getArriveDate()));
                holder.setArrivalPoint(SearchFormDataHelper.getStationCityByRail((DictionaryReference<RailwayStation>)firstSegment.getArriveStation()));
                segmentHolder.add(holder);
            }
            this.routePoints.addAll(segmentHolder);
        }
    }

    public Traveller getTraveller() {
        return this.traveller;
    }

    public Map<DictionaryReference<GeoLocation>, List<HotelProduct>> getHotelProducts() {
        return this.hotelProducts;
    }

    public void addHotelProducts(DictionaryReference<GeoLocation> hotelLocation, HotelProduct hotel) {
        this.hotelProducts.computeIfAbsent(hotelLocation, v -> new ArrayList()).add(hotel);
    }

    public TreeSet<SegmentHolder> getRoutes() {
        return this.routePoints;
    }
}

