/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.site.getSiteSettings;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.booking.transfers.TransferType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMStep1Settings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMStep2Settings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMStep3Settings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMStep4Settings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMVisualSettings;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.autocomplete.organizations.CorporateClientHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.site.B2BSiteSettingsResult;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.site.CorporateSiteSettings;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.site.getSiteSettings.B2BServicesHelper;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.SiteConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.ServiceType;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Arrays;
import java.util.Objects;

public class B2BGetSiteSettingsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityReference siteRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        SMSiteType siteType = (SMSiteType)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE_TYPE);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        EntityContainer currentOrg = EntityStorage.get().resolve((EntityReference)ctx.getObject((Enum)IBusIbecorpContextKeys.CURRENT_ORGANIZATION));
        EntityReference currentUser = (EntityReference)ctx.getObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER);
        SMStep1Settings firstStepSettings = Objects.requireNonNull(CommonHelper.getStep1Settings((EntityReference<SMSite>)siteRef));
        SMStep2Settings secondStepSettings = Objects.requireNonNull(CommonHelper.getStep2Settings((EntityReference<SMSite>)siteRef));
        SMStep3Settings thirdStepSettings = Objects.requireNonNull(CommonHelper.getStep3Settings((EntityReference<SMSite>)siteRef));
        SMStep4Settings fourthStepSettings = Objects.requireNonNull(CommonHelper.getStep4Settings((EntityReference<SMSite>)siteRef));
        SMVisualSettings visualSettings = Objects.requireNonNull(CommonHelper.getVisualSettings((EntityReference<SMSite>)siteRef));
        SMGeneralSettings generalSettings = Objects.requireNonNull(CommonHelper.getGeneralSettings((EntityReference<SMSite>)siteRef));
        GdsTracingSettings gdsTracingSettings = CommonHelper.getGdsTracingSettings(salesContext);
        B2BSiteSettingsResult result = new B2BSiteSettingsResult();
        result.setGeneralSettings(SiteConverterHelper.convertGeneralSettings2Rest(generalSettings, true));
        result.setVisualSettings(SiteConverterHelper.convertVisualSettings2Rest(visualSettings, salesContext));
        result.setFirstStepSettings(SiteConverterHelper.convertFirstStepSettings2Rest(firstStepSettings, salesContext));
        result.setSecondStepSettings(SiteConverterHelper.convertSecondStepSettings2Rest(secondStepSettings));
        result.setThirdStepSettings(SiteConverterHelper.convertThirdStepSettings2Rest(thirdStepSettings));
        result.setFourthStepSettings(SiteConverterHelper.convertFourthStepSettings2Rest(fourthStepSettings));
        result.getPassengerTypes().addAll(DictHelper.getAllPassengerTypes());
        result.setLocale(LocaleHelper.getCurrentLocale().getLanguage());
        result.setRussiaCountry((DictionaryReference)DictHelper.getRuRef());
        result.setDefaultErrorMessage(CommonConverterHelper.getDefaultErrorMessage(generalSettings, salesContext));
        result.getReservationStatuses().addAll(Arrays.asList(ReservationStatus.values()));
        if (gdsTracingSettings != null) {
            result.setShowAdminExceptions(gdsTracingSettings.isShowAdminExceptions());
            result.setShowDeveloperExceptions(gdsTracingSettings.isShowDeveloperExceptions());
        }
        if (currentOrg != null) {
            result.setCorporateSettings(B2BGetSiteSettingsProcessor.defineCorporateSiteSettings((EntityContainer<Organization>)currentOrg, salesContext));
        }
        if (SMSiteType.B2C.equals((Object)siteType)) {
            result.setCabinetMenuSettings(CabinetHelper.getCabinetMenuSettingsB2C(currentUser != null));
        } else if (currentUser != null) {
            result.setCabinetMenuSettings(CabinetHelper.getCabinetMenuSettings());
        }
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    private static CorporateSiteSettings defineCorporateSiteSettings(EntityContainer<Organization> currentOrg, SalesContext salesContext) throws Exception {
        CorporateSiteSettings corpSettings = new CorporateSiteSettings();
        corpSettings.getAvailableServices().addAll(B2BServicesHelper.getAvailableServices(salesContext));
        if (corpSettings.getAvailableServices().contains(ServiceType.TRANSFER)) {
            corpSettings.getAvailableTransferType().add(TransferType.RENT);
            corpSettings.getAvailableTransferType().add(TransferType.TRANSFER);
        }
        if (((Organization)currentOrg.getEntity()).getTypes().contains(OrganizationType.AGENCY)) {
            EntityContainer orgCtr = ProfileHelper.getRetailProfileContainer();
            if (orgCtr != null) {
                corpSettings.setRetailClientReference(orgCtr.toReference());
                corpSettings.setPredefinedClientReference(orgCtr.toReference());
            }
            corpSettings.setShowCorporateClientBlock(CorporateClientHelper.hasOrganizationCorporateClients(currentOrg));
        } else {
            corpSettings.setPredefinedClientReference(currentOrg.toReference());
            corpSettings.setShowCorporateClientBlock(true);
            corpSettings.setDefaultCompanyClient(currentOrg.toReference());
        }
        return corpSettings;
    }
}

