/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.site.getSiteSettings;

import com.gridnine.xtrip.common.gds.rules.Targets;
import com.gridnine.xtrip.common.hotels2.rules.HotelsParametersActions;
import com.gridnine.xtrip.common.hotels2.rules.HotelsParametersProperties;
import com.gridnine.xtrip.common.hotels2.rules.HotelsTargets;
import com.gridnine.xtrip.common.ibecorp.rules.RzdParametersActions;
import com.gridnine.xtrip.common.ibecorp.rules.RzdParametersProperties;
import com.gridnine.xtrip.common.ibecorp.rules.RzdTargets;
import com.gridnine.xtrip.common.midoffice.helper.SalesContextHandler;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.transfers.rules.TransferParametersActions;
import com.gridnine.xtrip.common.transfers.rules.TransferParametersProperties;
import com.gridnine.xtrip.common.transfers.rules.TransferTargets;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.gds.rules.proxy.GDSParametersActions;
import com.gridnine.xtrip.server.gds.rules.proxy.GDSParametersProperties;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsDirectContractHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.ServiceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.slf4j.LoggerFactory;

public class B2BServicesHelper {
    public static List<ServiceType> getAvailableServices(SalesContext salesContext) throws Exception {
        RuleSet rules;
        ArrayList<ServiceType> result = new ArrayList<ServiceType>();
        if (salesContext.getClient() == null) {
            salesContext.setClient(ProfileHelper.findRetailProfileReference());
        }
        if (B2BServicesHelper.isAviaApplicableGdsAccounts(salesContext, rules = SalesContextHandler.get().getRules(salesContext))) {
            result.add(ServiceType.AVIA);
        }
        if (B2BServicesHelper.isRailApplicableGdsAccounts(salesContext, rules)) {
            result.add(ServiceType.RAIL);
        }
        if (B2BServicesHelper.isHotelApplicableGdsAccounts(salesContext, rules) || B2BServicesHelper.isHotelApplicableDirectContracts(salesContext)) {
            result.add(ServiceType.HOTEL);
        }
        if (B2BServicesHelper.isTransferApplicableGdsAccounts(salesContext, rules)) {
            result.add(ServiceType.TRANSFER);
        }
        return result;
    }

    private static boolean isAviaApplicableGdsAccounts(SalesContext salesContext, RuleSet rules) throws Exception {
        RuleProxy proxy = new RuleProxy();
        proxy.getTracer().setDisabled(!LoggerFactory.getLogger((String)"com.gridnine.xtrip.server.gds.GDSConnector.RULES_TRACE").isDebugEnabled());
        proxy.setProxyType(Targets.GDS_PARAMETERS.getId());
        proxy.setProxyDate(new Date());
        proxy.setPropertySet((Object)new GDSParametersProperties(salesContext, proxy));
        proxy.setActionSet((Object)new GDSParametersActions());
        RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)rules);
        return ((GDSParametersActions)proxy.getActionSet()).getApplicableGdsAccounts().stream().anyMatch(accountRef -> EntityStorage.get().resolve(accountRef) != null);
    }

    private static boolean isHotelApplicableDirectContracts(SalesContext salesContext) {
        Set suppliers = HotelsDirectContractHelper.getDirectContractSuppliers((SalesContext)salesContext);
        return CollectionUtil.isNotEmpty((Collection)suppliers);
    }

    private static boolean isHotelApplicableGdsAccounts(SalesContext salesContext, RuleSet rules) throws Exception {
        RuleProxy proxy = new RuleProxy();
        proxy.getTracer().setDisabled(!LoggerFactory.getLogger((String)"com.gridnine.xtrip.server.gds.GDSConnector.RULES_TRACE").isDebugEnabled());
        proxy.setProxyType(HotelsTargets.HOTEL_PARAMETERS.getId());
        proxy.setProxyDate(new Date());
        proxy.setPropertySet((Object)new HotelsParametersProperties(salesContext, proxy));
        proxy.setActionSet((Object)new HotelsParametersActions());
        RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)rules);
        return ((HotelsParametersActions)proxy.getActionSet()).getApplicableGdsAccounts().stream().anyMatch(accountRef -> EntityStorage.get().resolve(accountRef) != null);
    }

    private static boolean isRailApplicableGdsAccounts(SalesContext salesContext, RuleSet rules) throws Exception {
        RuleProxy proxy = new RuleProxy();
        proxy.getTracer().setDisabled(!LoggerFactory.getLogger((String)"com.gridnine.xtrip.server.gds.GDSConnector.RULES_TRACE").isDebugEnabled());
        proxy.setProxyType(RzdTargets.RZD_PARAMETERS.getId());
        proxy.setProxyDate(new Date());
        proxy.setPropertySet((Object)new RzdParametersProperties(null, salesContext, proxy));
        proxy.setActionSet((Object)new RzdParametersActions());
        RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)rules);
        return ((RzdParametersActions)proxy.getActionSet()).getApplicableGdsAccounts().stream().anyMatch(accountRef -> EntityStorage.get().resolve(accountRef) != null);
    }

    private static boolean isTransferApplicableGdsAccounts(SalesContext salesContext, RuleSet rules) throws Exception {
        RuleProxy proxy = new RuleProxy();
        proxy.getTracer().setDisabled(!LoggerFactory.getLogger((String)"com.gridnine.xtrip.server.gds.GDSConnector.RULES_TRACE").isDebugEnabled());
        proxy.setProxyType(TransferTargets.TRANSFER_PARAMETERS.getId());
        proxy.setProxyDate(new Date());
        proxy.setPropertySet((Object)new TransferParametersProperties(null, null, salesContext, proxy));
        proxy.setActionSet((Object)new TransferParametersActions());
        RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)rules);
        return ((TransferParametersActions)proxy.getActionSet()).getApplicableGdsAccounts().stream().anyMatch(accountRef -> EntityStorage.get().resolve(accountRef) != null);
    }
}

