/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.transfers;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.trip.TripParameters;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.transfers.RentParams;
import com.gridnine.xtrip.common.transfers.Subaddress;
import com.gridnine.xtrip.common.transfers.model.BaseTransferGdsAccount;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.B2BRestHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.transfers.CarRentInfo;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.transfers.Location;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.transfers.PassengersTypes;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.transfers.RestTransfer;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.transfers.RestTransferToken;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.components.TransferPriceComponents;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonRestHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.HasTravelPolicyCompliance;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.TravelPolicyHelper;
import com.gridnine.xtrip.server.transfers.GdsCarClass;
import com.gridnine.xtrip.server.transfers.SearchResponse;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

public class RestTransfersHelper {
    public static RestTransfer convertToRestTransfer(SearchResponse response, EntityReference<Organization> clientRef, List<EntityReference<Person>> travellerRefs, TripParameters tripParams, Subaddress startLocation, Subaddress endLocation, List<Subaddress> subAddresses, Date date, Date backDate, Integer duration, PassengersTypes passengersTypes, PriceComponentsParameters priceComponentsParameters) throws Exception {
        RestTransfer result = new RestTransfer();
        EntityReference gdsAccountRef = response.getTo().getGdsAccount();
        GdsName gdsName = ((BaseTransferGdsAccount)EntityStorage.get().resolve(response.getTo().getGdsAccount()).getEntity()).getGds();
        GdsCarClass carClass = response.getTo().getCarClass();
        result.setCarClass(carClass.getCarClassDict());
        result.setCapacity(carClass.getCapacity().intValue());
        result.setGdsAccount(gdsAccountRef);
        result.setImageUrl(carClass.getImageUrl());
        result.setModels(RestTransfersHelper.getModels(carClass));
        result.setGds(gdsName);
        BigDecimal priceTotal = BigDecimal.ZERO;
        result.setPrice(TransferPriceComponents.builder(response.getTo(), priceComponentsParameters).build().createPrice());
        if (response.getFrom() != null) {
            result.setPriceBack(TransferPriceComponents.builder(response.getFrom(), priceComponentsParameters).build().createPrice());
        }
        result.setTotalPrice(B2BRestHelper.calcTotalMoney(result.getPrice(), result.getPriceBack()));
        result.setToken(RestTransfersHelper.buildRestTransferToken(response, clientRef, travellerRefs, tripParams, startLocation, endLocation, subAddresses, date, backDate, duration, passengersTypes));
        if (CollectionUtil.isNotEmpty(travellerRefs)) {
            result.setExceededCapacity(travellerRefs.size() > carClass.getCapacity());
        }
        if (response.getTo().getRentParams() != null) {
            result.setRentInfo(RestTransfersHelper.convertToCarRentInfo(response.getTo().getRentParams()));
        }
        result.setFlexibleTariff(response.getTo().isFlexibleTariff());
        result.setFlexibleTariffAgreement(response.getTo().isFlexibleTariffAgreement());
        if (passengersTypes != null) {
            result.setAdult(passengersTypes.getADULT());
            result.setChild(passengersTypes.getCHILD());
        }
        if (response.getFrom() != null) {
            CommonConverterHelper.addTravelPolicyInfo(TravelPolicyHelper.strictestTravelPolicy(response.getTo().getTravelPolicyImpositionResult(), response.getFrom().getTravelPolicyImpositionResult()), (HasTravelPolicyCompliance)result);
        } else {
            CommonConverterHelper.addTravelPolicyInfo(response.getTo().getTravelPolicyImpositionResult(), (HasTravelPolicyCompliance)result);
        }
        return result;
    }

    private static String getModels(GdsCarClass carClass) {
        String models = carClass.getModels();
        if (!TextUtil.isBlank((String)models)) {
            models = models + L10nResourcesManager.getStr((String)"TRANSFERS_MODEL_MESSAGE_SIMILAR", (Object[])new Object[0]);
        }
        return models;
    }

    private static String buildRestTransferToken(SearchResponse response, EntityReference<Organization> clientRef, List<EntityReference<Person>> travellerRefs, TripParameters tripParams, Subaddress startLocation, Subaddress endLocation, List<Subaddress> subAddresses, Date date, Date backDate, Integer duration, PassengersTypes passengersTypes) throws Exception {
        RestTransferToken restTransferToken = new RestTransferToken();
        restTransferToken.setClient(clientRef);
        if (CollectionUtil.isNotEmpty(travellerRefs)) {
            restTransferToken.getSelectedPassengers().addAll(travellerRefs);
        }
        if (tripParams != null) {
            restTransferToken.setBookingFile(tripParams.getBookingFileRef());
        }
        restTransferToken.setSearchResponse(response);
        restTransferToken.setStartAddress(startLocation);
        restTransferToken.setEndAddress(endLocation);
        restTransferToken.getSubAddresses().addAll(subAddresses);
        restTransferToken.setPickUpDate(date);
        restTransferToken.setBackPickUpDate(backDate);
        restTransferToken.setDuration(duration);
        if (passengersTypes != null) {
            restTransferToken.setAdultCount(Integer.valueOf(passengersTypes.getADULT()));
            restTransferToken.setChildCount(Integer.valueOf(passengersTypes.getCHILD()));
        }
        return CommonRestHelper.encodeToken((BaseEntity)restTransferToken);
    }

    private static CarRentInfo convertToCarRentInfo(RentParams rentParams) {
        CarRentInfo carRentInfo = new CarRentInfo();
        carRentInfo.setMinDuration(rentParams.getMinimumDuration().intValue());
        carRentInfo.setCarDeliveranceFee(BigDecimal.valueOf(rentParams.getCarDeliveranceFee()));
        carRentInfo.setPricePerHour(BigDecimal.valueOf(rentParams.getPricePerHour()));
        return carRentInfo;
    }

    public static String getCoordinates(Location location) {
        return String.join((CharSequence)",", location.getLatitude(), location.getLongitude());
    }

    public static Subaddress convertSubaddressFromRest(Location location) {
        if (location == null) {
            return null;
        }
        return RestTransfersHelper.buildAddress(location.getAddress(), RestTransfersHelper.getCoordinates(location));
    }

    public static Subaddress buildAddress(String address, String location) {
        Subaddress subaddress = new Subaddress();
        subaddress.setAddress(address);
        subaddress.setLocation(location);
        return subaddress;
    }

    public static Integer getDuration(LocalDateTime startRentDate, LocalDateTime endRentDate) {
        if (startRentDate == null || endRentDate == null) {
            return null;
        }
        return (int)Duration.between(startRentDate, endRentDate).getSeconds();
    }

    public static Integer getDuration(LocalDateTime startRentDate, LocalDateTime endRentDate, RentParams params) {
        if (params == null || RestTransfersHelper.getDuration(startRentDate, endRentDate) == null) {
            return null;
        }
        return Integer.max(RestTransfersHelper.getDuration(startRentDate, endRentDate), params.getMinimumDuration().intValue());
    }

    public static Integer getDuration(Transfer transfer) {
        if (transfer.getStartDate() == null || transfer.getEndDate() == null) {
            return null;
        }
        return (int)MiscUtil.getDuration((Date)transfer.getStartDate(), (Date)transfer.getEndDate(), (int)13);
    }
}

