/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.transfers.booking;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.transfers.AdditionalService;
import com.gridnine.xtrip.common.model.booking.transfers.TransferType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.AckMessage;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.profile.ReasonCodeType;
import com.gridnine.xtrip.common.model.rules.TransliterationType;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyImpositionResult;
import com.gridnine.xtrip.common.transfers.GdsPlaceInfo;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.RestBookingHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.getBookingForm.BaseBookingFormSettingsProcessor;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.BookingFormSettings;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.BookingFormSettingsParams;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.transfers.PlaceInfo;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.transfers.RestAdditionalService;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.transfers.RestTransferToken;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.transfers.TransfersBookingFormSettings;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.transfers.TripFormSettingsParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.transfers.IBusRestTransferContextKeys;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.tasks.autoticketing.IBusAuthorizationContextKeys;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.transfers.SearchGdsResponse;
import com.gridnine.xtrip.server.transfers.SearchResponse;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Date;
import java.util.stream.Collectors;

public class BookingFormSettingsProcessor
extends BaseBookingFormSettingsProcessor {
    public void process(MessageContext ctx) throws Exception {
        BookingFormSettingsParams params = (BookingFormSettingsParams)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        SMSiteType siteType = (SMSiteType)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE_TYPE);
        PersonType authUserType = (PersonType)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER_PERSON_TYPE);
        RestTransferToken transferToken = (RestTransferToken)ctx.getMandatoryObject((Enum)IBusRestTransferContextKeys.REST_TRANSFER_TOKEN);
        AckMessage searchDuplicatesMessage = (AckMessage)ctx.getObject((Enum)IBusAuthorizationContextKeys.SEARCH_DUPLICATES_MESSAGE);
        SearchResponse response = transferToken.getSearchResponse();
        TransfersBookingFormSettings result = new TransfersBookingFormSettings();
        this.setSearchDuplicatesMessageData((BookingFormSettings)result, searchDuplicatesMessage);
        CommonConverterHelper.setCustomerAndOrder((BookingFormSettings)result, (EntityReference<BookingFile>)transferToken.getBookingFile());
        BookingFile bookingFile = null;
        if (result.getOrder() != null) {
            bookingFile = (BookingFile)EntityStorage.get().load(BookingFile.class, result.getOrder().getBookingUid()).getEntity();
        }
        EntityReference clientRef = transferToken.getClient();
        EntityContainer clientCtr = EntityStorage.get().resolve(clientRef);
        salesContext.setClient(clientRef);
        result.setContactAutocompleteAvailable(this.isContactAutocompleteAvailable(siteType, (EntityContainer<Organization>)clientCtr));
        result.getCorporatePassengers().addAll(this.getPassengers(bookingFile, transferToken.getSelectedPassengers(), Collections.emptyMap(), (EntityReference<Organization>)clientRef));
        result.getOrganizationCostCodes().addAll(RestBookingHelper.getOrganizationCostCodes((EntityContainer<Organization>)clientCtr, params.getTraveller()));
        TravelPolicyImpositionResult tpImpositionResult = response.getTo().getTravelPolicyImpositionResult();
        result.setReasonCode(BookingFormSettingsProcessor.getReasonCode((EntityContainer<Organization>)clientCtr, tpImpositionResult, ReasonCodeType.REASON_CODE_TRANSFER));
        BookingFormSettingsProcessor.setKeyContact((BookingFormSettings)result, (EntityContainer<Organization>)clientCtr, tpImpositionResult);
        result.setTransferType(response.getTo().getRentParams() != null ? TransferType.RENT : TransferType.TRANSFER);
        result.setTo(this.getTripSettings(response.getTo(), transferToken));
        if (response.getFrom() != null) {
            result.setFrom(this.getTripSettings(response.getFrom(), transferToken));
        }
        result.setLangRegistrationFullName(TransliterationType.CYRILLIC);
        result.setLangRegistrationDocument(result.getLangRegistrationFullName());
        BookingFormSettingsProcessor.setTravellerData((BookingFormSettings)result, salesContext, TravelSubject.TRANSFER);
        BookingFormSettingsProcessor.setContactPersonData((BookingFormSettings)result, authUserType, salesContext);
        if (bookingFile == null) {
            BookingFormSettingsProcessor.setExternalSystemsData((BookingFormSettings)result, salesContext);
        }
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    private TripFormSettingsParameters getTripSettings(SearchGdsResponse response, RestTransferToken transferToken) {
        TripFormSettingsParameters tripParams = new TripFormSettingsParameters();
        tripParams.setStartPlaceInfo(this.convert2Rest(response.getStartPlace(), transferToken.getStartAddress().getAddress()));
        if (response.getRentParams() == null) {
            tripParams.setEndPlaceInfo(this.convert2Rest(response.getEndPlace(), transferToken.getEndAddress().getAddress()));
        }
        tripParams.setCancellationNoPenaltyHours(response.getCancellationNoPenaltyHours().intValue());
        tripParams.getAdditionalServices().addAll(response.getAvailableAdditionalServices().stream().map(this::convert2Rest).collect(Collectors.toList()));
        LocalDateTime startDate = MiscUtil.toLocalDateTime((Date)transferToken.getPickUpDate());
        tripParams.setStartDate(startDate);
        if (transferToken.getDuration() != null && startDate != null) {
            tripParams.setEndDate(startDate.plusSeconds(transferToken.getDuration().intValue()));
        }
        return tripParams;
    }

    private PlaceInfo convert2Rest(GdsPlaceInfo gdsPlaceInfo, String address) {
        PlaceInfo placeInfo = new PlaceInfo();
        placeInfo.setType(gdsPlaceInfo.getType());
        placeInfo.getTerminals().addAll(gdsPlaceInfo.getTerminal());
        placeInfo.setAddress(address);
        return placeInfo;
    }

    private RestAdditionalService convert2Rest(AdditionalService service) {
        RestAdditionalService restService = new RestAdditionalService();
        restService.setType(service.getType());
        restService.setFixed(service.isFixed());
        restService.setDefaultInclude(service.isDefaultInclude());
        restService.setCurrencyCode(service.getCurrency());
        restService.setPrice(service.getPrice());
        return restService;
    }
}

