/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.transfers.booking;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.rest.Validatable;
import com.gridnine.xtrip.common.model.standard.helpers.ValidatableUtil;
import com.gridnine.xtrip.common.model.transfers.TransferReservationCreationParameters;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.common.model.validation.ValidationMessage;
import com.gridnine.xtrip.common.transfers.ContactPerson;
import com.gridnine.xtrip.common.transfers.TripDetails;
import com.gridnine.xtrip.common.transfers.TripPoint;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.transfers.PricingParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.transfers.RestTrip;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.transfers.TransferTraveller;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.transfers.TripPointParams;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.Customer;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.RestTraveller;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.web.rest.ValidationHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class CreateBookingValidationAdvice
extends BaseAdvice {
    public void before(MessageContext ctx) {
        ctx.putObject((Enum)IBusRestContextKeys.REST_ENTITY, ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS));
    }

    public boolean handleException(Throwable e, MessageContext ctx) {
        if (e instanceof ValidationException) {
            PricingParameters restParameters = (PricingParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_ENTITY);
            Collection creationParametersList = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATIONS_CREATION_PARAMETERS);
            Collection travellers = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
            this.copyTravellersMessages(travellers, restParameters.getTravellers());
            int tripIndex = 0;
            for (TransferReservationCreationParameters creationParameters : creationParametersList) {
                if (!com.gridnine.xtrip.common.model.validation.ValidationHelper.isValid((com.gridnine.xtrip.common.model.Validatable)creationParameters)) {
                    this.copyValidationMessages(creationParameters, restParameters);
                    this.copyCustomerMessages(creationParameters.getCustomer(), restParameters.getCustomer());
                    this.copyTripDetailsValidationMessages(creationParameters.getTripDetails(), (RestTrip)restParameters.getTrips().get(tripIndex));
                    this.copy(creationParameters.getValidationContext().getTableCaptionValidationMessages(), ((RestTrip)restParameters.getTrips().get(tripIndex)).getValidationContext().getTableCaptionValidationMessages());
                }
                ++tripIndex;
            }
            if (ValidationHelper.isValid((Validatable)restParameters)) {
                throw Xeption.forDeveloper((String)this.getFirstValidationMessage(creationParametersList, travellers), (Object[])new Object[0]);
            }
        }
        return false;
    }

    private boolean copy(Collection<ValidationMessage> from, Collection<ValidationMessage> to) {
        return ValidationHelper.copy(from, to);
    }

    private void copyValidationMessages(TransferReservationCreationParameters creationParameters, PricingParameters parameters) {
        this.copy(creationParameters.getValidationContext().getPassengersCountValidationMessages(), parameters.getValidationContext().getTravellersCountValidationMessages());
        this.copy(creationParameters.getValidationContext().getCustomerValidationMessages(), parameters.getValidationContext().getCustomerValidationMessages());
        this.copy(creationParameters.getValidationContext().getNotesValidationMessages(), parameters.getValidationContext().getNotesValidationMessages());
    }

    private void copyTravellersMessages(Collection<Traveller> travellers, List<TransferTraveller> restTravellers) {
        int i = 0;
        for (Traveller traveller : travellers) {
            RestTraveller restTraveller;
            if ((restTraveller = (RestTraveller)restTravellers.get(i++)).getPassport() != null) {
                restTraveller.getPassport().getValidationContext().getFirstNameValidationMessages().addAll(traveller.getPassport().getValidationContext().getFirstNameValidationMessages());
                restTraveller.getPassport().getValidationContext().getLastNameValidationMessages().addAll(traveller.getPassport().getValidationContext().getLastNameValidationMessages());
            }
            if (restTraveller.getEmail() != null) {
                restTraveller.getValidationContext().getEmailValidationMessages().addAll(traveller.getCommunications().stream().filter(comm -> comm.getType() == CommunicationType.EMAIL).flatMap(comm -> comm.getValidationContext().getSenseValidationMessages().stream()).collect(Collectors.toList()));
            }
            if (restTraveller.getPhone() == null) continue;
            restTraveller.getValidationContext().getPhoneValidationMessages().addAll(traveller.getCommunications().stream().filter(comm -> comm.getType() == CommunicationType.MOBILE || comm.getType() == CommunicationType.HOME_PHONE || comm.getType() == CommunicationType.WORK_PHONE || comm.getType() == CommunicationType.CELL).flatMap(comm -> comm.getValidationContext().getSenseValidationMessages().stream()).collect(Collectors.toList()));
        }
    }

    private void copyCustomerMessages(ContactPerson contactPerson, Customer customer) {
        customer.getValidationContext().getFirstNameValidationMessages().addAll(contactPerson.getValidationContext().getNameValidationMessages());
        customer.getValidationContext().getLastNameValidationMessages().addAll(contactPerson.getValidationContext().getNameValidationMessages());
        customer.getValidationContext().getPhoneValidationMessages().addAll(contactPerson.getValidationContext().getPhoneValidationMessages());
        if (contactPerson.getPhone() != null) {
            customer.getValidationContext().getPhoneValidationMessages().addAll(contactPerson.getPhone().getValidationContext().getCountryCodeValidationMessages());
            customer.getValidationContext().getPhoneValidationMessages().addAll(contactPerson.getPhone().getValidationContext().getCityCodeValidationMessages());
            customer.getValidationContext().getPhoneValidationMessages().addAll(contactPerson.getPhone().getValidationContext().getSenseValidationMessages());
        }
    }

    private void copyTripDetailsValidationMessages(TripDetails from, RestTrip to) {
        this.copyTripPointValidationMessages(from.getStart(), to.getStart());
        this.copyTripPointValidationMessages(from.getEnd(), to.getEnd());
    }

    private void copyTripPointValidationMessages(TripPoint point, TripPointParams rest) {
        rest.getValidationContext().getTimeValidationMessages().addAll(point.getValidationContext().getTimeValidationMessages());
        rest.getValidationContext().getFlightNumberValidationMessages().addAll(point.getValidationContext().getFlightNumberValidationMessages());
        rest.getValidationContext().getTerminalNumberValidationMessages().addAll(point.getValidationContext().getTerminalNumberValidationMessages());
        rest.getValidationContext().getTrainNumberValidationMessages().addAll(point.getValidationContext().getTrainNumberValidationMessages());
        rest.getValidationContext().getTrainCarriageNumberValidationMessages().addAll(point.getValidationContext().getTrainCarriageNumberValidationMessages());
    }

    private String getFirstValidationMessage(Collection<TransferReservationCreationParameters> creationParametersList, Collection<Traveller> travellers) {
        String prefix = "params";
        List errors = new ArrayList();
        for (TransferReservationCreationParameters creationParameters : creationParametersList) {
            errors.addAll(ValidatableUtil.getValidateStrings((com.gridnine.xtrip.common.model.Validatable)creationParameters));
        }
        if (errors.isEmpty()) {
            prefix = "travellers";
            errors = ValidatableUtil.getValidateStrings(travellers, (String)prefix);
        }
        if (errors.isEmpty()) {
            throw Xeption.forDeveloper((String)"validation advise error", (Object[])new Object[0]);
        }
        return prefix.concat(TextUtil.join((String)"; ", errors));
    }
}

