/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.transfers.booking;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.CommonIbecorpHelper;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.transfers.PlaceType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMStep3Settings;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.ReasonCode;
import com.gridnine.xtrip.common.model.profile.ReasonCodeType;
import com.gridnine.xtrip.common.model.system.StandardValidationMessages;
import com.gridnine.xtrip.common.model.transfers.TransferReservationCreationParameters;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyImpositionResult;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.RestBookingHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.transfers.PricingParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.transfers.RestTransferToken;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.transfers.RestTrip;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonRestHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonValidationHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.Customer;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.transfers.CreateBookingParametersValidationMessages;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.List;
import java.util.Objects;

public class PricingParametersValidator
extends BaseProcessor {
    public void process(MessageContext ctx) {
        PricingParameters parameters = (PricingParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        EntityReference siteRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        List transferReservationCreationParameters = (List)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATIONS_CREATION_PARAMETERS);
        ReasonCode reasonCode = (ReasonCode)ctx.getObject((Enum)IBusIbecorpContextKeys.REASON_CODE);
        SMGeneralSettings settings = CommonHelper.getGeneralSettings((EntityReference<SMSite>)siteRef);
        SMStep3Settings step3Settings = Objects.requireNonNull(CommonHelper.getStep3Settings((EntityReference<SMSite>)siteRef));
        if (parameters.getCustomer() == null) {
            parameters.setCustomer(new Customer());
        }
        for (RestTrip trip : parameters.getTrips()) {
            if (trip.getStart().getTime() != null) continue;
            trip.getStart().getValidationContext().getTimeValidationMessages().add(CreateBookingParametersValidationMessages.getMissingStartTime());
        }
        for (TransferReservationCreationParameters creationParameters : transferReservationCreationParameters) {
            if (creationParameters.getTripDetails().getSearchGdsResponse().getEndPlace().getType() != PlaceType.RAILWAY_STATION && creationParameters.getTripDetails().getSearchGdsResponse().getEndPlace().getType() != PlaceType.AIRPORT || creationParameters.getTripDetails().getEnd().getTime() != null) continue;
            creationParameters.getTripDetails().getEnd().getValidationContext().getTimeValidationMessages().add(CreateBookingParametersValidationMessages.getMissingEndTime());
        }
        if (parameters.getNotes() != null && parameters.getNotes().length() > 255) {
            parameters.getValidationContext().getNotesValidationMessages().add(CreateBookingParametersValidationMessages.getTooManyCharacter());
        }
        CommonValidationHelper.validateCustomer(parameters.getCustomer(), false, settings);
        EntityReference clientRef = salesContext.getClient();
        Organization client = (Organization)EntityStorage.get().resolve(clientRef).getEntity();
        parameters.getTravellers().stream().filter(Objects::nonNull).forEach(p -> RestBookingHelper.validateRestCodeCodes(p.getCostCodes(), client));
        RestTransferToken transferToken = CommonRestHelper.decodeToken(parameters.getTransferToken(), RestTransferToken.class);
        TravelPolicyImpositionResult travelPolicyImpositionResult1 = transferToken.getSearchResponse().getTo().getTravelPolicyImpositionResult();
        TravelPolicyImpositionResult travelPolicyImpositionResult2 = null;
        if (transferToken.getSearchResponse().getFrom() != null) {
            travelPolicyImpositionResult2 = transferToken.getSearchResponse().getFrom().getTravelPolicyImpositionResult();
        }
        if (CommonIbecorpHelper.mustHaveReasonCode((EntityReference)clientRef, (TravelPolicyImpositionResult)travelPolicyImpositionResult1, (TravelPolicyImpositionResult)travelPolicyImpositionResult2, (ReasonCodeType)ReasonCodeType.REASON_CODE_TRANSFER) && null == reasonCode) {
            parameters.getValidationContext().getReasonCodeValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
        }
        if ((CommonIbecorpHelper.mustHaveKeyContact((TravelPolicyImpositionResult)travelPolicyImpositionResult1) || CommonIbecorpHelper.mustHaveKeyContact((TravelPolicyImpositionResult)travelPolicyImpositionResult2)) && parameters.getKeyContact() == null) {
            parameters.getValidationContext().getKeyContactValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
        }
        if (!step3Settings.isDisablePersonalDataRules() && !parameters.isAcceptSecurityRules()) {
            parameters.getValidationContext().getAcceptSecurityRulesValidationMessages().add(com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.CreateBookingParametersValidationMessages.getSecurityRulesNotAccepted());
        }
        RestBookingHelper.validateRestCommonCostCodes(parameters.getTravellers(), client, (EntityContainer<BookingFile>)EntityStorage.get().resolve(transferToken.getBookingFile()));
    }
}

