/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.transfers.booking;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.helpers.TravelPolicyAuthorizationHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.transfers.TransferReservationCreationParameters;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyImpositionResult;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.B2BRestHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.transfers.PricingResult;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.components.ReservationPriceComponents;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.HasTravelPolicyCompliance;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.transfers.SearchGdsResponse;
import java.util.List;

public class PricingResultBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) {
        EntityContainer bookingFile = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        List creationParamsList = (List)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATIONS_CREATION_PARAMETERS);
        PriceComponentsParameters priceComponentsParams = PriceComponentsParameters.getB2BComponentsParameters((EntityReference<Person>)((EntityReference)ctx.getObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER)), salesContext);
        PricingResult result = this.buildResult((BookingFile)bookingFile.getEntity(), priceComponentsParams, (TransferReservationCreationParameters)creationParamsList.get(0));
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    private PricingResult buildResult(BookingFile booking, PriceComponentsParameters priceComponentsParams, TransferReservationCreationParameters creationParams) {
        PricingResult result = new PricingResult();
        List reservations = BookingHelper.getReservationsForProduct((BookingFile)booking, (Class[])new Class[]{Transfer.class});
        result.setCurrencyCode(priceComponentsParams.getCurrency());
        result.setPrice(ReservationPriceComponents.builder((Reservation)reservations.get(0), priceComponentsParams).build().createPrice());
        if (reservations.size() > 1) {
            result.setPriceBack(ReservationPriceComponents.builder((Reservation)reservations.get(1), priceComponentsParams).build().createPrice());
        }
        result.setTotalPrice(B2BRestHelper.calcTotalMoney(result.getPrice(), result.getPriceBack()));
        BookingStreamHelper.getProductsStream((BookingFile)booking, Transfer.class).forEach(rp -> {
            TravelPolicyImpositionResult tpImpositionResult = TravelPolicyAuthorizationHelper.getTravelPolicyImpositionResult((BaseProduct)rp);
            CommonConverterHelper.mergeTravelPolicyInfo(tpImpositionResult, (HasTravelPolicyCompliance)result);
            SearchGdsResponse tpImpositionResultHolder = creationParams.getTripDetails().getSearchGdsResponse();
            tpImpositionResultHolder.setTravelPolicyImpositionResult(tpImpositionResult);
        });
        return result;
    }
}

