/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.transfers.booking;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.transfers.TransferType;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ExternalSystem;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.AckMessage;
import com.gridnine.xtrip.common.model.ibecorp.trip.IBusTripContextKeys;
import com.gridnine.xtrip.common.model.ibecorp.trip.TripParameters;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonCostCode;
import com.gridnine.xtrip.common.model.profile.ReasonCode;
import com.gridnine.xtrip.common.model.profile.ReasonCodeType;
import com.gridnine.xtrip.common.model.transfers.TransferReservationCreationParameters;
import com.gridnine.xtrip.common.transfers.ContactPerson;
import com.gridnine.xtrip.common.transfers.Subaddress;
import com.gridnine.xtrip.common.transfers.TripDetails;
import com.gridnine.xtrip.common.transfers.TripPoint;
import com.gridnine.xtrip.common.transfers.model.BaseTransferGdsAccount;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.B2BRestHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.autocomplete.organizations.CorporateClientHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.transfers.PricingParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.transfers.RestTransferToken;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.transfers.RestTrip;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.transfers.TransferTraveller;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.transfers.TripPointParams;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonRestHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.RestTraveller;
import com.gridnine.xtrip.server.ibecorp.ibus.tasks.autoticketing.IBusAuthorizationContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.transfers.SearchGdsResponse;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ReservationParamsConverter
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        PricingParameters params = (PricingParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        ArrayList<TransferReservationCreationParameters> result = new ArrayList<TransferReservationCreationParameters>();
        RestTransferToken transferToken = CommonRestHelper.decodeToken(params.getTransferToken(), RestTransferToken.class);
        EntityReference clientRef = transferToken.getClient();
        EntityContainer gdsAccountCtr = EntityStorage.get().resolve(transferToken.getSearchResponse().getTo().getGdsAccount());
        salesContext.setClient(clientRef);
        TransferReservationCreationParameters creationParamsTo = new TransferReservationCreationParameters();
        TransferType transferType = transferToken.getSearchResponse().getTo().getRentParams() != null ? TransferType.RENT : TransferType.TRANSFER;
        this.fillCommonCreationParameters(creationParamsTo, params, (EntityContainer<? extends BaseTransferGdsAccount>)gdsAccountCtr);
        creationParamsTo.setTripDetails(this.convertRest2TripDetails((RestTrip)params.getTrips().get(0), transferToken.getSearchResponse().getTo(), transferToken.getStartAddress(), transferToken.getEndAddress(), transferToken.getSubAddresses(), params, transferToken.getPickUpDate()));
        creationParamsTo.setTableCaption(((RestTrip)params.getTrips().get(0)).getTableCaption());
        creationParamsTo.setTransferType(transferType);
        if (params.getPassengersTypes() != null) {
            creationParamsTo.getTripDetails().setAdultCount(params.getPassengersTypes().getADULT());
            creationParamsTo.getTripDetails().setChildCount(params.getPassengersTypes().getCHILD());
        } else {
            creationParamsTo.getTripDetails().setAdultCount(params.getTravellersCount());
            creationParamsTo.getTripDetails().setChildCount(0);
        }
        if (transferType == TransferType.RENT) {
            creationParamsTo.getTripDetails().setDuration(transferToken.getDuration());
            creationParamsTo.getTripDetails().getStart().setTime(transferToken.getPickUpDate());
            creationParamsTo.getTripDetails().getEnd().setTime(MiscUtil.addSecondsToDate((Date)transferToken.getPickUpDate(), (int)transferToken.getDuration()));
        }
        result.add(creationParamsTo);
        if (transferToken.getSearchResponse().getFrom() != null && params.getTrips().size() > 1) {
            TransferReservationCreationParameters creationParamsFrom = new TransferReservationCreationParameters();
            this.fillCommonCreationParameters(creationParamsFrom, params, (EntityContainer<? extends BaseTransferGdsAccount>)gdsAccountCtr);
            creationParamsFrom.setTripDetails(this.convertRest2TripDetails((RestTrip)params.getTrips().get(1), transferToken.getSearchResponse().getFrom(), transferToken.getEndAddress(), transferToken.getStartAddress(), transferToken.getSubAddresses(), params, transferToken.getBackPickUpDate()));
            creationParamsFrom.setTableCaption(((RestTrip)params.getTrips().get(1)).getTableCaption());
            creationParamsFrom.setTransferType(transferType);
            result.add(creationParamsFrom);
        }
        Date arriveDate = ((TransferReservationCreationParameters)result.get(result.size() - 1)).getTripDetails().getEnd().getTime();
        ArrayList<Traveller> travellers = new ArrayList<Traveller>();
        HashMap<Traveller, List<PersonCostCode>> travellersCostCodes = new HashMap<Traveller, List<PersonCostCode>>();
        for (TransferTraveller restTraveller : params.getTravellers()) {
            Traveller traveller = CommonConverterHelper.convertTravellerFromRest((RestTraveller)restTraveller, arriveDate);
            if (!restTraveller.getCostCodes().isEmpty()) {
                List<PersonCostCode> costCodes = CorporateClientHelper.convertPersonRestCostCodes(restTraveller.getCostCodes(), (EntityReference<Organization>)clientRef, (EntityReference<Person>)traveller.getPassenger());
                travellersCostCodes.put(traveller, costCodes);
            }
            travellers.add(traveller);
        }
        ReasonCode reasonCode = CommonConverterHelper.getReasonCode((EntityReference<Organization>)clientRef, params.getReasonCode(), ReasonCodeType.REASON_CODE_TRANSFER);
        ctx.putObject((Enum)IBusMidofficeContextKeys.TRAVELLERS, travellers);
        ctx.putObject((Enum)IBusIbecorpContextKeys.TRAVELLERS_COST_CODES, travellersCostCodes);
        ctx.putObject((Enum)IBusIbecorpContextKeys.REASON_CODE, (Object)reasonCode);
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATIONS_CREATION_PARAMETERS, result);
        ctx.putObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT, (Object)gdsAccountCtr);
        if (transferToken.getBookingFile() != null) {
            TripParameters tripParams = new TripParameters();
            tripParams.setBookingFileRef(transferToken.getBookingFile());
            ctx.putObject((Enum)IBusTripContextKeys.TRIP_PARAMETERS, (Object)tripParams);
        }
        Customer customer = params.getCustomer() != null ? CommonConverterHelper.convertRest2Customer(params.getCustomer()) : new Customer();
        ctx.putObject((Enum)IBusMidofficeContextKeys.CUSTOMER, (Object)customer);
        Map<DictionaryReference<ExternalSystem>, String> externalSystems = B2BRestHelper.convertExternalSystems(params.getExternalSystemCodes());
        ctx.putObject((Enum)IBusIbecorpContextKeys.EXTERNAL_SYSTEMS, externalSystems);
        ctx.putObject((Enum)IBusAuthorizationContextKeys.ACCEPT_PRODUCT_DUPLICATES_MESSAGE_ID, (Object)params.getAcceptProductDuplicatesMessageId());
        if (TextUtil.nonBlank((String)params.getBookingToken())) {
            AckMessage productDuplicatesMessage = B2BRestHelper.decodeToken(AckMessage.class, params.getBookingToken());
            ctx.putObject((Enum)IBusAuthorizationContextKeys.PRODUCT_DUPLICATES_MESSAGE, (Object)productDuplicatesMessage);
        }
    }

    private void fillCommonCreationParameters(TransferReservationCreationParameters creationParams, PricingParameters params, EntityContainer<? extends BaseTransferGdsAccount> gdsAccountCtr) {
        ContactPerson customer = params.getCustomer() == null ? new ContactPerson() : this.convert2ContactPerson(params.getCustomer());
        creationParams.setCustomer(customer);
        creationParams.setPassengersCount(Integer.valueOf(params.getTravellersCount()));
        creationParams.getPassengers().addAll(params.getTravellers().stream().map(this::convert2ContactPerson).collect(Collectors.toList()));
        creationParams.setNotes(params.getNotes());
        creationParams.setGdsAccount(gdsAccountCtr.toReference());
        creationParams.setLang(LocaleHelper.getCurrentLocale().getLanguage());
    }

    private TripPoint convertRest2TripPoint(TripPointParams rest, Subaddress address, Date defaultDate) {
        TripPoint point = new TripPoint();
        if (address != null) {
            point.setLocation(address.getLocation());
            point.setAddress(address.getAddress());
        }
        if (rest != null) {
            point.setTime(DateUtils.toJavaDate((LocalDateTime)rest.getTime()));
            point.setFlightNumber(rest.getFlightNumber());
            point.setTerminalNumber(rest.getTerminalNumber());
            point.setTrainNumber(rest.getTrainNumber());
            point.setTrainCarriageNumber(rest.getTrainCarriageNumber());
        } else {
            point.setTime(defaultDate);
        }
        return point;
    }

    private TripDetails convertRest2TripDetails(RestTrip rest, SearchGdsResponse response, Subaddress startLocation, Subaddress endLocation, List<Subaddress> subAddresses, PricingParameters params, Date startDate) {
        TripDetails tripDetails = new TripDetails();
        tripDetails.setStart(this.convertRest2TripPoint(rest.getStart(), startLocation, startDate));
        tripDetails.setEnd(this.convertRest2TripPoint(rest.getEnd(), endLocation, null));
        tripDetails.getSubAddresses().addAll(subAddresses);
        tripDetails.setSearchGdsResponse(response);
        tripDetails.setCancellationNoPenaltyHours(response.getCancellationNoPenaltyHours());
        tripDetails.setFlexibleTariff(params.isFlexibleTariff());
        tripDetails.setFlexibleTariffAgreement(params.isFlexibleTariffAgreement());
        HashMap typeToServiceInfoMap = new HashMap();
        response.getAvailableAdditionalServices().forEach(service -> typeToServiceInfoMap.put(service.getType(), service));
        tripDetails.getAdditionalServices().addAll(rest.getAdditionalServiceTypes().stream().map(typeToServiceInfoMap::get).collect(Collectors.toList()));
        return tripDetails;
    }

    private ContactPerson convert2ContactPerson(com.gridnine.xtrip.server.ibecorp.common.rest.model.Customer customer) {
        ContactPerson contactPerson = new ContactPerson();
        contactPerson.setName(TextUtil.join((String)" ", Arrays.asList(customer.getFirstName(), customer.getLastName()), (boolean)true));
        if (customer.getPhone() != null) {
            contactPerson.setPhone(CommonConverterHelper.convertRest2PhoneCommunication(customer.getPhone(), CommunicationType.MOBILE, Communication::new));
        }
        contactPerson.setEmail(customer.getEmail());
        return contactPerson;
    }

    private ContactPerson convert2ContactPerson(RestTraveller traveller) {
        ContactPerson contactPerson = new ContactPerson();
        if (traveller.getPassport() != null) {
            contactPerson.setName(TextUtil.join((String)" ", Arrays.asList(traveller.getPassport().getFirstName(), traveller.getPassport().getSecondName(), traveller.getPassport().getMiddleName(), traveller.getPassport().getLastName()), (boolean)true));
        }
        if (traveller.getPhone() != null) {
            contactPerson.setPhone(CommonConverterHelper.convertRest2PhoneCommunication(traveller.getPhone(), CommunicationType.MOBILE, Communication::new));
        }
        contactPerson.setEmail(traveller.getEmail());
        return contactPerson;
    }
}

