/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.transfers.search;

import com.gridnine.xtrip.common.midoffice.model.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.ibecorp.travelPolicy.TravelPolicyParameters;
import com.gridnine.xtrip.common.model.ibecorp.trip.IBusTripContextKeys;
import com.gridnine.xtrip.common.model.ibecorp.trip.TripParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.transfers.SearchParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.search.IBusIbecorpB2BSearchCtxKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.transfers.RestTransfersHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.IBusTravelPolicyContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.transfers.SearchRequest;
import com.gridnine.xtrip.server.transfers.ibus.IBusTransfersContextKeys;
import java.util.stream.Collectors;

public class SearchParametersConverter
extends BaseProcessor {
    public void process(MessageContext ctx) {
        SearchParameters restParams = (SearchParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        salesContext.setClient(restParams.getClient());
        SearchRequest request = new SearchRequest();
        request.setStartPlaceCoordinates(RestTransfersHelper.getCoordinates(restParams.getStartPlace()));
        request.setTransferType(restParams.getTransferType());
        request.setStartDate(restParams.getDate());
        switch (restParams.getTransferType()) {
            case TRANSFER: {
                request.setEndPlaceCoordinates(RestTransfersHelper.getCoordinates(restParams.getEndPlace()));
                request.getStartSubadresses().addAll(restParams.getSubAddresses().stream().map(RestTransfersHelper::convertSubaddressFromRest).collect(Collectors.toList()));
                boolean isRoundTrip = restParams.getBackDate() != null;
                request.setRoundTrip(isRoundTrip);
                if (!isRoundTrip) break;
                request.setBackwardDate(restParams.getBackDate());
                break;
            }
            case RENT: {
                request.setDuration(RestTransfersHelper.getDuration(restParams.getDate(), restParams.getEndRentDate()));
            }
        }
        if (restParams.getPassengersTypes() != null) {
            request.setAdultCount(Integer.valueOf(restParams.getPassengersTypes().getADULT()));
            request.setChildCount(Integer.valueOf(restParams.getPassengersTypes().getCHILD()));
        }
        ctx.putObject((Enum)IBusTransfersContextKeys.TRANSFERS_SEARCH_REQUEST, (Object)request);
        if (restParams.getClient() != null) {
            TravelPolicyParameters travelPolicyParams = new TravelPolicyParameters();
            travelPolicyParams.setClientRef(restParams.getClient());
            travelPolicyParams.getPersons().addAll(restParams.getPassengers());
            ctx.putObject((Enum)IBusTravelPolicyContextKeys.TRAVEL_POLICY_PARAMETERS, (Object)travelPolicyParams);
        }
        if (restParams.getBooking() != null) {
            TripParameters tripParams = new TripParameters();
            tripParams.setBookingFileRef(restParams.getBooking());
            ctx.putObject((Enum)IBusTripContextKeys.TRIP_PARAMETERS, (Object)tripParams);
        }
        ctx.putObject((Enum)IBusIbecorpB2BSearchCtxKeys.SELECTED_PASSENGERS, (Object)restParams.getPassengers());
    }
}

