/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.transfers.search;

import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.rest.Validatable;
import com.gridnine.xtrip.common.model.system.StandardValidationMessages;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.common.transfers.TransfersValidationMessages;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.transfers.SearchParameters;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.web.rest.ValidationHelper;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Date;

public class SearchParametersValidator
extends BaseProcessor {
    private static final int ALLOWABLE_SUB_ADDRESSES = 3;

    public void process(MessageContext ctx) {
        SearchParameters parameters = (SearchParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityReference siteRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        Date minimumDate = CommonHelper.getMinimumDate((EntityReference<SMSite>)siteRef);
        if (parameters.getStartPlace() == null) {
            parameters.getValidationContext().getStartPlaceValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
        }
        if (parameters.getDate() == null) {
            parameters.getValidationContext().getDateValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
        }
        if (parameters.getDate() != null && minimumDate != null && DateUtils.toJavaDate((LocalDateTime)parameters.getDate()).before(MiscUtil.clearTime((Date)minimumDate))) {
            parameters.getValidationContext().getDateValidationMessages().add(TransfersValidationMessages.getUnavailableDate());
        }
        switch (parameters.getTransferType()) {
            case TRANSFER: {
                if (parameters.getEndPlace() == null) {
                    parameters.getValidationContext().getEndPlaceValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
                }
                if (MiscUtil.equals((Object)parameters.getStartPlace(), (Object)parameters.getEndPlace())) {
                    parameters.getValidationContext().getEndPlaceValidationMessages().add(StandardValidationMessages.getWrongValue());
                }
                if (parameters.getBackDate() != null && MiscUtil.compare((Comparable)parameters.getBackDate(), (Comparable)parameters.getDate()) < 0) {
                    parameters.getValidationContext().getBackDateValidationMessages().add(StandardValidationMessages.getWrongValue());
                }
                if (!CollectionUtil.isNotEmpty((Collection)parameters.getSubAddresses()) || parameters.getSubAddresses().size() <= 3) break;
                parameters.getValidationContext().getSubAddressesValidationMessages().add(StandardValidationMessages.getWrongValue());
                break;
            }
            case RENT: {
                if (parameters.getEndRentDate() == null) {
                    parameters.getValidationContext().getEndRentDateValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
                    break;
                }
                if (parameters.getEndRentDate().compareTo(parameters.getDate()) >= 0) break;
                parameters.getValidationContext().getEndRentDateValidationMessages().add(StandardValidationMessages.getWrongValue());
            }
        }
        if (!ValidationHelper.isValid((Validatable)parameters)) {
            throw new ValidationException();
        }
    }
}

