/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.transfers.search;

import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.model.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Validatable;
import com.gridnine.xtrip.common.model.ibecorp.trip.IBusTripContextKeys;
import com.gridnine.xtrip.common.model.ibecorp.trip.TripParameters;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.common.model.validation.ValidationHelper;
import com.gridnine.xtrip.common.transfers.Subaddress;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.cabinet.CabinetHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.transfers.RestTransfer;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.transfers.SearchParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.transfers.SearchResult;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.transfers.RestTransfersHelper;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.TravelPolicyAction;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.transfers.SearchRequest;
import com.gridnine.xtrip.server.transfers.SearchResponse;
import com.gridnine.xtrip.server.transfers.ibus.IBusTransfersContextKeys;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class SearchResultConverter
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SearchParameters restParams = (SearchParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        SearchRequest request = (SearchRequest)ctx.getMandatoryObject((Enum)IBusTransfersContextKeys.TRANSFERS_SEARCH_REQUEST);
        if (!ValidationHelper.isValid((Validatable)request)) {
            this.copySubAddressesMessages(request.getStartSubadresses(), restParams);
            throw new ValidationException();
        }
        List responses = (List)ctx.getMandatoryObject((Enum)IBusTransfersContextKeys.TRANSFERS_SEARCH_RESPONSE);
        TripParameters tripParams = (TripParameters)ctx.getObject((Enum)IBusTripContextKeys.TRIP_PARAMETERS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        PriceComponentsParameters priceComponentsParameters = PriceComponentsParameters.getB2BComponentsParameters((EntityReference<Person>)((EntityReference)ctx.getObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER)), salesContext);
        ArrayList<RestTransfer> transfers = new ArrayList<RestTransfer>();
        for (SearchResponse response : responses) {
            RestTransfer restTransfer = RestTransfersHelper.convertToRestTransfer(response, (EntityReference<Organization>)salesContext.getClient(), restParams.getPassengers(), tripParams, RestTransfersHelper.convertSubaddressFromRest(restParams.getStartPlace()), RestTransfersHelper.convertSubaddressFromRest(restParams.getEndPlace()), restParams.getSubAddresses().stream().map(RestTransfersHelper::convertSubaddressFromRest).collect(Collectors.toList()), MiscUtil.toDate((LocalDateTime)restParams.getDate()), MiscUtil.toDate((LocalDateTime)restParams.getBackDate()), RestTransfersHelper.getDuration(restParams.getDate(), restParams.getEndRentDate(), response.getTo().getRentParams()), restParams.getPassengersTypes(), priceComponentsParameters);
            if (restTransfer.getTravelPolicyCompliance() != null && !restTransfer.getTravelPolicyCompliance().getRulesApplied().stream().noneMatch(r -> r.getAction() == TravelPolicyAction.HIDE)) continue;
            transfers.add(restTransfer);
        }
        SearchResult result = new SearchResult();
        result.getTransfers().addAll(transfers);
        result.setTravelPolicy(result.getTransfers().stream().anyMatch(t -> t.getTravelPolicyCompliance() != null));
        result.setIssueAllowed(CabinetHelper.isBookingGranted());
        if (CollectionUtil.isNotEmpty((Collection)restParams.getPassengers())) {
            result.setTravellersCount(Integer.valueOf(restParams.getPassengers().size()));
        }
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    private void copySubAddressesMessages(List<Subaddress> subAddresses, SearchParameters rest) {
        for (int i = 0; i < subAddresses.size(); ++i) {
            rest.getValidationContext().getSubAddressesListValidationMessages().put(i, subAddresses.get(i).getValidationContext().getAddressValidationMessages());
            rest.getValidationContext().getSubAddressesListValidationMessages().put(i, subAddresses.get(i).getValidationContext().getLocationValidationMessages());
        }
    }
}

