/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.transfers.sendToApprove;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.midoffice.model.BaseReservationCreationParameters;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.transfers.TransferType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.StandardValidationMessages;
import com.gridnine.xtrip.common.model.transfers.TransferReservationCreationParameters;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.common.transfers.ContactPerson;
import com.gridnine.xtrip.common.transfers.Subaddress;
import com.gridnine.xtrip.common.transfers.TripDetails;
import com.gridnine.xtrip.common.transfers.TripPoint;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.B2BRestHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.TransferOffer;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.transfers.RestTransferToken;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonRestHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonValidationHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.transfers.TransfersSendToApproveParameters;
import com.gridnine.xtrip.server.ibecorp.ibus.IBusIbeCorpContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.transfers.SearchGdsResponse;
import com.gridnine.xtrip.server.transfers.SearchResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class TransfersCreateIntentionParametersConverter
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        RestTransferToken firstWrapper;
        TransfersSendToApproveParameters restParameters = (TransfersSendToApproveParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        if (restParameters.isSendEmail()) {
            CommonValidationHelper.validationEmailMessages(restParameters.getEmails(), restParameters.getValidationContext().getEmailsListValidationMessages());
        }
        if (!restParameters.getTransferOffers().isEmpty()) {
            firstWrapper = CommonRestHelper.decodeToken(((TransferOffer)restParameters.getTransferOffers().get(0)).getTransferToken(), RestTransferToken.class);
            if (firstWrapper.getClient() != null) {
                salesContext.setClient(firstWrapper.getClient());
            }
        } else {
            restParameters.getValidationContext().getTransferOffersValidationMessages().add(StandardValidationMessages.getEmptyCollection());
            throw new ValidationException();
        }
        List passengers = firstWrapper.getSelectedPassengers();
        EntityReference bookingFile = firstWrapper.getBookingFile();
        EntityContainer bfCtr = EntityStorage.get().resolve(bookingFile);
        ArrayList<Traveller> availableTravellers = bfCtr != null ? new ArrayList<Traveller>(((BookingFile)bfCtr.getEntity()).getTravellers()) : new ArrayList();
        List<Traveller> travellers = this.getTravelers(passengers, availableTravellers);
        ArrayList<BaseReservationCreationParameters> reservationCreationParameters = new ArrayList<BaseReservationCreationParameters>();
        for (TransferOffer offer : restParameters.getTransferOffers()) {
            String token = offer.getTransferToken();
            RestTransferToken transferToken = CommonRestHelper.decodeToken(token, RestTransferToken.class);
            SearchResponse searchResponse = transferToken.getSearchResponse();
            TransferType transferType = transferToken.getEndAddress() == null ? TransferType.RENT : TransferType.TRANSFER;
            EntityContainer gdsAccountCtr = EntityStorage.get().resolve(searchResponse.getTo().getGdsAccount());
            TripDetails tripDetailsTo = this.buildTripDetails(transferToken.getStartAddress(), transferToken.getEndAddress(), transferToken.getSubAddresses(), transferToken.getPickUpDate(), transferToken.getDuration(), transferToken.getAdultCount(), transferToken.getChildCount(), searchResponse.getTo());
            this.creationParams(travellers, tripDetailsTo, transferType, searchResponse.getTo(), (EntityContainer<? extends BaseGdsAccount>)gdsAccountCtr, reservationCreationParameters);
            if (searchResponse.getFrom() == null) continue;
            TripDetails tripDetailsFrom = this.buildTripDetails(transferToken.getEndAddress(), transferToken.getStartAddress(), transferToken.getSubAddresses(), transferToken.getBackPickUpDate(), null, transferToken.getAdultCount(), transferToken.getChildCount(), searchResponse.getFrom());
            this.creationParams(travellers, tripDetailsFrom, transferType, searchResponse.getFrom(), (EntityContainer<? extends BaseGdsAccount>)gdsAccountCtr, reservationCreationParameters);
        }
        Customer customer = B2BRestHelper.createCustomer(travellers.get(0), salesContext);
        ctx.putObject((Enum)IBusMidofficeContextKeys.TRAVELLERS, travellers);
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATIONS_CREATION_PARAMETERS, reservationCreationParameters);
        ctx.putObject((Enum)IBusMidofficeContextKeys.CUSTOMER, (Object)customer);
        if (bookingFile != null) {
            ctx.putObject((Enum)IBusMidofficeContextKeys.ADD_TO_BOOKING_FILE, (Object)bookingFile);
        }
        ctx.putObject((Enum)IBusIbeCorpContextKeys.IS_PROPOSAL, (Object)Boolean.TRUE);
    }

    private void creationParams(List<Traveller> travellers, TripDetails tripDetails, TransferType transferType, SearchGdsResponse response, EntityContainer<? extends BaseGdsAccount> gdsAccountCtr, Collection<BaseReservationCreationParameters> reservationCreationParameters) {
        TransferReservationCreationParameters creationParams = new TransferReservationCreationParameters();
        this.fillPassengersInfo(creationParams, travellers);
        creationParams.setTripDetails(tripDetails);
        creationParams.setGdsAccount(response.getGdsAccount());
        creationParams.setTransferType(transferType);
        reservationCreationParameters.add((BaseReservationCreationParameters)creationParams);
    }

    private void fillPassengersInfo(TransferReservationCreationParameters creationParams, Collection<Traveller> travellers) {
        creationParams.setPassengersCount(Integer.valueOf(travellers.size()));
        creationParams.getPassengers().addAll(travellers.stream().map(this::convert2ContactPerson).collect(Collectors.toList()));
    }

    private TripDetails buildTripDetails(Subaddress startLocation, Subaddress endLocation, List<Subaddress> subAddresses, Date date, Integer duration, Integer adult, Integer child, SearchGdsResponse response) {
        TripDetails details = new TripDetails();
        TripPoint startPoint = new TripPoint();
        startPoint.setLocation(startLocation.getLocation());
        startPoint.setAddress(startLocation.getAddress());
        startPoint.setTime(date);
        details.setStart(startPoint);
        TripPoint endPoint = new TripPoint();
        if (endLocation != null) {
            endPoint.setLocation(endLocation.getLocation());
            endPoint.setAddress(endLocation.getAddress());
        }
        details.setEnd(endPoint);
        details.getSubAddresses().addAll(subAddresses);
        details.setSearchGdsResponse(response);
        if (duration != null) {
            details.setDuration(duration);
            details.getEnd().setTime(MiscUtil.addSecondsToDate((Date)date, (int)duration));
        }
        details.setFlexibleTariff(response.isFlexibleTariff());
        details.setFlexibleTariffAgreement(response.isFlexibleTariffAgreement());
        details.setCancellationNoPenaltyHours(response.getCancellationNoPenaltyHours());
        details.setAdultCount(adult.intValue());
        details.setChildCount(child.intValue());
        return details;
    }

    private List<Traveller> getTravelers(List<EntityReference<Person>> passengers, List<Traveller> availableTravellers) {
        ArrayList<Traveller> travellers = new ArrayList<Traveller>();
        if (CollectionUtil.isEmpty(passengers)) {
            CommonConverterHelper.getIfEmptyTraveller(travellers, availableTravellers);
        } else {
            for (EntityReference<Person> personRef : passengers) {
                CommonConverterHelper.getTraveller(travellers, availableTravellers, personRef);
            }
        }
        return travellers;
    }

    private ContactPerson convert2ContactPerson(Traveller traveller) {
        ContactPerson person = new ContactPerson();
        person.setName(traveller.getName());
        person.setEmail(ProfileHelper.getCommunicationEmail((List)traveller.getCommunications()));
        person.setPhone(ProfileHelper.getPhoneCommunication((List)traveller.getCommunications()));
        return person;
    }
}

