/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.translation;

import com.gridnine.xtrip.server.ibecorp.common.rest.model.translation.RestTranslateParameters;
import com.gridnine.xtrip.server.ibus.components.BaseTargetsProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GoogleTranslatePartsProvider
extends BaseTargetsProvider<String> {
    private static final int MAX_LENGTH = 5000;
    private static final char[] chars = new char[]{'.', ';', ' '};

    public Collection<String> getTargets(MessageContext ctx) {
        RestTranslateParameters params = (RestTranslateParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        return GoogleTranslatePartsProvider.split(params.getText());
    }

    private static List<String> split(String source) {
        ArrayList<String> result = new ArrayList<String>();
        String src = source;
        while (!src.isEmpty()) {
            if (GoogleTranslatePartsProvider.getSize(src) < 5000) {
                result.add(src);
                break;
            }
            boolean found = false;
            String substr = GoogleTranslatePartsProvider.trim(src);
            for (char c : chars) {
                int last = substr.lastIndexOf(c);
                if (last < 0) continue;
                String part = src.substring(0, last + 1);
                result.add(part);
                src = src.substring(last + 1);
                found = true;
                break;
            }
            if (found) continue;
            result.add(substr);
            src = src.substring(substr.length());
        }
        return result;
    }

    private static String trim(String str) {
        int len = str.length();
        int bytes = 0;
        for (int index = 0; index < len; ++index) {
            if ((bytes += GoogleTranslatePartsProvider.getSize(String.valueOf(str.charAt(index)))) <= 5000) continue;
            return str.substring(0, index);
        }
        return str;
    }

    private static int getSize(String str) {
        if (str == null) {
            return 0;
        }
        return str.getBytes(StandardCharsets.UTF_8).length;
    }
}

