/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.translation;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.system.HttpRequest;
import com.gridnine.xtrip.common.model.system.RequestMethod;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.translation.IBusRestTranslationContextKeys;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.translation.RestTranslateParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.model.ibus.http.IBusHttpContextKeys;

public class GoogleTranslateRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) {
        RestTranslateParameters params = (RestTranslateParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        String textPart = (String)ctx.getMandatoryObject((Enum)IBusRestTranslationContextKeys.TRANSLATE_PART);
        String inputLang = params.getInputLang();
        String outputLang = params.getOutputLang();
        if (TextUtil.isBlank((String)outputLang)) {
            throw Xeption.forDeveloper((String)"outputLang is empty", (Object[])new Object[0]);
        }
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl("https://translate.google.com/translate_a/single");
        httpRequest.setRequestMethod(RequestMethod.GET);
        httpRequest.getQueryParameters().put((Object)"client", (Object)new String[]{"gtx"});
        httpRequest.getQueryParameters().put((Object)"sl", (Object)new String[]{TextUtil.isBlank((String)inputLang) ? "auto" : inputLang});
        httpRequest.getQueryParameters().put((Object)"tl", (Object)new String[]{outputLang});
        httpRequest.getQueryParameters().put((Object)"dt", (Object)new String[]{"t"});
        httpRequest.getQueryParameters().put((Object)"q", (Object)new String[]{textPart});
        ctx.putObject((Enum)IBusHttpContextKeys.HTTP_REQUEST, (Object)httpRequest);
    }
}

