/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest.translation;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.system.HttpResponse;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.translation.RestTranslateResult;
import com.gridnine.xtrip.server.ibus.IbusHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.model.ibus.http.IBusHttpContextKeys;
import java.nio.charset.StandardCharsets;
import org.json.JSONArray;

public class GoogleTranslateResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) {
        HttpResponse httpResponse = (HttpResponse)ctx.getMandatoryObject((Enum)IBusHttpContextKeys.HTTP_RESPONSE);
        if (httpResponse.getResponseCode() != 200) {
            throw Xeption.forDeveloper((String)httpResponse.getResponseMessage(), (Object[])new Object[0]);
        }
        RestTranslateResult result = (RestTranslateResult)IbusHelper.getObjectN((MessageContext)ctx, (Enum)IBusRestContextKeys.REST_RESULT, RestTranslateResult::new);
        try {
            String content = new String(httpResponse.getBody(), StandardCharsets.UTF_8);
            JSONArray jsonArray = new JSONArray(content);
            JSONArray translationParts = jsonArray.getJSONArray(0);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < translationParts.length(); ++i) {
                sb.append(translationParts.getJSONArray(i).getString(0));
            }
            String translatedText = sb.toString();
            if (TextUtil.nonBlank((String)translatedText)) {
                result.setText(MiscUtil.guarded((String)result.getText()) + translatedText);
            }
        }
        catch (Exception ex) {
            throw Xeption.forDeveloper((String)"response parsing failed", (Throwable)ex, (Object[])new Object[0]);
        }
    }
}

