/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.gds.trace.GdsTracingHelper;
import com.gridnine.xtrip.common.ibecorp.l10n.Messages;
import com.gridnine.xtrip.common.ibecorp.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceCategory;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceProduct;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.SabreMaskHelper;
import com.gridnine.xtrip.common.model.ibecorp.TimeZoneEx;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMAccessSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMBookingControlSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMProfileType;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMStep1Settings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMStep2Settings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMStep3Settings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMStep4Settings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMVisualSettings;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationMetadataIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.BasicSystemSettingsIndex;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.Phone;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.RestContext;
import java.math.BigDecimal;
import java.math.MathContext;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;

public class CommonHelper {
    private static final String LOCALE_PARAM = "locale";
    private static final long MILLIS_IN_DAY = TimeUnit.DAYS.toMillis(1L);

    private CommonHelper() {
    }

    public static SMGeneralSettings getGeneralSettings(EntityReference<SMSite> siteRef) {
        EntityReference generalSettingsRef = ProfileHelper.getProfile(siteRef, (SMProfileType)SMProfileType.GENERAL_SETTINGS);
        EntityContainer generalSettings = ((EntityStorage)Environment.getPublished(EntityStorage.class)).resolve(generalSettingsRef);
        if (Objects.nonNull(generalSettings)) {
            return (SMGeneralSettings)generalSettings.getEntity();
        }
        return null;
    }

    public static GdsTracingSettings getGdsTracingSettings(SalesContext salesContext) {
        String login = null;
        if (salesContext != null) {
            EntityContainer loggedPersonCtr = EntityStorage.get().resolve(salesContext.getCustomer());
            if (loggedPersonCtr == null) {
                loggedPersonCtr = EntityStorage.get().resolve(salesContext.getAgent());
            }
            if (loggedPersonCtr != null) {
                login = ((Person)loggedPersonCtr.getEntity()).getLoginName();
            }
        } else {
            login = UserData.get().getCurrentUser();
        }
        if (login != null) {
            String compoundKey = GdsTracingHelper.getCompoundKey((String)login);
            EntityContainer ctr = EntityStorage.get().find(BasicSystemSettingsIndex.class, BasicSystemSettingsIndex.Property.compoundKey.name(), (Object)compoundKey);
            if (ctr == null) {
                return null;
            }
            return (GdsTracingSettings)ctr.getEntity();
        }
        return null;
    }

    public static SMStep1Settings getStep1Settings(EntityReference<SMSite> siteRef) {
        EntityReference step1SettingsRef = ProfileHelper.getProfile(siteRef, (SMProfileType)SMProfileType.STEP1_SETTINGS);
        EntityContainer step1Settings = ((EntityStorage)Environment.getPublished(EntityStorage.class)).resolve(step1SettingsRef);
        if (Objects.nonNull(step1Settings)) {
            return (SMStep1Settings)step1Settings.getEntity();
        }
        return null;
    }

    public static SMStep2Settings getStep2Settings(EntityReference<SMSite> siteRef) {
        EntityReference step2SettingsRef = ProfileHelper.getProfile(siteRef, (SMProfileType)SMProfileType.STEP2_SETTINGS);
        EntityContainer step2Settings = ((EntityStorage)Environment.getPublished(EntityStorage.class)).resolve(step2SettingsRef);
        if (Objects.nonNull(step2Settings)) {
            return (SMStep2Settings)step2Settings.getEntity();
        }
        return null;
    }

    public static SMStep3Settings getStep3Settings(EntityReference<SMSite> siteRef) {
        EntityReference step3SettingsRef = ProfileHelper.getProfile(siteRef, (SMProfileType)SMProfileType.STEP3_SETTINGS);
        EntityContainer step3Settings = ((EntityStorage)Environment.getPublished(EntityStorage.class)).resolve(step3SettingsRef);
        if (Objects.nonNull(step3Settings)) {
            return (SMStep3Settings)step3Settings.getEntity();
        }
        return null;
    }

    public static SMStep4Settings getStep4Settings(EntityReference<SMSite> siteRef) {
        EntityReference step4SettingsRef = ProfileHelper.getProfile(siteRef, (SMProfileType)SMProfileType.STEP4_SETTINGS);
        EntityContainer step4Settings = ((EntityStorage)Environment.getPublished(EntityStorage.class)).resolve(step4SettingsRef);
        if (Objects.nonNull(step4Settings)) {
            return (SMStep4Settings)step4Settings.getEntity();
        }
        return null;
    }

    public static SMVisualSettings getVisualSettings(EntityReference<SMSite> siteRef) {
        EntityReference visualSettingsRef = ProfileHelper.getProfile(siteRef, (SMProfileType)SMProfileType.VISUAL_SETTINGS);
        EntityContainer visualSettings = ((EntityStorage)Environment.getPublished(EntityStorage.class)).resolve(visualSettingsRef);
        if (Objects.nonNull(visualSettings)) {
            return (SMVisualSettings)visualSettings.getEntity();
        }
        return null;
    }

    public static SMAccessSettings getAccessSettings(EntityReference<SMSite> siteRef) {
        EntityReference visualSettingsRef = ProfileHelper.getProfile(siteRef, (SMProfileType)SMProfileType.ACCESS_SETTINGS);
        EntityContainer visualSettings = ((EntityStorage)Environment.getPublished(EntityStorage.class)).resolve(visualSettingsRef);
        if (Objects.nonNull(visualSettings)) {
            return (SMAccessSettings)visualSettings.getEntity();
        }
        return null;
    }

    public static SMBookingControlSettings getBookingControlSettings(EntityReference<SMSite> siteRef) {
        EntityReference bookingControlSettingsRef = ProfileHelper.getProfile(siteRef, (SMProfileType)SMProfileType.BOOKING_CONTROL_SETTINGS);
        EntityContainer bookingControlSettings = ((EntityStorage)Environment.getPublished(EntityStorage.class)).resolve(bookingControlSettingsRef);
        if (Objects.nonNull(bookingControlSettings)) {
            return (SMBookingControlSettings)bookingControlSettings.getEntity();
        }
        return null;
    }

    public static <T extends Enum<?>> String getEnumsCaptionsJoin(Collection<T> enums) {
        return enums.stream().map(t -> t.toString()).collect(Collectors.joining(","));
    }

    public static <T extends BaseEntity> String getElementsCaptionJoin(Collection<T> elements, Function<T, String> captionProvider) {
        return elements.stream().map(captionProvider).collect(Collectors.joining(","));
    }

    public static <T extends BaseEntity> String getElementsCaptionsJoin(Collection<T> elements, Function<T, String> ... captionProviders) {
        return String.join((CharSequence)",", elements.stream().map(t -> String.join((CharSequence)"|", Arrays.asList(captionProviders).stream().map(tStringFunction -> (String)tStringFunction.apply(t)).collect(Collectors.toList()))).collect(Collectors.toList()));
    }

    public static <Key, Value, T> Map<Key, Value> convertCollectionToMap(Collection<T> collection, Function<T, Key> keyFunction, Function<T, Value> valueFunction) {
        return collection.stream().collect(Collectors.toMap(keyFunction, valueFunction));
    }

    public static String getLocalizedString(String key, Object ... parameters) {
        return L10nResourcesManager.createL10nMessage((String)key, (Object[])parameters).toString();
    }

    public static <T extends Communication> Optional<T> getEmail(List<T> communications) {
        return communications.stream().filter(communication -> communication.getType() == CommunicationType.EMAIL).findFirst();
    }

    public static <T extends Communication> List<T> getEmails(List<T> communications) {
        return communications.stream().filter(communication -> communication.getType() == CommunicationType.EMAIL).collect(Collectors.toList());
    }

    public static <T extends Communication> Optional<T> getPhone(List<T> communications, CommunicationType ... types) {
        HashSet<CommunicationType> typeSet = new HashSet<CommunicationType>(Arrays.asList(types));
        return communications.stream().filter(communication -> typeSet.contains(communication.getType())).findFirst();
    }

    public static <T extends Communication> List<T> getPhones(List<T> communications, CommunicationType ... types) {
        HashSet<CommunicationType> typeSet = new HashSet<CommunicationType>(Arrays.asList(types));
        return communications.stream().filter(communication -> typeSet.contains(communication.getType())).collect(Collectors.toList());
    }

    public static String buildPhoneNumber(Communication communication) {
        StringBuilder result = new StringBuilder();
        result.append("+").append(communication.getCountryCode()).append(communication.getCityCode()).append(communication.getSense());
        if (communication.getType() == CommunicationType.WORK_PHONE && !TextUtil.isBlank((String)communication.getInternalNumber())) {
            result.append("#").append(communication.getInternalNumber());
        }
        return result.toString();
    }

    public static <T extends BaseEntity> List<String> getUids(List<T> travellers) {
        return travellers.stream().map(BaseIdentity::getUid).collect(Collectors.toList());
    }

    public static BigDecimal round(BigDecimal value) {
        BigDecimal val = value.stripTrailingZeros();
        int newPrecision = val.precision() - val.scale() + 2;
        if (newPrecision < 0) {
            return val;
        }
        return val.round(new MathContext(newPrecision));
    }

    public static Locale getRequestedLocale(RestContext context) {
        HttpServletRequest request = context.getRequest();
        Locale locale = new Locale("ru");
        String localeParam = request.getParameter(LOCALE_PARAM);
        if (!TextUtil.isBlank((String)localeParam)) {
            locale = new Locale(localeParam);
        }
        return locale;
    }

    public static EntityReference<Organization> findMainAgency() {
        EntityReference result = null;
        EntityContainer<Organization> orgCont = CommonHelper.findMainAgencyCtr();
        if (orgCont != null && orgCont.getEntity() != null) {
            result = orgCont.toReference();
        }
        return result;
    }

    public static EntityContainer<Organization> findMainAgencyCtr() {
        EntityContainer result = null;
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)OrganizationMetadataIndex.Property.types.name(), (Object)OrganizationType.AGENCY.name()));
        query.getCriteria().getCriterions().add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)OrganizationMetadataIndex.Property.metadataKey.name(), (Object)MetadataKey.KEY_MAIN_AGENCY.name()), SearchCriterion.eq((String)OrganizationMetadataIndex.Property.metadataBooleanValue.name(), (Object)Boolean.TRUE)}));
        List indices = EntityStorage.get().search(OrganizationMetadataIndex.class, query).getData();
        if (!indices.isEmpty()) {
            result = EntityStorage.get().resolve(((OrganizationMetadataIndex)indices.get(0)).getSource());
        }
        return result;
    }

    public static String buildAllPhoneNumbersByType(List<Communication> communications, CommunicationType communicationType) {
        StringBuilder result = new StringBuilder();
        boolean hasFirst = false;
        for (Communication communication : communications) {
            if (communication.getType() != communicationType) continue;
            if (hasFirst) {
                result.append(", ");
            }
            hasFirst = true;
            result.append(CommonHelper.buildPhoneNumber(communication));
        }
        return result.toString();
    }

    public static boolean isEmpty(Phone phone) {
        return phone == null || TextUtil.isBlank((String)phone.getCountryCode()) || TextUtil.isBlank((String)phone.getNumber()) || TextUtil.isBlank((String)phone.getCityCode()) && phone.getNumber().length() < 4;
    }

    public static String getOperatingAirlineCompanyName(DictionaryReference<Airline> airlineRef, String key) {
        if (airlineRef == null || TextUtil.isBlank((String)key)) {
            return null;
        }
        Airline airline = (Airline)DictionaryCache.get().resolveReference(airlineRef);
        String codeVariant = DictHelper.getCodeVariant((BaseDictionary)airline, (CodeSystem)CodeSystem.IATA);
        if ("J2".equals(codeVariant) && key.replaceAll("[^A-Za-z ]", "").equals("BUTA AIRWAYS")) {
            return L10nResourcesManager.getStr((String)Messages.OperatingAirlineButaAirWays, (Object[])new Object[0]);
        }
        return null;
    }

    public static int sortByPassengerType(DictionaryReference<PassengerType> pt1, DictionaryReference<PassengerType> pt2) {
        return com.gridnine.xtrip.common.ibecorp.common.CommonHelper.getPassengerTypeRank(pt2) - com.gridnine.xtrip.common.ibecorp.common.CommonHelper.getPassengerTypeRank(pt1);
    }

    public static Map<Traveller, List<BaseProduct>> getTravellerProductsMap(Reservation reservation) {
        List prodList = reservation.getProducts().stream().filter(bp -> bp instanceof Product).map(bp -> (Product)bp).filter(p -> p.getTicketType() != TicketType.CORRECTION).filter(p -> p.getProductCategory() == ProductCategory.AIR || p.getProductCategory() == ProductCategory.MCO).collect(Collectors.toList());
        prodList.addAll(reservation.getProducts().stream().filter(bp -> bp instanceof AdditionalServiceProduct).map(bp -> (AdditionalServiceProduct)bp).filter(p -> p.getTicketType() != TicketType.CORRECTION).filter(asp -> asp.getCategory() == AdditionalServiceCategory.CERTIFICATE_OF_COMPLETED_FLIGHT).collect(Collectors.toList()));
        LinkedHashMap<Traveller, List<BaseProduct>> travellerProductsMap = new LinkedHashMap<Traveller, List<BaseProduct>>(reservation.getBookingFile().getTravellers().size());
        for (BaseProduct prod : prodList) {
            Traveller traveller = (Traveller)CollectionUtil.head((Iterable)ProductHandler.of((BaseProduct)prod).getTravellers(prod));
            if (!travellerProductsMap.containsKey(traveller)) {
                travellerProductsMap.put(traveller, new ArrayList());
            }
            ((List)travellerProductsMap.get(traveller)).add(prod);
        }
        return travellerProductsMap;
    }

    public static <T extends BaseProduct> Map<Traveller, List<T>> getTravellerBaseProductsMap(Reservation reservation, Class<T> clazz) {
        return CommonHelper.getTravellerBaseProductsMap(reservation, clazz, rp -> true);
    }

    public static <T extends BaseProduct> Map<Traveller, List<T>> getTravellerBaseProductsMap(Reservation reservation, Class<T> clazz, Predicate<T> productFilter) {
        LinkedHashMap travellerProductsMap = new LinkedHashMap(reservation.getBookingFile().getTravellers().size());
        BookingStreamHelper.getProductsStream((Reservation)reservation, clazz).filter(productFilter).filter(prod -> ProductHandler.of((BaseProduct)prod).getTicketType(prod) != TicketType.CORRECTION).forEach(prod -> {
            Traveller traveller = GeneralProductHelper.getTraveller((BaseProduct)prod);
            if (!travellerProductsMap.containsKey(traveller)) {
                travellerProductsMap.put(traveller, new ArrayList());
            }
            ((List)travellerProductsMap.get(traveller)).add(prod);
        });
        return travellerProductsMap;
    }

    public static Collection<Reservation> getReservations(MessageContext ctx) {
        Collection reservations = (Collection)ctx.getObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_RESERVATIONS_PERFORMED);
        if (reservations != null) {
            return reservations;
        }
        return (Collection)ctx.getObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_RESERVATIONS);
    }

    public static LocalDateTime getCorrectTimeLimit(Reservation reservation, SMGeneralSettings generalSettings) {
        Date timeLimit = reservation.getTimeLimit();
        if (timeLimit == null) {
            return null;
        }
        LocalDateTime localDateTime = CommonHelper.getCorrectTime(timeLimit, generalSettings);
        boolean isAviaOrRailReservation = BookingHelper.isReservationForProducts((Reservation)reservation, (Class[])new Class[]{RailwayProduct.class, Product.class});
        return isAviaOrRailReservation ? localDateTime : localDateTime.minusMinutes(15L);
    }

    public static LocalDateTime getCorrectTime(Date date, SMGeneralSettings generalSettings) {
        if (date == null) {
            return null;
        }
        return LocalDateTime.ofInstant(date.toInstant(), CommonHelper.getTimeZone(generalSettings).getTimeZone().toZoneId());
    }

    public static TimeZoneEx getTimeZone(SMGeneralSettings settings) {
        TimeZoneEx result;
        EntityContainer currentUserCtr = com.gridnine.xtrip.common.model.helpers.ProfileHelper.getCurrentUserCtr();
        if (currentUserCtr == null) {
            return CommonHelper.getGuardedTimeZone(settings.getTimeZone());
        }
        HashSet<EntityContainer<Organization>> seen = new HashSet<EntityContainer<Organization>>();
        EntityContainer mainEmployment = com.gridnine.xtrip.common.model.helpers.ProfileHelper.getMainEmployment((Person)((Person)currentUserCtr.getEntity()));
        if (mainEmployment != null && (result = CommonHelper.findTimeZone((EntityContainer<Organization>)mainEmployment, seen)) != null) {
            return result;
        }
        for (EntityContainer orgCtr : com.gridnine.xtrip.common.model.helpers.ProfileHelper.getEmployments((Person)((Person)currentUserCtr.getEntity()))) {
            TimeZoneEx result2 = CommonHelper.findTimeZone((EntityContainer<Organization>)orgCtr, seen);
            if (result2 == null) continue;
            return result2;
        }
        return CommonHelper.getGuardedTimeZone(settings.getTimeZone());
    }

    private static TimeZoneEx findTimeZone(EntityContainer<Organization> orgCtr, Set<EntityContainer<Organization>> seen) {
        if (seen.contains(orgCtr)) {
            return null;
        }
        if (((Organization)orgCtr.getEntity()).getTimeZoneEx() != null) {
            return ((Organization)orgCtr.getEntity()).getTimeZoneEx();
        }
        seen.add(orgCtr);
        HashSet<ContractType> contractTypes = new HashSet<ContractType>();
        contractTypes.add(ContractType.CLIENT);
        contractTypes.add(ContractType.SUBAGENCY);
        for (EntityReference suppRef : com.gridnine.xtrip.common.model.helpers.ProfileHelper.getOrganizationSuppliers((EntityReference)orgCtr.toReference(), contractTypes, (Date)new Date())) {
            TimeZoneEx result;
            EntityContainer suppCtr = EntityStorage.get().resolve(suppRef);
            if (suppCtr == null || (result = CommonHelper.findTimeZone((EntityContainer<Organization>)suppCtr, seen)) == null) continue;
            return result;
        }
        return null;
    }

    private static TimeZoneEx getGuardedTimeZone(TimeZoneEx timeZone) {
        return timeZone == null ? TimeZoneEx.EUROPE_MOSCOW : timeZone;
    }

    public static Collection<Traveller> collectTravellers(Reservation reservation) {
        return CommonHelper.getReservationTravellersStream(reservation).collect(Collectors.toList());
    }

    public static Stream<Traveller> getReservationTravellersStream(Reservation reservation) {
        return CommonHelper.getProductTravellersStream(reservation.getProducts());
    }

    public static Stream<Traveller> getProductTravellersStream(Collection<BaseProduct> products) {
        return products.stream().filter(Objects::nonNull).map(GeneralProductHelper::getTravellers).flatMap(Collection::stream).filter(Objects::nonNull).distinct();
    }

    public static EntityReference<SalesPoint> getSalesPoint(EntityReference<SMSite> siteRef) {
        return Optional.ofNullable(CommonHelper.getGeneralSettings(siteRef)).map(SMGeneralSettings::getDefaultSalesPoint).orElse(null);
    }

    public static boolean validationMaskUdids(Supplier<String> maskSupplier, String value) {
        return new SabreMaskHelper(maskSupplier).isValid(value);
    }

    public static Date getMinimumDate(EntityReference<SMSite> siteRef) {
        try {
            long numDaysFromToday = CommonHelper.getGeneralSettings(siteRef).getCalendarSettings().getDaysShift();
            return new Date(System.currentTimeMillis() + numDaysFromToday * MILLIS_IN_DAY);
        }
        catch (Exception e) {
            return null;
        }
    }
}

