/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.server.ibecorp.handlers.rules.IbecorpRailwayRulesProductHandler;
import com.gridnine.xtrip.server.model.handlers.rules.AirRulesHelper;
import com.gridnine.xtrip.server.model.handlers.rules.GeneralProductRulesHelper;
import com.gridnine.xtrip.server.model.handlers.rules.RulesProductHandler;
import com.gridnine.xtrip.server.model.handlers.rules.TransferRulesHandler;
import com.gridnine.xtrip.server.model.handlers.rules.hotel.HotelRulesHelper;
import com.gridnine.xtrip.server.pg.helper.AllowedPaymentTypesHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class IbeAllowedPaymentTypesHandler
implements AllowedPaymentTypesHandler {
    public Set<PaymentType> getAllowedPaymentTypes(EntityContainer<BookingFile> bookingFileCtr) {
        return this.getAllowedPaymentTypes(bookingFileCtr, ((BookingFile)bookingFileCtr.getEntity()).getReservations());
    }

    public Set<PaymentType> getAllowedPaymentTypes(EntityContainer<BookingFile> bookingFileCtr, Collection<Reservation> reservations) {
        Set<PaymentType> result = null;
        IbecorpRailwayRulesProductHandler railwayHandler = new IbecorpRailwayRulesProductHandler();
        RulesProductHandler transferHandler = TransferRulesHandler.get().createRulesHandler();
        for (Reservation reservation : reservations) {
            HashSet<PaymentType> pts = new HashSet<PaymentType>();
            pts.addAll(AirRulesHelper.getAllowedPaymentTypes((Reservation)reservation));
            pts.addAll(GeneralProductRulesHelper.getAllowedPaymentTypes((Reservation)reservation, (RulesProductHandler)railwayHandler));
            pts.addAll(HotelRulesHelper.getAllowedPaymentTypes((Reservation)reservation));
            pts.addAll(GeneralProductRulesHelper.getAllowedPaymentTypes((Reservation)reservation, (RulesProductHandler)transferHandler));
            Set<Object> set = result != null ? result.stream().filter(pts::contains).collect(Collectors.toSet()) : pts;
            result = set;
            if (!result.isEmpty()) continue;
            break;
        }
        return result != null ? result : Collections.emptySet();
    }
}

