/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.components;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.AncillaryFee;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightMultiTicketItem;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.GdsContractRelationData;
import com.gridnine.xtrip.common.ibecorp.model.helpers.IbecorpPriceStructureHelper;
import com.gridnine.xtrip.common.midoffice.model.BaseAncillaryFee;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseCommission;
import com.gridnine.xtrip.common.model.booking.ContractRelationServiceData;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.SimpleTax;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.XtripPriceStructure;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.B2BRestHelper;
import com.gridnine.xtrip.server.ibecorp.common.components.ComponentsHelper;
import com.gridnine.xtrip.server.ibecorp.common.components.GeneralPriceComponents;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.AncillaryFeesPrice;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.Price;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Passenger;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.RestSeat;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.RestAncillaryFee;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.RestAncillaryFeeType;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.RestBaseAncillaryFee;
import com.gridnine.xtrip.server.ibecorp.ibus.rules.PriceDetailRuleHelper;
import com.gridnine.xtrip.server.ibecorp.model.rest.avia.RestAircraftSeatToken;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class AviaPriceComponents
extends GeneralPriceComponents {
    private final Flight flight;
    private final List<Passenger> passengers = new ArrayList<Passenger>();
    private final Map<Passenger, List<GeneralPriceComponents.PassengerPriceStructure>> passenger2ppsMap = new HashMap<Passenger, List<GeneralPriceComponents.PassengerPriceStructure>>();
    private final Map<DictionaryReference<PassengerType>, BigDecimal> separatedAncillaryFeesMap = new HashMap<DictionaryReference<PassengerType>, BigDecimal>();
    private final XtripPriceStructure separatedAncillaryFeesPriceStructure = new XtripPriceStructure();

    public static Builder builder(Flight flight, PriceComponentsParameters componentsParameters) {
        return new Builder(flight, componentsParameters);
    }

    public BigDecimal getSeparatedAncillaryFee(DictionaryReference<PassengerType> passengerType) {
        BigDecimal result = this.separatedAncillaryFeesMap.get(passengerType);
        return MiscUtil.guarded((BigDecimal)result);
    }

    @Override
    public BigDecimal getTotal() {
        return MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.calcPassengerPriceValue(GeneralPriceComponents.PassengerPriceStructure::getTotal), this.separatedAncillaryFeesPriceStructure.getTotal()});
    }

    private AviaPriceComponents(Flight flight, PriceComponentsParameters componentsParameters) {
        super(componentsParameters, PriceDetailRuleHelper.getPriceDetailDisplay(flight, componentsParameters.getSalesContext()));
        this.flight = flight;
        this.taxSupported = true;
    }

    private void buildPriceStructures() {
        this.setCurrencies(this.flight);
        this.passengersMap.putAll(GDSHelper.seatPreferencesToMap((List)this.flight.getSeats()));
        if (this.flight.getMultiTicketBreakdown().isEmpty()) {
            this.buildStructures(this.flight.getContractRelations(), null);
        } else {
            this.flight.getMultiTicketBreakdown().forEach(flightMultiTicketItem -> this.buildStructures(flightMultiTicketItem.getContractRelations(), this.getRouteLine((FlightMultiTicketItem)flightMultiTicketItem)));
        }
        this.fillAncillaryFeesPriceStructure(this.flight);
        if (this.parameters.isCalculateSubagentPrice()) {
            this.totalSubagent = this.calculateSubagentTotalPrice(this.flight);
        }
        if (CollectionUtil.isNotEmpty(this.parameters.getDisplayCurrencies())) {
            this.rates = ComponentsHelper.getCurrencyRates(this.currency, this.getTotal(), this.parameters.getDisplayCurrencies());
        }
    }

    private void buildStructures(Map<DictionaryReference<PassengerType>, List<GdsContractRelationData>> flightContractRelations, String group) {
        if (this.passengers.isEmpty()) {
            this.buildStructuresForPassengerTypes(flightContractRelations, group);
        } else {
            this.buildStructuresForPassengers(flightContractRelations, group);
        }
    }

    private void buildStructuresForPassengerTypes(Map<DictionaryReference<PassengerType>, List<GdsContractRelationData>> flightContractRelations, String group) {
        IbecorpPriceStructureHelper.calculatePriceStructure(flightContractRelations).forEach((pt, ps) -> {
            List ppsList = (List)CollectionUtil.getFromMap((Map)this.passengerPriceStructureMap, (Object)pt, ArrayList::new);
            GeneralPriceComponents.PassengerPriceStructure pps = new GeneralPriceComponents.PassengerPriceStructure((XtripPriceStructure)ps, BigDecimal.ZERO);
            pps.setPassengerCount((Integer)this.passengersMap.get(pt));
            pps.setGroup(group);
            ppsList.add(pps);
        });
    }

    private void buildStructuresForPassengers(Map<DictionaryReference<PassengerType>, List<GdsContractRelationData>> flightContractRelations, String group) {
        Map xpsMap = IbecorpPriceStructureHelper.calculatePriceStructure(flightContractRelations);
        Map ancillaryFeesByGdsId = this.flight.getAncillaryFees().stream().filter(af -> TextUtil.nonBlank((String)af.getGdsId())).collect(Collectors.toMap(BaseAncillaryFee::getGdsId, Function.identity()));
        for (Passenger passenger : this.passengers) {
            DictionaryReference passengerType = passenger.getType();
            XtripPriceStructure passengerPs = (XtripPriceStructure)xpsMap.get(passengerType);
            GeneralPriceComponents.PassengerPriceStructure pps = new GeneralPriceComponents.PassengerPriceStructure(passengerPs, BigDecimal.ZERO);
            pps.setPassengerCount(1);
            pps.setGroup(group);
            Map<RestAncillaryFeeType, List<RestAncillaryFee>> ancillaryFeeByTypes = passenger.getAncillaryFees().stream().filter(RestAncillaryFee::isSelected).filter(af -> af.getQuantity() > 0).collect(Collectors.groupingBy(RestBaseAncillaryFee::getType));
            for (RestAncillaryFeeType restAncillaryFeeType : ancillaryFeeByTypes.keySet()) {
                List<RestAncillaryFee> restAncillaryFees = ancillaryFeeByTypes.get(restAncillaryFeeType);
                XtripPriceStructure afPriceStructure = new XtripPriceStructure();
                int number = 0;
                for (RestAncillaryFee restAncillaryFee : restAncillaryFees) {
                    AncillaryFee ancillaryFee = (AncillaryFee)ancillaryFeesByGdsId.get(restAncillaryFee.getGdsId());
                    XtripPriceStructure ps = IbecorpPriceStructureHelper.calculatePriceStructure((BaseAncillaryFee)ancillaryFee);
                    ps.multiple(BigDecimal.valueOf(number += restAncillaryFee.getQuantity()));
                    afPriceStructure.add(ps);
                }
                pps.addAncillaryFee(new GeneralPriceComponents.PassengerAncillaryFeeStructure(afPriceStructure, number, restAncillaryFeeType.toString()));
            }
            if (!passenger.getSeats().isEmpty()) {
                XtripPriceStructure afPriceStructure = new XtripPriceStructure();
                int number = 0;
                for (RestSeat restSeat : passenger.getSeats()) {
                    ++number;
                    RestAircraftSeatToken seatToken = B2BRestHelper.decodeToken(RestAircraftSeatToken.class, restSeat.getToken());
                    XtripPriceStructure ps = IbecorpPriceStructureHelper.calculatePriceStructure((List)seatToken.getContractRelations());
                    afPriceStructure.add(ps);
                }
                pps.addAncillaryFee(new GeneralPriceComponents.PassengerAncillaryFeeStructure(afPriceStructure, number, RestAncillaryFeeType.SEAT_RESERVATION.toString()));
            }
            List structures = (List)CollectionUtil.getFromMap((Map)this.passengerPriceStructureMap, (Object)passengerType, ArrayList::new);
            structures.add(pps);
            List passengerStructures = (List)CollectionUtil.getFromMap(this.passenger2ppsMap, (Object)passenger, ArrayList::new);
            passengerStructures.add(pps);
        }
    }

    private String getRouteLine(FlightMultiTicketItem flightMultiTicketItem) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        String prevCityCode = null;
        for (FlightSegmentTariff st : flightMultiTicketItem.getSegmentTariffs()) {
            for (FlightSegment seg : st.getSegments()) {
                String curCityCode;
                GeoLocation departureLocation = (GeoLocation)DictionaryCache.get().resolveReference(seg.getLocationBegin());
                GeoLocation arriveLocation = (GeoLocation)DictionaryCache.get().resolveReference(seg.getLocationEnd());
                GeoLocation departureCity = DictHelper.findCity((GeoLocation)departureLocation);
                GeoLocation arriveCity = DictHelper.findCity((GeoLocation)arriveLocation);
                if (departureCity != null) {
                    departureLocation = departureCity;
                }
                if (arriveCity != null) {
                    arriveLocation = arriveCity;
                }
                if (first) {
                    curCityCode = DictHelper.getCode((BaseDictionary)arriveLocation);
                    result.append(this.getCityCode(departureLocation));
                    result.append("-");
                    result.append(this.getCityCode(arriveLocation));
                    prevCityCode = curCityCode;
                    first = false;
                    continue;
                }
                curCityCode = DictHelper.getCode((BaseDictionary)departureLocation);
                if (!TextUtil.isSame(prevCityCode, (String)curCityCode)) {
                    result.append("//");
                    result.append(this.getCityCode(departureLocation));
                }
                result.append("-");
                prevCityCode = DictHelper.getCode((BaseDictionary)arriveLocation);
                result.append(this.getCityCode(arriveLocation));
            }
        }
        return result.toString();
    }

    private String getCityCode(GeoLocation geoLocation) {
        return DictHelper.getCityName((GeoLocation)geoLocation, null, null, (boolean)true, (CodeSystem)CodeSystem.IATA);
    }

    private void fillAncillaryFeesPriceStructure(Flight flight) {
        for (AncillaryFee ancillaryFee : flight.getAncillaryFees()) {
            if (!ancillaryFee.isSelected()) continue;
            XtripPriceStructure ancFeePriceStructure = IbecorpPriceStructureHelper.calculatePriceStructure((BaseAncillaryFee)ancillaryFee);
            DictionaryReference passengerType = ancillaryFee.getPassengerType();
            Integer passengerCount = (Integer)this.passengersMap.get(passengerType);
            if (passengerCount == null) {
                throw Xeption.forDeveloper((String)"no passenger type {0} in the passengers {1}", (Object[])new Object[]{passengerType, this.passengersMap.keySet()});
            }
            BigDecimal passengerTypeAncFee = this.separatedAncillaryFeesMap.getOrDefault(passengerType, BigDecimal.ZERO);
            this.separatedAncillaryFeesMap.put((DictionaryReference<PassengerType>)passengerType, MiscUtil.sum((BigDecimal[])new BigDecimal[]{passengerTypeAncFee, ancFeePriceStructure.getTotal()}));
            ancFeePriceStructure.multiple(BigDecimal.valueOf(passengerCount.intValue()));
            this.separatedAncillaryFeesPriceStructure.add(ancFeePriceStructure);
        }
    }

    private BigDecimal calculateSubagentTotalPrice(Flight flight) {
        Map subagentContractRelations = FlightHelper.getContractRelations((Flight)flight, (ContractType)ContractType.SUBAGENCY);
        BigDecimal total = BigDecimal.ZERO;
        for (DictionaryReference passengerType : subagentContractRelations.keySet()) {
            BigDecimal count = BigDecimal.valueOf(Optional.ofNullable(this.passengersMap.get(passengerType)).orElse(0).intValue());
            GdsContractRelationData contractRelationData = (GdsContractRelationData)subagentContractRelations.get(passengerType);
            ContractRelationServiceData serviceData = contractRelationData.getServiceData();
            total = total.add(serviceData.getDetalization().getFare().multiply(count));
            total = total.add(serviceData.getDetalization().getTaxes().stream().map(SimpleTax::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add).multiply(count));
            total = total.add(GeneralProductHelper.filterCommissions((Collection)contractRelationData.getCommissions(), (Set)GeneralProductHelper.feePropertyTypes, null, null).stream().map(BaseCommission::getEquivalentAmount).reduce(BigDecimal.ZERO, BigDecimal::add).multiply(count));
        }
        return total;
    }

    @Override
    public Price createPrice() {
        Price result = super.createPrice();
        result.setAncillaryFees(this.buildSeparatedAncillaryFeesPrice());
        return result;
    }

    private AncillaryFeesPrice buildSeparatedAncillaryFeesPrice() {
        AncillaryFeesPrice result = new AncillaryFeesPrice();
        result.setPrice(CommonConverterHelper.convertMoney2Rest(this.separatedAncillaryFeesPriceStructure.getProductPrice(), this.currency));
        result.setSupplierFees(CommonConverterHelper.convertMoney2Rest(this.separatedAncillaryFeesPriceStructure.getSupplierFees(), this.currency));
        result.setAgencyFees(CommonConverterHelper.convertMoney2Rest(this.separatedAncillaryFeesPriceStructure.getAgencyFees(), this.currency));
        return result;
    }

    @Override
    protected void buildPassengerPrices(Price result) {
        if (this.passengers.isEmpty()) {
            super.buildPassengerPrices(result);
            return;
        }
        this.passengers.forEach(passenger -> this.passenger2ppsMap.get(passenger).forEach(pps -> result.getPassengerPrices().add(this.buildPassengerPrice((GeneralPriceComponents.PassengerPriceStructure)pps, (DictionaryReference<PassengerType>)passenger.getType()))));
    }

    private void setCurrencies(Flight flight) {
        this.subagentCurrency = FlightHelper.getCurrency((Flight)flight, (ContractType)ContractType.SUBAGENCY);
        this.currency = FlightHelper.getCurrency((Flight)flight, (ContractType)ContractType.CLIENT);
    }

    public static class Builder {
        private final Flight flight;
        private final PriceComponentsParameters componentsParameters;
        private final List<Passenger> passengers = new ArrayList<Passenger>();

        private Builder(Flight flight, PriceComponentsParameters componentsParameters) {
            this.flight = flight;
            this.componentsParameters = componentsParameters;
        }

        public Builder addPassengers(List<Passenger> passengers) {
            this.passengers.addAll(passengers);
            return this;
        }

        public AviaPriceComponents build() {
            AviaPriceComponents result = new AviaPriceComponents(this.flight, this.componentsParameters);
            result.passengers.addAll(this.passengers);
            result.buildPriceStructures();
            return result;
        }
    }
}

