/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.components;

import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.rest.BaseRestEntity;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.server.ibecorp.common.components.AviaPriceComponents;
import com.gridnine.xtrip.server.ibecorp.common.components.BasePriceComponentsTest;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.Price;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.Passenger;
import com.gridnine.xtrip.server.model.test.RestModelAssert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Test;

public class AviaPriceComponentsTest
extends BasePriceComponentsTest {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        GeoLocation dict = new GeoLocation();
        dict.setCode("airport SVO");
        dict.setType(LocationType.AIRPORT);
        dict.setParent((DictionaryReference)new GeoLocationReference("SVO"));
        DictionaryCache.get().put((BaseDictionary)dict);
    }

    @Test
    public void basicTest() throws Exception {
        this.testScenario("avia_basic");
    }

    @Test
    public void multiTicketTest() throws Exception {
        this.testScenario("avia_multiTicket");
    }

    @Test
    public void multiTicketWithPassengersTest() throws Exception {
        ArrayList<Passenger> passengers = new ArrayList<Passenger>();
        Arrays.asList(DictHelper.getAdultPassengerType(), DictHelper.getAdultPassengerType(), DictHelper.getChildPassengerType()).forEach(pt -> {
            Passenger passenger = new Passenger();
            passenger.setType(pt);
            passengers.add(passenger);
        });
        this.testScenario("avia_multiTicketWithPassengers", passengers);
    }

    private void testScenario(String scenario) throws Exception {
        this.testScenario(scenario, Collections.emptyList());
    }

    private void testScenario(String scenario, List<Passenger> passengers) throws Exception {
        String flightFile = "resources/" + scenario + "_flight.xml";
        String resultFile = "resources/" + scenario + "_result.json";
        Flight flight = new Flight();
        this.loadXSerializable(flightFile, (XSerializable)flight);
        Price actual = AviaPriceComponents.builder(flight, PriceComponentsParameters.getTestComponentsParameters(this.headSalesContext)).addPassengers(passengers).build().createPrice();
        Price expected = this.unmarshalJson(resultFile, Price.class);
        RestModelAssert.assertEntityEquals((BaseRestEntity)expected, (BaseRestEntity)actual);
    }
}

