/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.components;

import com.gridnine.xtrip.common.ibecorp.IbeCorpStandardRegistryConfigurator;
import com.gridnine.xtrip.common.ibecorp.rules.PriceDetailActions;
import com.gridnine.xtrip.common.ibecorp.rules.Targets;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.meta.rest.RestMetaRegistry;
import com.gridnine.xtrip.common.midoffice.helper.StandardSalesContextHandler;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.ibecorp.PriceDetailDisplay;
import com.gridnine.xtrip.common.rest.BaseRestEntity;
import com.gridnine.xtrip.common.rest.TypeHandler;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonTypeHandler;
import com.gridnine.xtrip.server.ibecorp.test.IbeCorpTestBase;
import com.gridnine.xtrip.server.web.rest.JsonMarshaller;
import java.io.File;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.junit.Before;

public abstract class BasePriceComponentsTest
extends IbeCorpTestBase {
    private static final JsonMarshaller jsonMarshaller = new JsonMarshaller();

    public void setUp() throws Exception {
        super.setUp();
        LocaleManager.get().setCurrentLocale(LocaleHelper.RU_LOCALE);
    }

    @Before
    public void prepareEnvironment() throws Exception {
        RestMetaRegistry.get().register(Objects.requireNonNull(((Object)((Object)this)).getClass().getClassLoader().getResource("com/gridnine/xtrip/server/ibecorp/common/rest/rest-model-ibecorp-common.xml")));
        RestMetaRegistry.get().register(Objects.requireNonNull(((Object)((Object)this)).getClass().getClassLoader().getResource("com/gridnine/xtrip/server/ibecorp/common/rest/booking/rest-model-ibecorp-common-booking.xml")));
    }

    protected void configureMetaregistry(MetaRegistry metaRegistry) throws Exception {
        super.configureMetaregistry(metaRegistry);
        this.registerModel(metaRegistry, "com/gridnine/xtrip/common/railway/model/model-basic-railway.xml");
        this.registerModel(metaRegistry, "com/gridnine/xtrip/common/railway/model/model-railway.xml");
        this.registerModel(metaRegistry, "com/gridnine/xtrip/common/ibecorp/model-railway-ibecorp.xml");
    }

    protected void configureHandlersRegistry(HandlersRegistry handlersRegistry) {
        super.configureHandlersRegistry(handlersRegistry);
        new IbeCorpStandardRegistryConfigurator().configure(handlersRegistry);
    }

    protected String marshalJson(BaseRestEntity actual) {
        return jsonMarshaller.marshal((Object)actual);
    }

    protected <T extends BaseRestEntity> T unmarshalJson(String fileName, Class<T> cls) throws Exception {
        return (T)((BaseRestEntity)jsonMarshaller.unmarshal(IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(fileName), (Charset)Charset.forName("UTF-8")), cls));
    }

    protected void writeResult(String text, String fileName) throws Exception {
        String path = ((Object)((Object)this)).getClass().getResource("").getPath().replace("/classes/", "/source-test/");
        path = URLDecoder.decode(path, "utf-8");
        File file = new File(path + fileName);
        FileUtils.writeStringToFile((File)file, (String)text);
    }

    static {
        jsonMarshaller.addTypeHandler((TypeHandler)new CommonTypeHandler());
    }

    protected static class TestSalesContextHandler
    extends StandardSalesContextHandler {
        private final PriceDetailDisplay priceDetailDisplay;
        private final boolean showHotelDailyDetails;

        public TestSalesContextHandler(PriceDetailDisplay priceDetailDisplay, boolean showHotelDailyDetails) {
            this.priceDetailDisplay = priceDetailDisplay;
            this.showHotelDailyDetails = showHotelDailyDetails;
        }

        public RuleSet getRules(SalesContext salesContext) {
            RuleSet ruleSet = new RuleSet();
            RuleSettings rs = new RuleSettings();
            rs.setTarget((RuleTarget)Targets.PRICE_DETAIL_DISPLAY);
            RuleResult rr = new RuleResult();
            rr.setAction((RuleAction)PriceDetailActions.PRICE_DETAIL_DISPLAY);
            rr.setValue((Object)this.priceDetailDisplay);
            rs.getResults().add(rr);
            rr = new RuleResult();
            rr.setAction((RuleAction)PriceDetailActions.PRICE_DETAIL_SHOW_HOTEL_DAILY_DETAILS);
            rr.setValue((Object)this.showHotelDailyDetails);
            rs.getResults().add(rr);
            ruleSet.getRules().add(rs);
            return ruleSet;
        }
    }
}

