/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.components;

import com.gridnine.xtrip.common.ibecorp.CurrencyHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.MulticurrencyHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMCurrencyDisplaySettings;
import com.gridnine.xtrip.common.model.profile.ExchangeRateData;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.components.Rate;
import com.gridnine.xtrip.server.ibecorp.common.components.ReservationPriceComponents;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ComponentsHelper {
    public static BigDecimal getTotalBookingPrice(EntityContainer<BookingFile> bookingFileContainer, PriceComponentsParameters parameters) throws Exception {
        TravelSubject travelSubject = ((BookingFile)bookingFileContainer.getEntity()).getReservations().stream().flatMap(res -> res.getProducts().stream()).map(baseProd -> HandlersRegistry.get().findProductHandler(baseProd.getClass()).findTravelSubject(baseProd)).filter(Objects::nonNull).findFirst().orElse(null);
        if (travelSubject == null) {
            throw Xeption.forDeveloper((String)String.format("Travel subject for booking file %s not found", ((BookingFile)bookingFileContainer.getEntity()).getNumber()), (Object[])new Object[0]);
        }
        switch (travelSubject) {
            case AIR: {
                return ReservationPriceComponents.builder((Reservation)XCloneHelper.clone((XCloneable)AirProductHelper.getAviaReservation(bookingFileContainer)), parameters).build().getTotal();
            }
            case RAILWAY: 
            case HOTEL_RESERVATION: 
            case TRANSFER: {
                BigDecimal total = BigDecimal.ZERO;
                for (Reservation reservation : ((BookingFile)bookingFileContainer.getEntity()).getReservations()) {
                    total = total.add(ReservationPriceComponents.builder((Reservation)XCloneHelper.clone((XCloneable)reservation), parameters).build().getTotal());
                }
                return total;
            }
        }
        throw Xeption.forDeveloper((String)String.format("Booking file %s contains unsupported travel subject %s", ((BookingFile)bookingFileContainer.getEntity()).getNumber(), travelSubject), (Object[])new Object[0]);
    }

    public static BigDecimal getTotalBookingPrice(Collection<Reservation> reservations, PriceComponentsParameters parameters) {
        return reservations.stream().map(r -> ReservationPriceComponents.builder(r, parameters).build().getTotal()).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public static List<Rate> getCurrencyRates(String currency, BigDecimal total, List<SMCurrencyDisplaySettings> displayCurrencies) {
        return displayCurrencies.stream().map(settings -> ComponentsHelper.getCurrencyRate(currency, total, settings)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static Rate getCurrencyRate(String currency, BigDecimal total, SMCurrencyDisplaySettings settings) {
        if (settings.getCurrency() == null) {
            return null;
        }
        BigDecimal convertedTotal = CurrencyHelper.exchange((BigDecimal)total, (String)currency, (String)DictHelper.getCode((DictionaryReference)settings.getCurrency()), (SMCurrencyDisplaySettings)settings);
        if (convertedTotal == null) {
            return null;
        }
        Rate rate = new Rate();
        rate.setRate(convertedTotal);
        rate.setCurrency((DictionaryReference<CurrencyInfo>)settings.getCurrency());
        return rate;
    }

    static BigDecimal calcClientAmount(BigDecimal amount, List<GeneralProductContractRelationData> contractRelations) {
        if (MiscUtil.isZero((BigDecimal)amount, (boolean)true)) {
            return amount;
        }
        BigDecimal result = amount;
        for (GeneralProductContractRelationData relation : contractRelations) {
            ExchangeRateData exchangeRateData = relation.getGeneralData().getRate();
            if (exchangeRateData == null) continue;
            result = MulticurrencyHelper.convert((BigDecimal)result, (ExchangeRateData)exchangeRateData);
        }
        return result;
    }
}

