/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.components;

import com.gridnine.xtrip.common.ibecorp.CurrencyHelper;
import com.gridnine.xtrip.common.ibecorp.rules.PriceDetailActionsSet;
import com.gridnine.xtrip.common.model.booking.AdditionalService;
import com.gridnine.xtrip.common.model.booking.BaseContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.XtripPriceStructure;
import com.gridnine.xtrip.common.model.ibecorp.PriceDetailDisplay;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.components.Rate;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.AncillaryFeesPriceItem;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.DailyPriceItem;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.FeeDetailsPrice;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.Money;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.PassengerPrice;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.Price;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.collections.CollectionUtils;

public abstract class GeneralPriceComponents {
    protected String currency;
    protected String subagentCurrency;
    protected final Map<DictionaryReference<PassengerType>, Integer> passengersMap = new HashMap<DictionaryReference<PassengerType>, Integer>();
    protected final Map<DictionaryReference<PassengerType>, List<PassengerPriceStructure>> passengerPriceStructureMap = new HashMap<DictionaryReference<PassengerType>, List<PassengerPriceStructure>>();
    protected final Map<PassengerPriceStructure, List<MiscUtil.Pair<LocalDate, BigDecimal>>> passengerDailyDetails = new HashMap<PassengerPriceStructure, List<MiscUtil.Pair<LocalDate, BigDecimal>>>();
    protected final PriceComponentsParameters parameters;
    private final PriceDetailDisplay priceDetailDisplay;
    protected final boolean showHotelDailyDetails;
    protected BigDecimal totalSubagent;
    protected List<Rate> rates;
    protected boolean taxSupported = false;

    protected GeneralPriceComponents(PriceComponentsParameters componentsParameters, PriceDetailActionsSet priceDetailActionsSet) {
        this.priceDetailDisplay = priceDetailActionsSet.getPriceDetailDisplay();
        this.showHotelDailyDetails = priceDetailActionsSet.isShowHotelDailyDetails();
        this.parameters = componentsParameters;
    }

    protected void negate() {
        this.totalSubagent = MiscUtil.guarded((BigDecimal)this.totalSubagent).negate();
        this.passengerPriceStructureMap.values().stream().flatMap(Collection::stream).forEach(rec$ -> ((PassengerPriceStructure)rec$).negate());
    }

    protected XtripPriceStructure buildPriceStructure(AdditionalService additionalService) {
        XtripPriceStructure result = new XtripPriceStructure();
        result.setProductPrice(additionalService.getAmount());
        result.getPriceDetalization().setFare(additionalService.getAmount());
        return result;
    }

    protected BigDecimal getValue(BigDecimal value, boolean negate) {
        return negate ? value.negate() : value;
    }

    public String getCurrency() {
        return this.currency;
    }

    public Map<DictionaryReference<PassengerType>, Integer> getPassengers() {
        return this.passengersMap;
    }

    protected int getPassengersCount(DictionaryReference<PassengerType> passengerType) {
        Integer count = this.passengersMap.get(passengerType);
        return Optional.ofNullable(count).orElse(0);
    }

    private BigDecimal calcSinglePassengerPriceValue(Function<PassengerPriceStructure, BigDecimal> getValue, DictionaryReference<PassengerType> passengerType) {
        BigDecimal total = this.passengerPriceStructureMap.get(passengerType).stream().map(getValue).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal passengerCount = BigDecimal.valueOf(this.getPassengersCount(passengerType));
        return total.divide(passengerCount, RoundingMode.HALF_DOWN);
    }

    protected BigDecimal calcPassengerPriceValue(Function<PassengerPriceStructure, BigDecimal> getValue) {
        BigDecimal result = this.passengerPriceStructureMap.values().stream().flatMap(Collection::stream).map(getValue).reduce(BigDecimal.ZERO, BigDecimal::add);
        return CommonHelper.round(result);
    }

    public BigDecimal getTariff() {
        return this.calcPassengerPriceValue(PassengerPriceStructure::getTotalTariff);
    }

    public BigDecimal getTariff(DictionaryReference<PassengerType> passengerType) {
        return this.calcSinglePassengerPriceValue(PassengerPriceStructure::getTotalTariff, passengerType);
    }

    public BigDecimal getTaxes() {
        return this.calcPassengerPriceValue(PassengerPriceStructure::getTotalTaxes);
    }

    public BigDecimal getTaxes(DictionaryReference<PassengerType> passengerType) {
        return this.calcSinglePassengerPriceValue(PassengerPriceStructure::getTotalTaxes, passengerType);
    }

    public BigDecimal getPenalty() {
        return this.calcPassengerPriceValue(PassengerPriceStructure::getTotalPenalty);
    }

    public BigDecimal getPenalty(DictionaryReference<PassengerType> passengerType) {
        return this.calcSinglePassengerPriceValue(PassengerPriceStructure::getTotalPenalty, passengerType);
    }

    public BigDecimal getFee() {
        return this.calcPassengerPriceValue(PassengerPriceStructure::getTotalFees);
    }

    public BigDecimal getFee(DictionaryReference<PassengerType> passengerType) {
        return this.calcSinglePassengerPriceValue(PassengerPriceStructure::getTotalFees, passengerType);
    }

    public BigDecimal getDiscount() {
        return this.calcPassengerPriceValue(PassengerPriceStructure::getTotalDiscount);
    }

    public BigDecimal getDiscount(DictionaryReference<PassengerType> passengerType) {
        return this.calcSinglePassengerPriceValue(PassengerPriceStructure::getTotalDiscount, passengerType);
    }

    private BigDecimal getAncillaryFeesTotal(DictionaryReference<PassengerType> passengerType) {
        return this.calcSinglePassengerPriceValue(PassengerPriceStructure::getTotalAncillaryFeesTotal, passengerType);
    }

    private BigDecimal getAncillaryFeesFare() {
        return this.calcPassengerPriceValue(PassengerPriceStructure::getTotalAncillaryFeesFare);
    }

    private BigDecimal getAncillaryFeesAllFees() {
        return this.calcPassengerPriceValue(PassengerPriceStructure::getTotalAncillaryFeesAllFees);
    }

    public BigDecimal getSinglePassengerTotal(DictionaryReference<PassengerType> passengerType) {
        return MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.getTariff(passengerType), this.getFee(passengerType), this.getTaxes(passengerType), this.getPenalty(passengerType), this.getDiscount(passengerType), this.getAncillaryFeesTotal(passengerType)});
    }

    public BigDecimal getTotal(DictionaryReference<PassengerType> passengerType) {
        return this.getSinglePassengerTotal(passengerType).multiply(BigDecimal.valueOf(this.getPassengersCount(passengerType)));
    }

    public BigDecimal getTotal() {
        return this.calcPassengerPriceValue(PassengerPriceStructure::getTotal);
    }

    public PriceComponentsParameters getParameters() {
        return this.parameters;
    }

    public PriceDetailDisplay getPriceDetailDisplay() {
        return this.priceDetailDisplay;
    }

    public List<Rate> getRates() {
        return this.rates;
    }

    public BigDecimal getTotalSubagent() {
        return this.totalSubagent;
    }

    public String getSubagentCurrency() {
        return this.subagentCurrency;
    }

    public List<PassengerPriceStructure> getPassengerPriceStructures(DictionaryReference<PassengerType> passengerType) {
        return (List)MiscUtil.guarded(this.passengerPriceStructureMap.get(passengerType), Collections.emptyList());
    }

    private static Comparator<PassengerPrice> passengerPriceComparator() {
        return (pp1, pp2) -> {
            int groupDiff = MiscUtil.compare((Comparable)((Object)pp1.getGroup()), (Comparable)((Object)pp2.getGroup()));
            if (groupDiff != 0) {
                return groupDiff;
            }
            int passengerTypeDiff = CommonHelper.sortByPassengerType((DictionaryReference<PassengerType>)pp1.getPassengerType(), (DictionaryReference<PassengerType>)pp2.getPassengerType());
            if (passengerTypeDiff != 0) {
                return passengerTypeDiff;
            }
            return pp2.getTariff().getAmount().compareTo(pp1.getTariff().getAmount());
        };
    }

    public Price createPrice() {
        Price result = new Price();
        result.setTotal(CommonConverterHelper.convertMoney2Rest(this.getTotal(), this.currency));
        result.setTotalPenalty(CommonConverterHelper.convertMoney2Rest(this.getPenalty(), this.currency));
        BigDecimal totalAncFeesFare = this.getAncillaryFeesFare();
        BigDecimal totalAncFeesAllFees = this.getAncillaryFeesAllFees();
        BigDecimal totalFare = MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.getTariff(), totalAncFeesFare});
        BigDecimal totalTaxes = this.getTaxes();
        BigDecimal discount = this.getDiscount();
        BigDecimal totalFees = MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.getFee(), totalAncFeesAllFees});
        BigDecimal feeAndTaxes = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalFees, totalTaxes});
        switch (this.priceDetailDisplay) {
            case DETAILED: {
                result.setTotalFare(CommonConverterHelper.convertMoney2Rest(totalFare, this.currency));
                result.setTotalTaxes(CommonConverterHelper.convertMoney2Rest(totalTaxes, this.currency));
                result.setTotalFee(CommonConverterHelper.convertMoney2Rest(totalFees, this.currency));
                result.setTotalDiscount(CommonConverterHelper.convertMoney2Rest(discount, this.currency));
                break;
            }
            case DETAILED_WITH_FEES_IN_TAXES: {
                result.setTotalFare(CommonConverterHelper.convertMoney2Rest(totalFare, this.currency));
                Money feeAndTaxesMoney = CommonConverterHelper.convertMoney2Rest(feeAndTaxes, this.currency);
                if (this.taxSupported) {
                    result.setTotalFeeAndTaxes(feeAndTaxesMoney);
                } else {
                    result.setTotalFee(feeAndTaxesMoney);
                }
                result.setTotalDiscount(CommonConverterHelper.convertMoney2Rest(discount, this.currency));
                break;
            }
            case TOTAL_ONLY: {
                result.setTotalFare(CommonConverterHelper.convertMoney2Rest(MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalFare, feeAndTaxes, discount}), this.currency));
            }
        }
        if (CollectionUtil.isNotEmpty(this.parameters.getDisplayCurrencies())) {
            result.getRates().addAll(CommonConverterHelper.convertRatesToRest(this.getRates()));
        }
        if (this.parameters.isCalculateSubagentPrice()) {
            result.setTotalSubagent(CommonConverterHelper.convertMoney2Rest(this.getTotalSubagent(), this.subagentCurrency));
        }
        this.buildPassengerPrices(result);
        return result;
    }

    protected void buildPassengerPrices(Price result) {
        this.passengerPriceStructureMap.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(pps -> this.buildPassengerPrice((PassengerPriceStructure)pps, (DictionaryReference<PassengerType>)((DictionaryReference)entry.getKey())))).sorted(GeneralPriceComponents.passengerPriceComparator()).forEach(result.getPassengerPrices()::add);
    }

    protected PassengerPrice buildPassengerPrice(PassengerPriceStructure structure, DictionaryReference<PassengerType> passengerType) {
        boolean showDailyDetails;
        PassengerPrice pp = new PassengerPrice();
        pp.setPassengerType(passengerType);
        pp.setGroup(structure.getGroup());
        pp.setPassengerCount(structure.getPassengerCount().intValue());
        pp.setSinglePassengerTotal(CommonConverterHelper.convertMoney2Rest(structure.getSinglePassengerTotal(), this.currency));
        pp.setTotal(CommonConverterHelper.convertMoney2Rest(structure.getTotal(), this.currency));
        pp.setPenalty(CommonConverterHelper.convertMoney2Rest(structure.getPenalty(), this.currency));
        BigDecimal fare = structure.getTariff();
        BigDecimal fees = structure.getFees();
        BigDecimal discount = structure.getDiscount();
        BigDecimal ancillaryFeesAllFees = structure.getAncillaryFeesAllFees();
        BigDecimal feeAndTaxes = MiscUtil.sum((BigDecimal[])new BigDecimal[]{fees, structure.getTaxes()});
        switch (this.priceDetailDisplay) {
            case DETAILED: {
                pp.setTariff(CommonConverterHelper.convertMoney2Rest(fare, this.currency));
                pp.setTaxes(CommonConverterHelper.convertMoney2Rest(structure.getTaxes(), this.currency));
                pp.setDiscount(CommonConverterHelper.convertMoney2Rest(discount, this.currency));
                XtripPriceStructure priceStructure = structure.getPriceStructure();
                FeeDetailsPrice fd = new FeeDetailsPrice();
                fd.setAgencyFees(CommonConverterHelper.convertMoney2Rest(MiscUtil.sum((BigDecimal[])new BigDecimal[]{priceStructure.getAgencyFees(), structure.getAncillaryFeesAgencyFees()}), this.currency));
                fd.setTechFees(CommonConverterHelper.convertMoney2Rest(MiscUtil.sum((BigDecimal[])new BigDecimal[]{priceStructure.getTechFees(), structure.getAncillaryFeesTechFees()}), this.currency));
                fd.setSupplierFees(CommonConverterHelper.convertMoney2Rest(MiscUtil.sum((BigDecimal[])new BigDecimal[]{priceStructure.getSupplierFees(), structure.getAncillaryFeesSupplierFees()}), this.currency));
                pp.setFeeDetails(fd);
                break;
            }
            case DETAILED_WITH_FEES_IN_TAXES: {
                pp.setTariff(CommonConverterHelper.convertMoney2Rest(fare, this.currency));
                Money feeAndTaxesMoney = CommonConverterHelper.convertMoney2Rest(MiscUtil.sum((BigDecimal[])new BigDecimal[]{feeAndTaxes, ancillaryFeesAllFees}), this.currency);
                if (this.taxSupported) {
                    pp.setFeeAndTaxes(feeAndTaxesMoney);
                } else {
                    pp.setFee(feeAndTaxesMoney);
                }
                pp.setDiscount(CommonConverterHelper.convertMoney2Rest(discount, this.currency));
                break;
            }
            case TOTAL_ONLY: {
                pp.setTariff(CommonConverterHelper.convertMoney2Rest(MiscUtil.sum((BigDecimal[])new BigDecimal[]{fare, feeAndTaxes, discount}), this.currency));
            }
        }
        List<MiscUtil.Pair<LocalDate, BigDecimal>> dailyDetails = this.passengerDailyDetails.get(structure);
        boolean bl = showDailyDetails = this.showHotelDailyDetails && CollectionUtils.isNotEmpty(dailyDetails);
        if (showDailyDetails) {
            BigDecimal totalDailyFare;
            BigDecimal restFare = pp.getTariff().getAmount();
            if (!MiscUtil.equals((Object)restFare, (Object)(totalDailyFare = dailyDetails.stream().map(MiscUtil.Pair::getSecond).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add)))) {
                BigDecimal dailyAddition = MiscUtil.sub((BigDecimal)restFare, (BigDecimal[])new BigDecimal[]{totalDailyFare}).divide(BigDecimal.valueOf(dailyDetails.size()), RoundingMode.HALF_DOWN);
                dailyDetails.forEach(pair -> pair.setSecond((Object)MiscUtil.sum((BigDecimal[])new BigDecimal[]{(BigDecimal)pair.getSecond(), dailyAddition})));
            }
            dailyDetails.stream().map(this::buildDailyPriceItem).forEach(pp.getDailyDetails()::add);
        }
        for (PassengerAncillaryFeeStructure afStructure : structure.getAncillaryFeesStructures()) {
            AncillaryFeesPriceItem afItem = new AncillaryFeesPriceItem();
            afItem.setCaption(afStructure.getCaption());
            afItem.setNumber(afStructure.getNumber());
            switch (this.priceDetailDisplay) {
                case DETAILED: 
                case DETAILED_WITH_FEES_IN_TAXES: {
                    afItem.setPrice(CommonConverterHelper.convertMoney2Rest(afStructure.getTotalFare(), this.currency));
                    break;
                }
                case TOTAL_ONLY: {
                    afItem.setPrice(CommonConverterHelper.convertMoney2Rest(afStructure.getTotal(), this.currency));
                }
            }
            pp.getAncillaryFees().add(afItem);
        }
        return pp;
    }

    private DailyPriceItem buildDailyPriceItem(MiscUtil.Pair<LocalDate, BigDecimal> dailyPair) {
        DailyPriceItem result = new DailyPriceItem();
        result.setDate((LocalDate)dailyPair.getFirst());
        result.setPrice(CommonConverterHelper.convertMoney2Rest((BigDecimal)dailyPair.getSecond(), this.currency));
        return result;
    }

    protected void addDailyDetails(List<MiscUtil.Pair<LocalDate, BigDecimal>> dailyDetails, Date startDate, Date endDate, BigDecimal itemAmount) {
        LocalDate localCheckInDate = Objects.requireNonNull(DateUtils.toLocalDate((Date)startDate));
        int nightsCount = (int)MiscUtil.getDaysBetween((Date)startDate, (Date)endDate);
        if (nightsCount == 0) {
            nightsCount = 1;
        }
        for (int i = 0; i < nightsCount; ++i) {
            dailyDetails.add((MiscUtil.Pair<LocalDate, BigDecimal>)MiscUtil.Pair.of((Object)localCheckInDate.plusDays(i), (Object)itemAmount));
        }
    }

    protected static String getCurrency(BaseContractRelationData contractRelationData) {
        return Optional.ofNullable(GeneralProductHelper.getCurrency((BaseContractRelationData)contractRelationData)).map(DictionaryReference::getCode).orElse(CurrencyHelper.getSystem());
    }

    protected static BigDecimal getTotalSubagent(GeneralProductContractRelationData subagencyCR) {
        return subagencyCR != null ? subagencyCR.getServiceData().getTotalPrice() : BigDecimal.ZERO;
    }

    public static class PassengerAncillaryFeeStructure {
        private final XtripPriceStructure totalPriceStructure;
        private final int number;
        private final String caption;

        public PassengerAncillaryFeeStructure(XtripPriceStructure totalPriceStructure, int number, String caption) {
            this.totalPriceStructure = totalPriceStructure;
            this.number = number;
            this.caption = caption;
        }

        private void negate() {
            this.totalPriceStructure.negate();
        }

        public int getNumber() {
            return this.number;
        }

        public String getCaption() {
            return this.caption;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof PassengerAncillaryFeeStructure)) {
                return false;
            }
            PassengerAncillaryFeeStructure pafs = (PassengerAncillaryFeeStructure)obj;
            return MiscUtil.equals((Object)this.number, (Object)pafs.number) && MiscUtil.equals((Object)this.caption, (Object)pafs.caption) && MiscUtil.equals((Object)this.totalPriceStructure.getProductPrice(), (Object)pafs.totalPriceStructure.getProductPrice()) && MiscUtil.equals((Object)this.totalPriceStructure.getTotalFees(), (Object)pafs.totalPriceStructure.getTotalFees()) && MiscUtil.equals((Object)this.totalPriceStructure.getDiscount(), (Object)pafs.totalPriceStructure.getDiscount());
        }

        public int hashCode() {
            return Objects.hash(this.number, this.caption, this.totalPriceStructure.getProductPrice(), this.totalPriceStructure.getTotalFees(), this.totalPriceStructure.getDiscount());
        }

        public BigDecimal getTotalFare() {
            return this.totalPriceStructure.getProductPrice();
        }

        public BigDecimal getTotal() {
            return this.totalPriceStructure.getTotal();
        }
    }

    public static class PassengerPriceStructure {
        private final XtripPriceStructure priceStructure;
        private String group;
        private BigDecimal tariff;
        private BigDecimal taxes;
        private BigDecimal fees;
        private BigDecimal discount;
        private BigDecimal penalty;
        private Integer passengerCount;
        private final List<PassengerAncillaryFeeStructure> ancillaryFees = new ArrayList<PassengerAncillaryFeeStructure>();

        protected PassengerPriceStructure(XtripPriceStructure priceStructure, BigDecimal penalty) {
            this.priceStructure = priceStructure;
            this.tariff = MiscUtil.guarded((BigDecimal)priceStructure.getPriceDetalization().getFare());
            this.taxes = MiscUtil.guarded((BigDecimal)priceStructure.getPriceDetalization().getTaxes());
            this.fees = MiscUtil.guarded((BigDecimal)MiscUtil.sum((BigDecimal[])new BigDecimal[]{priceStructure.getAgencyFees(), priceStructure.getSupplierFees(), priceStructure.getTechFees(), priceStructure.getPaymentFees()}));
            this.discount = MiscUtil.guarded((BigDecimal)priceStructure.getDiscount()).negate();
            this.penalty = MiscUtil.guarded((BigDecimal)penalty);
        }

        private void negate() {
            this.priceStructure.negate();
            this.tariff = this.tariff.negate();
            this.taxes = this.taxes.negate();
            this.fees = this.fees.negate();
            this.discount = this.discount.negate();
            this.penalty = this.penalty.negate();
            this.ancillaryFees.forEach(rec$ -> ((PassengerAncillaryFeeStructure)rec$).negate());
        }

        protected void addAncillaryFee(PassengerAncillaryFeeStructure ancillaryFee) {
            this.ancillaryFees.add(ancillaryFee);
        }

        protected void addAncillaryFees(Collection<PassengerAncillaryFeeStructure> ancillaryFees) {
            this.ancillaryFees.addAll(ancillaryFees);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof PassengerPriceStructure)) {
                return false;
            }
            PassengerPriceStructure pps = (PassengerPriceStructure)obj;
            return MiscUtil.equals((Object)this.group, (Object)pps.getGroup()) && MiscUtil.equals((Object)this.tariff, (Object)pps.getTariff()) && MiscUtil.equals((Object)this.taxes, (Object)pps.getTaxes()) && MiscUtil.equals((Object)this.fees, (Object)pps.getFees()) && MiscUtil.equals((Object)this.penalty, (Object)pps.getPenalty()) && MiscUtil.equals((Object)this.discount, (Object)pps.getDiscount()) && CollectionUtil.sameElements(this.ancillaryFees, pps.ancillaryFees);
        }

        public int hashCode() {
            return Objects.hash(this.group, this.tariff, this.taxes, this.fees, this.penalty, this.discount);
        }

        public XtripPriceStructure getPriceStructure() {
            return this.priceStructure;
        }

        public List<PassengerAncillaryFeeStructure> getAncillaryFeesStructures() {
            return this.ancillaryFees;
        }

        public Integer getPassengerCount() {
            return this.passengerCount;
        }

        protected void incPassengerCount() {
            this.passengerCount = MiscUtil.guarded((Integer)this.passengerCount) + 1;
        }

        protected void setPassengerCount(Integer passengerCount) {
            this.passengerCount = passengerCount;
        }

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public BigDecimal getTariff() {
            return CommonHelper.round(this.tariff);
        }

        public BigDecimal getTotalTariff() {
            return this.getTariff().multiply(BigDecimal.valueOf(this.passengerCount.intValue()));
        }

        public BigDecimal getTaxes() {
            return CommonHelper.round(this.taxes);
        }

        public BigDecimal getTotalTaxes() {
            return this.getTaxes().multiply(BigDecimal.valueOf(this.passengerCount.intValue()));
        }

        public BigDecimal getFees() {
            return CommonHelper.round(this.fees);
        }

        public BigDecimal getTotalFees() {
            return this.getFees().multiply(BigDecimal.valueOf(this.passengerCount.intValue()));
        }

        public BigDecimal getDiscount() {
            return CommonHelper.round(this.discount);
        }

        public BigDecimal getTotalDiscount() {
            return this.getDiscount().multiply(BigDecimal.valueOf(this.passengerCount.intValue()));
        }

        public BigDecimal getPenalty() {
            return this.penalty;
        }

        public BigDecimal getTotalPenalty() {
            return this.getPenalty().multiply(BigDecimal.valueOf(this.passengerCount.intValue()));
        }

        private BigDecimal calcAncillaryFeesValue(Function<PassengerAncillaryFeeStructure, BigDecimal> getAncillaryFeesValue) {
            return this.ancillaryFees.stream().map(getAncillaryFeesValue).reduce(BigDecimal.ZERO, BigDecimal::add);
        }

        public BigDecimal getAncillaryFeesTotal() {
            return this.calcAncillaryFeesValue(PassengerAncillaryFeeStructure::getTotal);
        }

        public BigDecimal getTotalAncillaryFeesTotal() {
            return this.getAncillaryFeesTotal().multiply(BigDecimal.valueOf(this.passengerCount.intValue()));
        }

        public BigDecimal getAncillaryFeesFare() {
            return this.calcAncillaryFeesValue(PassengerAncillaryFeeStructure::getTotalFare);
        }

        public BigDecimal getTotalAncillaryFeesFare() {
            return this.getAncillaryFeesFare().multiply(BigDecimal.valueOf(this.passengerCount.intValue()));
        }

        public BigDecimal getAncillaryFeesAllFees() {
            return this.calcAncillaryFeesValue(afs -> ((PassengerAncillaryFeeStructure)afs).totalPriceStructure.getTotalFees());
        }

        public BigDecimal getTotalAncillaryFeesAllFees() {
            return this.getAncillaryFeesAllFees().multiply(BigDecimal.valueOf(this.passengerCount.intValue()));
        }

        public BigDecimal getAncillaryFeesAgencyFees() {
            return this.calcAncillaryFeesValue(afs -> ((PassengerAncillaryFeeStructure)afs).totalPriceStructure.getAgencyFees());
        }

        public BigDecimal getAncillaryFeesTechFees() {
            return this.calcAncillaryFeesValue(afs -> ((PassengerAncillaryFeeStructure)afs).totalPriceStructure.getTechFees());
        }

        public BigDecimal getAncillaryFeesSupplierFees() {
            return this.calcAncillaryFeesValue(afs -> ((PassengerAncillaryFeeStructure)afs).totalPriceStructure.getSupplierFees());
        }

        public BigDecimal getSinglePassengerTotal() {
            return MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.getTariff(), this.getTaxes(), this.getFees(), this.getDiscount(), this.getPenalty(), this.getAncillaryFeesTotal()});
        }

        public BigDecimal getTotal() {
            return this.getSinglePassengerTotal().multiply(BigDecimal.valueOf(this.passengerCount.intValue()));
        }
    }
}

