/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.components;

import com.gridnine.xtrip.common.hotels2.model.HotelOffer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.AdditionalService;
import com.gridnine.xtrip.common.model.booking.BaseContractRelationData;
import com.gridnine.xtrip.common.model.booking.ContractRelationServiceDataDetalization;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.handlers.PreferenceHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.XtripPriceStructure;
import com.gridnine.xtrip.common.model.helpers.XtripPriceStructureHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsHelper;
import com.gridnine.xtrip.server.ibecorp.common.components.ComponentsHelper;
import com.gridnine.xtrip.server.ibecorp.common.components.GeneralPriceComponents;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.Price;
import com.gridnine.xtrip.server.ibecorp.ibus.rules.PriceDetailRuleHelper;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class HotelPriceComponents
extends GeneralPriceComponents {
    private static final DictionaryReference<PassengerType> EMPTY_PASSENGER_TYPE = null;
    private final HotelOffer offer;
    private Double vat;

    public static Builder builder(HotelOffer offer, PriceComponentsParameters componentsParameters) {
        return new Builder(offer, componentsParameters);
    }

    private HotelPriceComponents(HotelOffer offer, PriceComponentsParameters componentsParameters) {
        super(componentsParameters, PriceDetailRuleHelper.getPriceDetailDisplay(offer, componentsParameters.getSalesContext()));
        this.offer = offer;
        this.taxSupported = true;
    }

    private void buildPriceStructures() {
        GeneralProductContractRelationData contractRelationData = GeneralProductHelper.getContractRelation((List)this.offer.getContractRelations(), (ContractType)ContractType.CLIENT);
        this.currency = HotelPriceComponents.getCurrency((BaseContractRelationData)contractRelationData);
        ContractRelationServiceDataDetalization detalization = contractRelationData.getServiceData().getDetalization();
        this.passengersMap.put(EMPTY_PASSENGER_TYPE, 1);
        XtripPriceStructure offerPS = XtripPriceStructureHelper.calculatePriceStructure((List)this.offer.getContractRelations(), (boolean)true, null);
        ArrayList<GeneralPriceComponents.PassengerAncillaryFeeStructure> passengerAncillaryFees = new ArrayList<GeneralPriceComponents.PassengerAncillaryFeeStructure>();
        if (detalization.getAdditionalServices() != null && CollectionUtil.isNotEmpty((Collection)detalization.getAdditionalServices().getAdditionalServices())) {
            for (AdditionalService detalizationAs : detalization.getAdditionalServices().getAdditionalServices()) {
                XtripPriceStructure asPS = this.buildPriceStructure(detalizationAs);
                com.gridnine.xtrip.common.model.booking.xtriphotels.AdditionalService additionalService = this.offer.getAdditionalServices().stream().filter(as -> MiscUtil.equals((Object)as.getUid(), (Object)detalizationAs.getSource())).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"can't find additional service with uid {0}", (Object[])new Object[]{detalizationAs.getSource()}));
                passengerAncillaryFees.add(new GeneralPriceComponents.PassengerAncillaryFeeStructure(asPS, 1, additionalService.getType().toString()));
                offerPS.getPriceDetalization().setFare(MiscUtil.sub((BigDecimal)offerPS.getPriceDetalization().getFare(), (BigDecimal[])new BigDecimal[]{detalizationAs.getAmount()}));
            }
        }
        GeneralPriceComponents.PassengerPriceStructure pps = new GeneralPriceComponents.PassengerPriceStructure(offerPS, BigDecimal.ZERO);
        pps.setPassengerCount((Integer)this.passengersMap.get(EMPTY_PASSENGER_TYPE));
        pps.addAncillaryFees(passengerAncillaryFees);
        this.passengerPriceStructureMap.put(EMPTY_PASSENGER_TYPE, Collections.singletonList(pps));
        if (this.showHotelDailyDetails && this.offer.getStayPolicy() != null && this.offer.getStayPolicy().getCheckInDate() != null) {
            LocalDate localCheckInDate = this.offer.getStayPolicy().getCheckInDate();
            ArrayList<MiscUtil.Pair<LocalDate, BigDecimal>> dailyDetails = new ArrayList<MiscUtil.Pair<LocalDate, BigDecimal>>();
            String gdsCurrency = (String)MiscUtil.guarded((Object)HotelsHelper.getCurrency((HotelOffer)this.offer), (Object)PreferenceHelper.getLocalCurrency());
            if (this.validBreakdowns(this.offer.getBreakdowns(), gdsCurrency)) {
                int ind = 0;
                for (Money money : this.offer.getBreakdowns()) {
                    BigDecimal clientAmount = ComponentsHelper.calcClientAmount(money.getValue(), this.offer.getContractRelations());
                    dailyDetails.add((MiscUtil.Pair<LocalDate, BigDecimal>)MiscUtil.Pair.of((Object)localCheckInDate.plusDays(ind), (Object)clientAmount));
                    ++ind;
                }
            } else if (this.offer.getStayPolicy().getCheckOutDate() != null) {
                Date checkInDate = DateUtils.toJavaDate((LocalDate)localCheckInDate);
                Date checkOutDate = DateUtils.toJavaDate((LocalDate)this.offer.getStayPolicy().getCheckOutDate());
                this.addDailyDetails(dailyDetails, checkInDate, checkOutDate, BigDecimal.ZERO);
            }
            this.passengerDailyDetails.put(pps, dailyDetails);
        }
        if (this.parameters.isCalculateSubagentPrice()) {
            GeneralProductContractRelationData subagencyCR = (GeneralProductContractRelationData)GeneralProductHelper.findContractRelation((List)this.offer.getContractRelations(), (ContractType)ContractType.SUBAGENCY);
            this.totalSubagent = HotelPriceComponents.getTotalSubagent(subagencyCR);
            this.subagentCurrency = HotelPriceComponents.getCurrency((BaseContractRelationData)subagencyCR);
        }
        if (CollectionUtil.isNotEmpty(this.parameters.getDisplayCurrencies())) {
            this.rates = ComponentsHelper.getCurrencyRates(this.currency, this.getTotal(), this.parameters.getDisplayCurrencies());
        }
        if (detalization.getVat() != null) {
            this.vat = detalization.getVat().getComponents().stream().filter(Objects::nonNull).map(VatComponent::getRate).filter(Objects::nonNull).findFirst().orElse(null);
        }
    }

    private boolean validBreakdowns(List<Money> breakdowns, String gdsCurrency) {
        if (breakdowns.isEmpty()) {
            return false;
        }
        return breakdowns.stream().noneMatch(money -> this.invalidBreakdown((Money)money, gdsCurrency));
    }

    private boolean invalidBreakdown(Money money, String gdsCurrency) {
        return money == null || money.getValue() == null || !gdsCurrency.equalsIgnoreCase(money.getCurrency());
    }

    @Override
    public Price createPrice() {
        Price result = super.createPrice();
        result.setVat(this.vat);
        return result;
    }

    public static class Builder {
        private final HotelOffer offer;
        private final PriceComponentsParameters componentsParameters;

        private Builder(HotelOffer offer, PriceComponentsParameters componentsParameters) {
            this.offer = offer;
            this.componentsParameters = componentsParameters;
        }

        public HotelPriceComponents build() {
            HotelPriceComponents result = new HotelPriceComponents(this.offer, this.componentsParameters);
            result.buildPriceStructures();
            return result;
        }
    }
}

