/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.components;

import com.gridnine.xtrip.common.ibecorp.CurrencyHelper;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccident;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.components.ComponentsHelper;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.components.Rate;
import java.math.BigDecimal;
import java.util.List;

public class InsurancePriceComponents {
    private final BigDecimal total;
    private List<Rate> rates;
    private final String currency;
    private final PriceComponentsParameters parameters;

    public InsurancePriceComponents(List<InsuranceAccident> reservations, PriceComponentsParameters componentsParameters) {
        this.parameters = componentsParameters;
        this.currency = this.parameters.getCurrency();
        BigDecimal total = reservations.stream().map(insuranceAccident -> BookingHelper.getTotalPrice((BaseProduct)insuranceAccident, (ContractType)ContractType.CLIENT)).reduce(BigDecimal.ZERO, BigDecimal::add);
        total = BigDecimal.ZERO.compareTo(total) == 0 ? BigDecimal.ZERO : CurrencyHelper.exchange((BigDecimal)total, (String)CurrencyHelper.getSystem(), (String)this.currency);
        this.total = CommonHelper.round(total);
        if (componentsParameters.getDisplayCurrencies() != null && !componentsParameters.getDisplayCurrencies().isEmpty()) {
            this.rates = ComponentsHelper.getCurrencyRates(this.currency, total, componentsParameters.getDisplayCurrencies());
        }
    }

    public BigDecimal getTotal() {
        return this.total;
    }

    public List<Rate> getRates() {
        return this.rates;
    }

    public String getCurrency() {
        return this.currency;
    }

    public PriceComponentsParameters getParameters() {
        return this.parameters;
    }
}

