/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.components;

import com.gridnine.xtrip.common.ibecorp.CurrencyHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.ibecorp.PriceDetailDisplayArea;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMCurrencyDisplaySettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.authorization.AuthorizationHelper;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class PriceComponentsParameters {
    private boolean isAddIncomeInformation = false;
    private boolean isCalculateSubagentPrice = false;
    private String currency;
    private String subagentCurrency;
    private SalesContext salesContext;
    private List<SMCurrencyDisplaySettings> displayCurrencies;
    private PriceDetailDisplayArea priceDetailDisplayArea = PriceDetailDisplayArea.SITE;
    EntityReference<Person> authorizedUserRef;

    private PriceComponentsParameters() {
    }

    public static PriceComponentsParameters getB2BComponentsParameters(EntityReference<Person> authorizedUserRef, SalesContext salesContext) {
        SMGeneralSettings generalSettings = CommonHelper.getGeneralSettings((EntityReference<SMSite>)salesContext.getSite());
        List displayCurrencies = Optional.ofNullable(generalSettings).map(SMGeneralSettings::getDisplayCurrencies).orElse(null);
        return new PriceComponentsParameters().setCurrency(CurrencyHelper.getCurrency((EntityReference)salesContext.getSubagency(), (EntityReference)salesContext.getClient(), (ContractType)ContractType.CLIENT)).setSubagentCurrency(CurrencyHelper.getSubagentCurrencyForSubagent((EntityReference)salesContext.getAgency(), (EntityReference)salesContext.getSubagency())).setAddIncomeInformation(!AuthorizationHelper.isCorporantAuthorized(authorizedUserRef)).setDisplayCurrencies(displayCurrencies).setCalculateSubagentPrice(true).setAuthorizedUserRef(authorizedUserRef).setSalesContext(salesContext);
    }

    public static PriceComponentsParameters getB2CComponentsParameters(SalesContext salesContext) {
        return new PriceComponentsParameters().setCurrency(CurrencyHelper.getCurrency((EntityReference)salesContext.getSubagency(), (EntityReference)salesContext.getClient(), (ContractType)ContractType.CLIENT)).setAddIncomeInformation(false).setDisplayCurrencies(Objects.requireNonNull(CommonHelper.getGeneralSettings((EntityReference<SMSite>)salesContext.getSite())).getDisplayCurrencies()).setSalesContext(salesContext);
    }

    public static PriceComponentsParameters getTestComponentsParameters(SalesContext salesContext) {
        return new PriceComponentsParameters().setCurrency(CurrencyHelper.getCurrency((EntityReference)salesContext.getSubagency(), (EntityReference)salesContext.getClient(), (ContractType)ContractType.CLIENT)).setSubagentCurrency(CurrencyHelper.getSubagentCurrencyForSubagent((EntityReference)salesContext.getAgency(), (EntityReference)salesContext.getSubagency())).setAddIncomeInformation(true).setDisplayCurrencies(null).setCalculateSubagentPrice(true).setSalesContext(salesContext);
    }

    public static PriceComponentsParameters getNotificationPriceComponentsParameters(Reservation reservation) {
        return new PriceComponentsParameters().setDisplayCurrencies(null).setAddIncomeInformation(false).setCalculateSubagentPrice(false).setPriceDetailDisplayArea(PriceDetailDisplayArea.NOTIFICATION).setSalesContext(PriceComponentsParameters.restoreSalesContext(reservation));
    }

    public static PriceComponentsParameters getBriefInfoParameters(SalesContext salesContext) {
        return new PriceComponentsParameters().setCurrency(CurrencyHelper.getCurrency((EntityReference)salesContext.getSubagency(), (EntityReference)salesContext.getClient(), (ContractType)ContractType.CLIENT)).setDisplayCurrencies(null).setAddIncomeInformation(false).setSalesContext(salesContext);
    }

    public List<SMCurrencyDisplaySettings> getDisplayCurrencies() {
        return this.displayCurrencies;
    }

    private PriceComponentsParameters setDisplayCurrencies(List<SMCurrencyDisplaySettings> value) {
        this.displayCurrencies = value;
        return this;
    }

    public boolean isAddIncomeInformation() {
        return this.isAddIncomeInformation;
    }

    private PriceComponentsParameters setAddIncomeInformation(boolean value) {
        this.isAddIncomeInformation = value;
        return this;
    }

    public SalesContext getSalesContext() {
        return this.salesContext;
    }

    public PriceComponentsParameters setSalesContext(SalesContext salesContext) {
        this.salesContext = salesContext;
        return this;
    }

    public String getCurrency() {
        return this.currency;
    }

    private PriceComponentsParameters setCurrency(String currency) {
        this.currency = currency;
        return this;
    }

    public PriceComponentsParameters setPriceDetailDisplayArea(PriceDetailDisplayArea PriceDetailDisplayArea2) {
        this.priceDetailDisplayArea = PriceDetailDisplayArea2;
        return this;
    }

    public PriceDetailDisplayArea getPriceDetailDisplayArea() {
        return this.priceDetailDisplayArea;
    }

    public String getSubagentCurrency() {
        return this.subagentCurrency;
    }

    public PriceComponentsParameters setSubagentCurrency(String subagentCurrency) {
        this.subagentCurrency = subagentCurrency;
        return this;
    }

    public boolean isCalculateSubagentPrice() {
        return this.isCalculateSubagentPrice;
    }

    public PriceComponentsParameters setCalculateSubagentPrice(boolean calculateSubagentPrice) {
        this.isCalculateSubagentPrice = calculateSubagentPrice;
        return this;
    }

    public PriceComponentsParameters setAuthorizedUserRef(EntityReference<Person> authorizedUserRef) {
        this.authorizedUserRef = authorizedUserRef;
        return this;
    }

    public EntityReference<Person> getAuthorizedUserRef() {
        return this.authorizedUserRef;
    }

    public static SalesContext restoreSalesContext(Reservation res) {
        SalesContext result = new SalesContext();
        result.setAgency(res.getBookingFile().getAgency());
        result.setAgent(res.getBookingAgent());
        result.setSalesPoint(res.getSalesPoint());
        if (res.getBookingFile() != null) {
            result.setClient(res.getBookingFile().getCustomerProfile());
            result.setSite(res.getBookingFile().getSite());
            result.setSubagency(res.getSubagency());
        }
        return result;
    }
}

