/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.components;

import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.AdditionalService;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ContractRelationServiceDataDetalization;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.VendorAdditionalService;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceProduct;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.misc.ProductVoiding;
import com.gridnine.xtrip.common.model.booking.railway.RailwayMcoProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.DailyRate;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.handlers.PreferenceHelper;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.model.helpers.CancellationChargeHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.XtripPriceStructure;
import com.gridnine.xtrip.common.model.helpers.XtripPriceStructureHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsReservationHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.ancillaryFees.RestAncillaryFeesHelper;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.components.ComponentsHelper;
import com.gridnine.xtrip.server.ibecorp.common.components.GeneralPriceComponents;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.RestAncillaryFeeType;
import com.gridnine.xtrip.server.ibecorp.ibus.rules.PriceDetailRuleHelper;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ReservationPriceComponents
extends GeneralPriceComponents {
    private final Reservation reservation;
    private boolean includeVoid = false;
    private Predicate<BaseProduct> productFilter = pr -> true;
    private static final Set<TravelSubject> TRAVEL_SUBJECTS_WITH_TAXES = EnumSet.of(TravelSubject.AIR, TravelSubject.HOTEL_RESERVATION);
    private static final Set<ProductStatus> NEGATE_PRODUCT_STATUES = EnumSet.of(ProductStatus.EXCHANGE, ProductStatus.REFUND, ProductStatus.VOID);

    public static Builder builder(Reservation reservation, PriceComponentsParameters componentsParameters) {
        return new Builder(reservation, componentsParameters);
    }

    private ReservationPriceComponents(Reservation reservation, PriceComponentsParameters componentsParameters) {
        super(componentsParameters, PriceDetailRuleHelper.getPriceDetailDisplay(reservation, componentsParameters));
        this.reservation = reservation;
        TravelSubject travelSubject = BookingHelper.getTravelSubject((Reservation)reservation);
        this.taxSupported = TRAVEL_SUBJECTS_WITH_TAXES.contains(travelSubject);
    }

    private void buildPriceStructures() {
        Predicate<BaseProduct> mainProductFilter = this.productFilter.and(bp -> ProductHandler.of((BaseProduct)bp).getRelatedProducts(bp).isEmpty());
        for (Map.Entry<Traveller, List<BaseProduct>> entry : CommonHelper.getTravellerBaseProductsMap(this.reservation, BaseProduct.class, mainProductFilter).entrySet()) {
            Traveller traveller = entry.getKey();
            List<BaseProduct> mainProducts = entry.getValue();
            Map productsMap = mainProducts.stream().collect(Collectors.toMap(Function.identity(), mp -> this.getRelatedAdditionalProducts(this.reservation, (BaseProduct)mp)));
            if (CollectionUtil.isEmpty(mainProducts)) continue;
            BaseProduct firstProduct = mainProducts.get(0);
            ProductHandler ph = Objects.requireNonNull(GeneralProductHelper.getHandler((BaseProduct)firstProduct));
            DictionaryReference passengerType = ph.getPassengerType(firstProduct, traveller);
            if (null == passengerType) {
                passengerType = DictHelper.getAdultPassengerType();
            }
            int count = this.getPassengersCount((DictionaryReference<PassengerType>)passengerType);
            this.passengersMap.put(passengerType, ++count);
            for (BaseProduct product : mainProducts) {
                XtripPriceStructure priceStructure;
                ProductHandler productHandler = ProductHandler.of((BaseProduct)product);
                ProductStatus status = productHandler.getStatus(product);
                boolean negate = NEGATE_PRODUCT_STATUES.contains(status);
                ArrayList<GeneralPriceComponents.PassengerAncillaryFeeStructure> passengerAncillaryFees = new ArrayList<GeneralPriceComponents.PassengerAncillaryFeeStructure>();
                BigDecimal mainProductPenalty = BigDecimal.ZERO;
                ArrayList<MiscUtil.Pair<LocalDate, BigDecimal>> dailyDetails = new ArrayList<MiscUtil.Pair<LocalDate, BigDecimal>>();
                if (this.isValidStatus(status)) {
                    GeneralProductContractRelationData clientContractRelation = GeneralProductHelper.getClientContractRelation((BaseProduct)product);
                    ContractRelationServiceDataDetalization crDetalization = clientContractRelation.getServiceData().getDetalization();
                    mainProductPenalty = MiscUtil.guarded((BigDecimal)crDetalization.getPenalty());
                    priceStructure = XtripPriceStructureHelper.calculatePriceStructure((BaseProduct)product, (boolean)true);
                    BaseProduct previousProduct = productHandler.getPreviousProduct(product);
                    if (status == ProductStatus.REFUND && previousProduct != null) {
                        BigDecimal sellHiddenNotRefundedFees = CancellationChargeHelper.calcHiddenNotRefundedFeesAmount((List)GeneralProductHelper.getUnmodifiableContractRelations((BaseProduct)previousProduct));
                        mainProductPenalty = MiscUtil.sum((BigDecimal[])new BigDecimal[]{mainProductPenalty, sellHiddenNotRefundedFees});
                        this.addToFare(priceStructure, sellHiddenNotRefundedFees);
                    }
                    if (negate) {
                        priceStructure.negate();
                    }
                    if (crDetalization.getAdditionalServices() != null && CollectionUtil.isNotEmpty((Collection)crDetalization.getAdditionalServices().getAdditionalServices())) {
                        for (AdditionalService detalizationAs : crDetalization.getAdditionalServices().getAdditionalServices()) {
                            String passengerAncillaryFeeCaption = this.getPassengerAncillaryFeeCaption(product, detalizationAs);
                            if (TextUtil.isBlank((String)passengerAncillaryFeeCaption)) continue;
                            XtripPriceStructure asPS = this.buildPriceStructure(detalizationAs);
                            if (negate) {
                                asPS.negate();
                            }
                            passengerAncillaryFees.add(new GeneralPriceComponents.PassengerAncillaryFeeStructure(asPS, 1, passengerAncillaryFeeCaption));
                            this.addToFare(priceStructure, asPS.getProductPrice().negate());
                        }
                    }
                    if (this.showHotelDailyDetails && product instanceof HotelProduct) {
                        HotelProduct hp = (HotelProduct)product;
                        Room room = Objects.requireNonNull(HotelsReservationHelper.getFirstRoom((HotelProduct)hp));
                        String gdsCurrency = (String)MiscUtil.guarded((Object)ph.getGdsCurrency((BaseProduct)hp), (Object)PreferenceHelper.getLocalCurrency());
                        if (this.validDailyRates(room.getDailyRates(), gdsCurrency, hp)) {
                            for (DailyRate dailyRate : room.getDailyRates()) {
                                BigDecimal clientAmount = ComponentsHelper.calcClientAmount(dailyRate.getRate().getValue(), GeneralProductHelper.getUnmodifiableContractRelations((BaseProduct)hp));
                                this.addDailyDetails(dailyDetails, dailyRate.getStartDate(), dailyRate.getEndDate(), clientAmount);
                            }
                        } else if (room.getCheckInDate() != null && room.getCheckOutDate() != null) {
                            this.addDailyDetails(dailyDetails, room.getCheckInDate(), room.getCheckOutDate(), BigDecimal.ZERO);
                        }
                    }
                } else {
                    priceStructure = new XtripPriceStructure();
                }
                XtripPriceStructure finalPriceStructure = priceStructure;
                List addProducts = productsMap.get(product);
                if (addProducts != null) {
                    addProducts.stream().filter(this::isFakeProductForFees).map(bp -> XtripPriceStructureHelper.calculatePriceStructure((BaseProduct)bp, (boolean)true)).forEach(arg_0 -> ((XtripPriceStructure)finalPriceStructure).add(arg_0));
                    Map<String, List<BaseProduct>> productsByType = addProducts.stream().filter(bp -> !this.isFakeProductForFees((BaseProduct)bp)).collect(Collectors.groupingBy(this::getMcoTypeCaption));
                    for (String type : productsByType.keySet()) {
                        List<BaseProduct> productsOfType = productsByType.get(type);
                        XtripPriceStructure afPriceStructure = new XtripPriceStructure();
                        int number = 0;
                        for (BaseProduct addProduct : productsOfType) {
                            ++number;
                            XtripPriceStructure apPS = XtripPriceStructureHelper.calculatePriceStructure((BaseProduct)addProduct, (boolean)true);
                            boolean addProductNegate = NEGATE_PRODUCT_STATUES.contains(GeneralProductHelper.getStatus((BaseProduct)addProduct));
                            if (addProductNegate) {
                                apPS.negate();
                            }
                            afPriceStructure.add(apPS);
                        }
                        passengerAncillaryFees.add(new GeneralPriceComponents.PassengerAncillaryFeeStructure(afPriceStructure, number, type));
                    }
                    productsMap.remove(product);
                }
                GeneralPriceComponents.PassengerPriceStructure pps = new GeneralPriceComponents.PassengerPriceStructure(finalPriceStructure, mainProductPenalty);
                pps.addAncillaryFees(passengerAncillaryFees);
                List structures = (List)CollectionUtil.getFromMap((Map)this.passengerPriceStructureMap, (Object)passengerType, ArrayList::new);
                int ppsInd = structures.indexOf(pps);
                if (ppsInd != -1) {
                    pps = (GeneralPriceComponents.PassengerPriceStructure)structures.get(ppsInd);
                } else {
                    structures.add(pps);
                }
                pps.incPassengerCount();
                this.passengerDailyDetails.put(pps, dailyDetails);
            }
            boolean existsLostAddProducts = productsMap.keySet().stream().anyMatch(Objects::nonNull);
            if (!existsLostAddProducts) continue;
            throw Xeption.forDeveloper((String)"exists additional products with invalid related product", (Object[])new Object[0]);
        }
        if (this.parameters.isCalculateSubagentPrice()) {
            this.totalSubagent = BookingStreamHelper.getBaseProductsStream((Reservation)this.reservation).filter(this.productFilter).map(bp -> BookingHelper.getTotalPrice((BaseProduct)bp, (ContractType)ContractType.SUBAGENCY)).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        this.setCurrencies();
        if (CollectionUtil.isNotEmpty(this.parameters.getDisplayCurrencies())) {
            this.rates = ComponentsHelper.getCurrencyRates(this.currency, this.getTotal(), this.parameters.getDisplayCurrencies());
        }
    }

    private boolean validDailyRates(List<DailyRate> dailyRates, String gdsCurrency, HotelProduct hp) {
        if (dailyRates.isEmpty()) {
            return false;
        }
        boolean invalidRatesExists = dailyRates.stream().anyMatch(dr -> this.invalidDailyRate((DailyRate)dr, gdsCurrency));
        if (invalidRatesExists) {
            IncidentsLog.reportStackTrace((String)String.format("BookingFile %s reservation %s product %s: invalid dailyRates exists", this.reservation.getBookingFile().getNumber(), CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)this.reservation), hp.getUid()));
        }
        return !invalidRatesExists;
    }

    private boolean invalidDailyRate(DailyRate dailyRate, String gdsCurrency) {
        return dailyRate == null || dailyRate.getStartDate() == null || dailyRate.getEndDate() == null || dailyRate.getRate() == null || dailyRate.getRate().getValue() == null || !gdsCurrency.equalsIgnoreCase(dailyRate.getRate().getCurrency());
    }

    private List<BaseProduct> getRelatedAdditionalProducts(Reservation reservation, BaseProduct mainProduct) {
        return this.getRelatedProductsRecursive(mainProduct).stream().filter(bp -> MiscUtil.equals((Object)bp.getReservation(), (Object)reservation)).filter(bp -> this.isValidStatus(GeneralProductHelper.getStatus((BaseProduct)bp))).filter(bp -> !ProductHandler.of((BaseProduct)bp).getUnmodifiableContractRelations(bp).isEmpty()).distinct().collect(Collectors.toList());
    }

    private List<BaseProduct> getRelatedProductsRecursive(BaseProduct product) {
        Reservation reservation = product.getReservation();
        ArrayList<BaseProduct> result = new ArrayList<BaseProduct>();
        List<BaseProduct> lookFor = Collections.singletonList(product);
        while (!lookFor.isEmpty()) {
            ArrayList<BaseProduct> subResult = new ArrayList<BaseProduct>();
            for (BaseProduct bp : reservation.getProducts()) {
                List relProducts;
                if (result.contains(bp) || !CollectionUtil.containAtLeastOneCommonElement(lookFor, (Collection)(relProducts = ProductHandler.of((BaseProduct)bp).getRelatedProducts(bp)))) continue;
                subResult.add(bp);
            }
            result.addAll(subResult);
            lookFor = subResult;
        }
        return result;
    }

    private void addToFare(XtripPriceStructure priceStructure, BigDecimal value) {
        priceStructure.setProductPrice(MiscUtil.sum((BigDecimal[])new BigDecimal[]{priceStructure.getProductPrice(), value}));
        priceStructure.getPriceDetalization().setFare(MiscUtil.sum((BigDecimal[])new BigDecimal[]{priceStructure.getPriceDetalization().getFare(), value}));
    }

    private boolean isFakeProductForFees(BaseProduct baseProduct) {
        return baseProduct instanceof ProductVoiding;
    }

    private String getMcoTypeCaption(BaseProduct bp) {
        RailwayMcoProduct product;
        if (bp instanceof Product) {
            Product product2 = (Product)bp;
            return RestAncillaryFeesHelper.convertToRestAncillaryFeeType(product2.getMcoCategory()).toString();
        }
        if (bp instanceof RailwayMcoProduct && (product = (RailwayMcoProduct)bp).getMcoCategory() != null) {
            return product.getMcoCategory().toString();
        }
        if (bp instanceof AdditionalServiceProduct && (product = (AdditionalServiceProduct)bp).getCategory() != null) {
            return product.getCategory().toString();
        }
        Reservation reservation = bp.getReservation();
        IncidentsLog.reportStackTrace((String)String.format("BookingFile %s reservation %s product %s: unsupported additional product in priceComponents", reservation.getBookingFile().getNumber(), CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation), bp.getUid()));
        return RestAncillaryFeeType.OTHER.toString();
    }

    private String getPassengerAncillaryFeeCaption(BaseProduct bp, AdditionalService detalizationAs) {
        Collection addServices = ProductHandler.of((BaseProduct)bp).getProductBaseAdditionalServices(bp);
        if (CollectionUtil.isEmpty((Collection)addServices)) {
            return null;
        }
        VendorAdditionalService addService = addServices.stream().filter(as -> MiscUtil.equals((Object)as.getSource(), (Object)detalizationAs.getSource())).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"can't find additional service with uid {0}", (Object[])new Object[]{detalizationAs.getSource()}));
        return addService.getTypeCaption();
    }

    private void setCurrencies() {
        List relations = this.reservation.getProducts().stream().map(bp -> ProductHandler.of((BaseProduct)bp).getUnmodifiableContractRelations(bp)).filter(CollectionUtil::isNotEmpty).findFirst().get();
        this.subagentCurrency = ReservationPriceComponents.getCurrency(GeneralProductHelper.findContractRelation((List)relations, (ContractType)ContractType.SUBAGENCY));
        this.currency = ReservationPriceComponents.getCurrency(GeneralProductHelper.findContractRelation((List)relations, (ContractType)ContractType.CLIENT));
    }

    private boolean isValidStatus(ProductStatus status) {
        if (this.includeVoid && status == ProductStatus.VOID) {
            return true;
        }
        return !ProductStatusHandler.getAllVoidStatuses().contains(status);
    }

    public static class Builder {
        private final Reservation reservation;
        private final PriceComponentsParameters componentsParameters;
        private boolean negateAfter = false;
        private boolean includeVoid = false;
        private Predicate<BaseProduct> productFilter = pr -> true;

        private Builder(Reservation reservation, PriceComponentsParameters componentsParameters) {
            this.reservation = reservation;
            this.componentsParameters = componentsParameters;
        }

        public Builder setNegateAfter() {
            this.negateAfter = true;
            return this;
        }

        public Builder setIncludeVoid() {
            this.includeVoid = true;
            return this;
        }

        public Builder setProductFilter(Predicate<BaseProduct> productFilter) {
            this.productFilter = productFilter;
            return this;
        }

        public ReservationPriceComponents build() {
            ReservationPriceComponents result = new ReservationPriceComponents(this.reservation, this.componentsParameters);
            result.includeVoid = this.includeVoid;
            result.productFilter = this.productFilter;
            result.buildPriceStructures();
            if (this.negateAfter) {
                result.negate();
            }
            return result;
        }
    }
}

