/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.components;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.midoffice.helper.SalesContextHandler;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.commission.ReturnCase;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.ibecorp.PriceDetailDisplay;
import com.gridnine.xtrip.common.rest.BaseRestEntity;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.server.ibecorp.common.components.BasePriceComponentsTest;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.components.ReservationPriceComponents;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.Price;
import com.gridnine.xtrip.server.model.test.RestModelAssert;
import com.gridnine.xtrip.server.model.test.TestFeePropertiesBuilder;
import java.util.Date;
import java.util.function.Predicate;
import org.apache.commons.lang.time.FastDateFormat;
import org.junit.Test;

public class ReservationPriceComponentsTest
extends BasePriceComponentsTest {
    @Test
    public void basic1Test() throws Exception {
        this.testScenario("reservation_basic1", PriceDetailDisplay.DETAILED);
    }

    @Test
    public void basic2Test() throws Exception {
        this.testScenario("reservation_basic2", PriceDetailDisplay.DETAILED_WITH_FEES_IN_TAXES);
    }

    @Test
    public void basic3Test() throws Exception {
        this.testScenario("reservation_basic3", PriceDetailDisplay.TOTAL_ONLY);
    }

    @Test
    public void basic4Test() throws Exception {
        this.testScenario("reservation_basic4", PriceDetailDisplay.DETAILED, bp -> {
            Date departureDate = ProductHandler.of((BaseProduct)bp).findFirstTravelDate(bp);
            return "26.04.2023".equals(FastDateFormat.getInstance((String)"dd.MM.yyyy").format(departureDate));
        });
    }

    @Test
    public void basic5Test() throws Exception {
        this.testScenario("reservation_basic5", PriceDetailDisplay.DETAILED_WITH_FEES_IN_TAXES);
    }

    @Test
    public void basic6Test() throws Exception {
        this.testScenario("reservation_basic6", PriceDetailDisplay.DETAILED_WITH_FEES_IN_TAXES);
    }

    @Test
    public void hotel1Test() throws Exception {
        this.testScenario("reservation_hotel1", PriceDetailDisplay.DETAILED, true);
    }

    @Test
    public void hotel2Test() throws Exception {
        this.testScenario("reservation_hotel2", PriceDetailDisplay.DETAILED, true);
    }

    @Test
    public void hotel3Test() throws Exception {
        this.testScenario("reservation_hotel3", PriceDetailDisplay.DETAILED_WITH_FEES_IN_TAXES, true);
    }

    @Test
    public void hotel4Test() throws Exception {
        this.testScenario("reservation_hotel4", PriceDetailDisplay.TOTAL_ONLY, true);
    }

    @Test
    public void hotel5Test() throws Exception {
        this.testScenario("reservation_hotel5", PriceDetailDisplay.DETAILED, true);
    }

    @Test
    public void additionalServices1Test() throws Exception {
        this.testScenario("reservation_addServices1", PriceDetailDisplay.DETAILED);
    }

    @Test
    public void mco1Test() throws Exception {
        this.testScenario("reservation_mco1", PriceDetailDisplay.DETAILED);
    }

    @Test
    public void mco2Test() throws Exception {
        this.testScenario("reservation_mco2", PriceDetailDisplay.DETAILED);
    }

    @Test
    public void void1Test() throws Exception {
        this.testScenario("reservation_void1", PriceDetailDisplay.DETAILED);
    }

    @Test
    public void void2Test() throws Exception {
        this.testScenario("reservation_void2", PriceDetailDisplay.DETAILED);
    }

    @Test
    public void void3Test() throws Exception {
        this.testScenario("reservation_void3", PriceDetailDisplay.DETAILED, true, true);
    }

    @Test
    public void void4Test() throws Exception {
        this.testScenario("reservation_void4", PriceDetailDisplay.DETAILED);
    }

    @Test
    public void refund1Test() throws Exception {
        this.testScenario("reservation_refund1", PriceDetailDisplay.DETAILED);
    }

    @Test
    public void refund2Test() throws Exception {
        this.testScenario("reservation_refund2", PriceDetailDisplay.DETAILED, false, bp -> GeneralProductHelper.getStatus((BaseProduct)bp) == ProductStatus.REFUND, true, false);
    }

    @Test
    public void refund3Test() throws Exception {
        ((TestFeePropertiesBuilder)new TestFeePropertiesBuilder().containerUid("da04b052-5e3a-4463-9d1d-96a9014e0f3e")).returned(new ReturnCase[]{ReturnCase.NO_PENALTIES_REFUND}).hidden(true, null).create();
        this.testScenario("reservation_refund3", PriceDetailDisplay.DETAILED);
    }

    @Test
    public void refund4Test() throws Exception {
        this.testScenario("reservation_refund4", PriceDetailDisplay.DETAILED);
    }

    @Test
    public void refund5Test() throws Exception {
        this.testScenario("reservation_refund5", PriceDetailDisplay.DETAILED);
    }

    private void testScenario(String scenario, PriceDetailDisplay priceDetailDisplay) throws Exception {
        this.testScenario(scenario, priceDetailDisplay, null);
    }

    private void testScenario(String scenario, PriceDetailDisplay priceDetailDisplay, boolean showHotelDailyDetails) throws Exception {
        this.testScenario(scenario, priceDetailDisplay, showHotelDailyDetails, null, false, false);
    }

    private void testScenario(String scenario, PriceDetailDisplay priceDetailDisplay, Predicate<BaseProduct> productFilter) throws Exception {
        this.testScenario(scenario, priceDetailDisplay, false, productFilter, false, false);
    }

    private void testScenario(String scenario, PriceDetailDisplay priceDetailDisplay, boolean negate, boolean includeVoid) throws Exception {
        this.testScenario(scenario, priceDetailDisplay, false, null, negate, includeVoid);
    }

    private void testScenario(String scenario, PriceDetailDisplay priceDetailDisplay, boolean showHotelDailyDetails, Predicate<BaseProduct> productFilter, boolean negate, boolean includeVoid) throws Exception {
        String prefix = "resources/" + scenario;
        String reservationFile = prefix + "_reservation.xml";
        String resultFile = prefix + "_result.json";
        Environment.publish(SalesContextHandler.class, (Object)((Object)new BasePriceComponentsTest.TestSalesContextHandler(priceDetailDisplay, showHotelDailyDetails)));
        Reservation reservation = new Reservation();
        this.loadXSerializable(reservationFile, (XSerializable)reservation);
        ReservationPriceComponents.Builder builder = ReservationPriceComponents.builder(reservation, PriceComponentsParameters.getTestComponentsParameters(this.headSalesContext)).setProductFilter((Predicate)MiscUtil.guarded(productFilter, pr -> true));
        if (negate) {
            builder.setNegateAfter();
        }
        if (includeVoid) {
            builder.setIncludeVoid();
        }
        Price actual = builder.build().createPrice();
        Price expected = this.unmarshalJson(resultFile, Price.class);
        RestModelAssert.assertEntityEquals((BaseRestEntity)expected, (BaseRestEntity)actual);
    }
}

