/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.components;

import com.gridnine.xtrip.common.model.booking.BaseContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.XtripPriceStructure;
import com.gridnine.xtrip.common.model.helpers.XtripPriceStructureHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.ibecorp.common.components.ComponentsHelper;
import com.gridnine.xtrip.server.ibecorp.common.components.GeneralPriceComponents;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.ibus.rules.PriceDetailRuleHelper;
import com.gridnine.xtrip.server.transfers.SearchGdsResponse;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;

public class TransferPriceComponents
extends GeneralPriceComponents {
    private static final DictionaryReference<PassengerType> EMPTY_PASSENGER_TYPE = null;
    private final SearchGdsResponse transferOffer;

    public static Builder builder(SearchGdsResponse transferOffer, PriceComponentsParameters componentsParameters) {
        return new Builder(transferOffer, componentsParameters);
    }

    private TransferPriceComponents(SearchGdsResponse transferOffer, PriceComponentsParameters componentsParameters) {
        super(componentsParameters, PriceDetailRuleHelper.getPriceDetailDisplay(transferOffer, componentsParameters.getSalesContext()));
        this.transferOffer = transferOffer;
    }

    private void buildPriceStructures() {
        this.passengersMap.put(EMPTY_PASSENGER_TYPE, 1);
        XtripPriceStructure offerPS = XtripPriceStructureHelper.calculatePriceStructure((List)this.transferOffer.getContractRelations(), (boolean)true, null);
        GeneralPriceComponents.PassengerPriceStructure pps = new GeneralPriceComponents.PassengerPriceStructure(offerPS, BigDecimal.ZERO);
        pps.setPassengerCount((Integer)this.passengersMap.get(EMPTY_PASSENGER_TYPE));
        this.passengerPriceStructureMap.put(EMPTY_PASSENGER_TYPE, Collections.singletonList(pps));
        if (this.parameters.isCalculateSubagentPrice()) {
            GeneralProductContractRelationData subagencyCR = (GeneralProductContractRelationData)GeneralProductHelper.findContractRelation((List)this.transferOffer.getContractRelations(), (ContractType)ContractType.SUBAGENCY);
            this.totalSubagent = TransferPriceComponents.getTotalSubagent(subagencyCR);
            this.subagentCurrency = TransferPriceComponents.getCurrency((BaseContractRelationData)subagencyCR);
        }
        this.currency = TransferPriceComponents.getCurrency(GeneralProductHelper.findContractRelation((List)this.transferOffer.getContractRelations(), (ContractType)ContractType.CLIENT));
        if (CollectionUtil.isNotEmpty(this.parameters.getDisplayCurrencies())) {
            this.rates = ComponentsHelper.getCurrencyRates(this.currency, this.getTotal(), this.parameters.getDisplayCurrencies());
        }
    }

    public static class Builder {
        private final SearchGdsResponse transferOffer;
        private final PriceComponentsParameters componentsParameters;

        private Builder(SearchGdsResponse transferOffer, PriceComponentsParameters componentsParameters) {
            this.transferOffer = transferOffer;
            this.componentsParameters = componentsParameters;
        }

        public TransferPriceComponents build() {
            TransferPriceComponents result = new TransferPriceComponents(this.transferOffer, this.componentsParameters);
            result.buildPriceStructures();
            return result;
        }
    }
}

