/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.DocaInformation;
import com.gridnine.xtrip.common.gds.model.DocoInformation;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GdsContractRelationData;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableName;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableNameUtil;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.BookingAirlineBonusCard;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseContractRelationData;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ContractRelationGeneralData;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.railway.FreeMealInfo;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.CommunicationHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.ibecorp.AckMessage;
import com.gridnine.xtrip.common.model.ibecorp.DocoDocaInformation;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.common.model.profile.AirlineBonusCard;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.ExchangeRateData;
import com.gridnine.xtrip.common.model.profile.KeyContact;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonPassportWrapper;
import com.gridnine.xtrip.common.model.profile.RailwayBonusCard;
import com.gridnine.xtrip.common.model.profile.ReasonCode;
import com.gridnine.xtrip.common.model.profile.ReasonCodeType;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyApplicable;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyImpositionResult;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyMatchType;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.PersonRestCostCode;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.RestReasonCode;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.BookingFormSettings;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.RestAckMessage;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.RestMealInfo;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonValidationHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.SiteConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.BonusCard;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.Customer;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.DocaInfo;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.DocoInfo;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.HasTravelPolicyCompliance;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.Money;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.Phone;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.Rate;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.RestPassport;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.RestTraveller;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.TravelPolicyAction;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.TravelPolicyCompliance;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.TravelPolicyRule;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.DocoDocaInfo;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.Order;
import com.gridnine.xtrip.server.ibecorp.common.rest.rail.model.RailBonusCard;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.http.util.TextUtils;

public class CommonConverterHelper {
    public static final Comparator<Money> MONEY_COMPARATOR = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (MiscUtil.isZero((BigDecimal)o1.getAmount(), (boolean)true) || MiscUtil.isZero((BigDecimal)o2.getAmount(), (boolean)true)) {
            return MiscUtil.compare((Comparable)o1.getAmount(), (Comparable)o2.getAmount());
        }
        if (o1.getCurrencyCode() == null || o2.getCurrencyCode() == null) {
            throw new IllegalStateException("Currency code is null");
        }
        if (o1.getCurrencyCode().equals(o2.getCurrencyCode())) {
            return MiscUtil.compare((Comparable)o1.getAmount(), (Comparable)o2.getAmount());
        }
        throw new IllegalStateException("Mismatch currencies");
    };

    public static Map<String, ExchangeRateData> getCurrencyExchangeRateDataMap(Collection<Flight> gdsFlights, SalesContext salesContext) {
        long currenciesCount = gdsFlights.stream().map(CommonConverterHelper::getClientContractRelation).filter(Objects::nonNull).map(BaseContractRelationData::getGeneralData).filter(Objects::nonNull).map(ContractRelationGeneralData::getCurrency).filter(Objects::nonNull).map(DictionaryReference::getCode).distinct().count();
        if (currenciesCount < 2L) {
            return Collections.emptyMap();
        }
        HashSet<EntityReference> processedContracts = new HashSet<EntityReference>();
        EntityContainer firstContractCtr = null;
        EntityContainer mainContractCtr = null;
        for (Flight gdsFlight : gdsFlights) {
            GdsContractRelationData clientCR = CommonConverterHelper.getClientContractRelation(gdsFlight);
            EntityReference contractRef = clientCR.getGeneralData().getContractData().getContract();
            if (processedContracts.contains(contractRef)) continue;
            processedContracts.add(contractRef);
            EntityContainer contractCtr = EntityStorage.get().resolve(contractRef);
            if (((Contract)contractCtr.getEntity()).isDefaultContract()) {
                mainContractCtr = contractCtr;
                break;
            }
            if (firstContractCtr != null) continue;
            firstContractCtr = contractCtr;
        }
        ArrayList<Object> contractContainers = new ArrayList<Object>();
        contractContainers.add(MiscUtil.guarded(mainContractCtr, firstContractCtr));
        HashMap<String, ExchangeRateData> result = new HashMap<String, ExchangeRateData>();
        for (Flight gdsFlight : gdsFlights) {
            GdsContractRelationData clientCR = CommonConverterHelper.getClientContractRelation(gdsFlight);
            DictionaryReference flightClientCurrency = clientCR.getGeneralData().getCurrency();
            String flightCurrencyCode = flightClientCurrency.getCode();
            if (result.containsKey(flightCurrencyCode)) continue;
            result.put(flightCurrencyCode, RulesHelper.getExchangeRateData(contractContainers, (EntityReference)salesContext.getClient(), (Date)new Date(), null, (String)flightCurrencyCode, (boolean)true));
        }
        return result;
    }

    private static GdsContractRelationData getClientContractRelation(Flight gdsFlight) {
        Map contractRelations = FlightHelper.getContractRelations((Flight)gdsFlight, (ContractType)ContractType.CLIENT);
        return contractRelations.isEmpty() ? null : (GdsContractRelationData)contractRelations.values().iterator().next();
    }

    public static Money convertMoney2Rest(BigDecimal amount, String currency) {
        if (amount == null || TextUtil.isBlank((String)currency)) {
            return null;
        }
        Money result = new Money();
        result.setAmount(amount.setScale(Currency.getInstance(currency).getDefaultFractionDigits(), RoundingMode.HALF_UP));
        result.setCurrencyCode(currency);
        result.setCurrency((String)MiscUtil.findByLocale((Map)((CurrencyInfo)DictionaryCache.get().findByCode(CurrencyInfo.class, currency)).getTranslations(), (Locale)LocaleHelper.getCurrentLocale()));
        return result;
    }

    public static Money convertMoney2Rest(com.gridnine.xtrip.common.model.system.Money money) {
        Money result = new Money();
        if (money != null) {
            if (money.getValue() != null) {
                result.setAmount(money.getValue().setScale(0, RoundingMode.HALF_DOWN));
            }
            if (money.getCurrency() != null) {
                result.setCurrencyCode(money.getCurrency());
                result.setCurrency((String)MiscUtil.findByLocale((Map)((CurrencyInfo)DictionaryCache.get().findByCode(CurrencyInfo.class, money.getCurrency())).getTranslations(), (Locale)LocaleHelper.getCurrentLocale()));
            }
        }
        return result;
    }

    public static String getReferenceCaption(EntityReference<?> ref) {
        return ref == null ? null : ref.getCaption();
    }

    public static void updateRestTraveller(RestTraveller restTraveller, Traveller traveller) {
        restTraveller.setUid(traveller.getPassenger() != null ? traveller.getPassenger().getUid() : traveller.getUid());
        restTraveller.setPassport(CommonConverterHelper.convertPassport2Rest(traveller.getPassport()));
        restTraveller.setBirthDate(MiscUtil.convertToJodaLocalDate((Date)traveller.getBirthday()));
        Communication emailComm = CommonHelper.getEmail(traveller.getCommunications()).orElse(null);
        restTraveller.setEmail(emailComm == null ? null : emailComm.getSense());
        restTraveller.setPhone(CommonConverterHelper.convertPhoneCommunication2Rest(traveller));
    }

    public static Traveller convertTravellerFromRest(RestTraveller restTraveller, Date arriveDate) {
        Traveller traveller = new Traveller();
        if (restTraveller.getPassport() != null) {
            RestPassport restPassport = restTraveller.getPassport();
            traveller.setPassport(CommonConverterHelper.convertRest2Passport(restPassport, arriveDate));
            traveller.setGender(restPassport.getGender());
            traveller.setName(TextUtil.buildFullName((PersonalName)restPassport));
        }
        traveller.setBirthday(MiscUtil.convertDateFromJoda((org.joda.time.LocalDate)restTraveller.getBirthDate()));
        if (TextUtil.nonBlank((String)restTraveller.getEmail())) {
            traveller.getCommunications().add(CommonConverterHelper.convertRest2EmailCommunication(restTraveller.getEmail(), Communication::new));
        }
        if (!CommonHelper.isEmpty(restTraveller.getPhone())) {
            traveller.getCommunications().add(CommonConverterHelper.convertRest2PhoneCommunication(restTraveller.getPhone(), CommunicationType.WORK_PHONE, Communication::new));
        }
        traveller.setIIN(restTraveller.getIIN());
        if (TextUtil.nonBlank((String)restTraveller.getUid())) {
            traveller.setPassenger(new EntityReference(restTraveller.getUid(), Person.class, null));
        }
        return traveller;
    }

    public static Traveller getIfEmptyTraveller(List<Traveller> travellers, List<Traveller> availableTravellers) {
        Traveller traveller = availableTravellers.stream().filter(t -> t.getPassenger() == null).findFirst().orElse(null);
        if (traveller != null) {
            availableTravellers.remove(traveller);
        } else {
            traveller = new Traveller();
            traveller.setName("");
        }
        travellers.add(traveller);
        return traveller;
    }

    public static Traveller getTraveller(List<Traveller> travellers, List<Traveller> availableTravellers, EntityReference<Person> personRef) {
        Traveller traveller = availableTravellers.stream().filter(t -> t.getPassenger() != null && t.getPassenger().equals((Object)personRef)).findFirst().orElse(null);
        if (traveller != null) {
            availableTravellers.remove(traveller);
        } else {
            traveller = new Traveller();
            EntityContainer personCtr = EntityStorage.get().resolve(personRef);
            Person person = (Person)personCtr.getEntity();
            traveller.setPassenger(personRef);
            traveller.setPassport(!person.getPassports().isEmpty() ? (Passport)person.getPassports().get(0) : null);
            traveller.setName(PersonalLocalizableNameUtil.buildFullName((PersonalLocalizableName)person, (boolean)false, (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
            traveller.setBirthday(person.getBirthday());
            traveller.getCommunications().addAll(person.getCommunications());
        }
        travellers.add(traveller);
        return traveller;
    }

    public static RestPassport convertPassport2Rest(Passport passport) {
        if (passport == null) {
            return null;
        }
        RestPassport result = new RestPassport();
        result.setType(passport.getType());
        result.setNumber(passport.getNumber());
        result.setFirstName(passport.getFirstName());
        result.setMiddleName(passport.getMiddleName());
        result.setLastName(passport.getLastName());
        result.setBirthDate(DateUtils.toLocalDate((Date)passport.getBirthday()));
        result.setBirthPlace(passport.getBirthPlace());
        result.setGender(passport.getGender());
        result.setCitizenship(passport.getCitizenship());
        result.setOriginCountry(passport.getOriginCountry());
        result.setExpiredDate(DateUtils.toLocalDate((Date)passport.getExpired()));
        result.setIssueDate(DateUtils.toLocalDate((Date)passport.getIssued()));
        result.setWithoutMiddleName(TextUtil.isBlank((String)passport.getMiddleName()));
        return result;
    }

    public static RestPassport convertPassport2Rest(PersonPassportWrapper passport) {
        if (passport == null) {
            return null;
        }
        RestPassport result = new RestPassport();
        result.setUidCyr(passport.getUidCyrillic());
        result.setUidLat(passport.getUidLatin());
        result.setCorrelationId(passport.getCorrelationId());
        result.setType(passport.getType());
        result.setNumber(passport.getNumber());
        result.setFirstName(passport.getFirstNameCyrillic());
        result.setSecondName(passport.getSecondNameCyrillic());
        result.setMiddleName(passport.getMiddleNameCyrillic());
        result.setLastName(passport.getLastNameCyrillic());
        result.setFirstNameLat(passport.getFirstNameLatin());
        result.setSecondNameLat(passport.getSecondNameLatin());
        result.setMiddleNameLat(passport.getMiddleNameLatin());
        result.setLastNameLat(passport.getLastNameLatin());
        result.setBirthDate(DateUtils.toLocalDate((Date)passport.getBirthday()));
        result.setBirthPlace(passport.getBirthPlace());
        result.setGender(passport.getGender());
        result.setCitizenship(passport.getCitizenship());
        result.setOriginCountry(passport.getOriginCountry());
        result.setExpiredDate(DateUtils.toLocalDate((Date)passport.getExpired()));
        result.setIssueDate(DateUtils.toLocalDate((Date)passport.getIssued()));
        result.setWithoutMiddleName(TextUtil.isBlank((String)passport.getMiddleNameCyrillic()));
        result.setWithoutMiddleNameLat(TextUtil.isBlank((String)passport.getMiddleNameLatin()));
        return result;
    }

    public static PersonPassportWrapper convertPassportFromRest(RestPassport restPassport) {
        if (restPassport == null) {
            return null;
        }
        PersonPassportWrapper result = new PersonPassportWrapper();
        result.setUidCyrillic(restPassport.getUidCyr());
        result.setUidLatin(restPassport.getUidLat());
        result.setCorrelationId(restPassport.getCorrelationId());
        result.setType(restPassport.getType());
        result.setNumber(restPassport.getNumber());
        result.setFirstNameCyrillic(restPassport.getFirstName());
        result.setSecondNameCyrillic(restPassport.getSecondName());
        if (!restPassport.isWithoutMiddleName()) {
            result.setMiddleNameCyrillic(restPassport.getMiddleName());
        }
        result.setLastNameCyrillic(restPassport.getLastName());
        result.setFirstNameLatin(restPassport.getFirstNameLat());
        result.setSecondNameLatin(restPassport.getSecondNameLat());
        if (!restPassport.isWithoutMiddleNameLat()) {
            result.setMiddleNameLatin(restPassport.getMiddleNameLat());
        }
        result.setLastNameLatin(restPassport.getLastNameLat());
        result.setBirthday(DateUtils.toJavaDate((LocalDate)restPassport.getBirthDate()));
        result.setBirthPlace(restPassport.getBirthPlace());
        result.setGender(restPassport.getGender());
        result.setCitizenship(restPassport.getCitizenship());
        result.setOriginCountry(restPassport.getOriginCountry());
        result.setExpired(DateUtils.toJavaDate((LocalDate)restPassport.getExpiredDate()));
        result.setIssued(DateUtils.toJavaDate((LocalDate)restPassport.getIssueDate()));
        return result;
    }

    public static Passport convertRest2Passport(RestPassport passport) {
        return CommonConverterHelper.convertRest2Passport(passport, null);
    }

    public static Passport convertRest2Passport(RestPassport passport, Date arriveDate) {
        Passport result = new Passport();
        result.setType(passport.getType());
        result.setNumber(passport.getNumber());
        result.setFirstName(passport.getFirstName());
        result.setSecondName(passport.getSecondName());
        result.setLastName(passport.getLastName());
        if (!passport.isWithoutMiddleName()) {
            result.setMiddleName(passport.getMiddleName());
        }
        result.setBirthday(DateUtils.toJavaDate((LocalDate)passport.getBirthDate()));
        result.setBirthPlace(passport.getBirthPlace());
        result.setGender(passport.getGender());
        result.setCitizenship(passport.getCitizenship());
        result.setOriginCountry(passport.getOriginCountry());
        result.setExpired(CommonValidationHelper.isCalculateExpiredDate(passport.getType()) ? CommonValidationHelper.calculateExpiredDate((DictionaryReference<Country>)passport.getCitizenship(), arriveDate) : DateUtils.toJavaDate((LocalDate)passport.getExpiredDate()));
        result.setIssued(DateUtils.toJavaDate((LocalDate)passport.getIssueDate()));
        return result;
    }

    public static <T extends Communication> T convertRest2PhoneCommunication(Phone phone, CommunicationType type, Supplier<T> supplier) {
        Communication result = (Communication)supplier.get();
        result.setType(type);
        result.setCountryCode(phone.getCountryCode());
        if (TextUtil.nonBlank((String)phone.getCityCode())) {
            result.setCityCode(phone.getCityCode());
            result.setSense(phone.getNumber());
        } else {
            String numberWithCityCode = phone.getNumber();
            if (numberWithCityCode != null) {
                if (numberWithCityCode.length() <= 3) {
                    result.setCityCode(numberWithCityCode);
                } else {
                    result.setCityCode(numberWithCityCode.substring(0, 3));
                    result.setSense(numberWithCityCode.substring(3));
                }
            }
        }
        return (T)result;
    }

    public static Phone convertPhoneCommunication2Rest(Communication communication) {
        if (communication == null) {
            return null;
        }
        Phone result = new Phone();
        result.setCountryCode(communication.getCountryCode());
        result.setCityCode(communication.getCityCode());
        result.setNumber(communication.getSense());
        return result;
    }

    private static Phone convertPhoneCommunication2Rest(Traveller traveller) {
        return CommonConverterHelper.convertPhoneCommunication2Rest(traveller.getCommunications());
    }

    public static Phone convertPhoneCommunication2Rest(Collection<? extends Communication> communications) {
        return communications.stream().filter(comm -> comm.getType() == CommunicationType.MOBILE || comm.getType() == CommunicationType.HOME_PHONE || comm.getType() == CommunicationType.WORK_PHONE).map(CommonConverterHelper::convertPhoneCommunication2Rest).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static <T extends Communication> T convertRest2EmailCommunication(String email, Supplier<T> supplier) {
        Communication communication = (Communication)supplier.get();
        communication.setType(CommunicationType.EMAIL);
        communication.setSense(email);
        return (T)communication;
    }

    public static String convertEmailCommunication2Rest(Collection<? extends Communication> communications) {
        return communications.stream().filter(comm -> comm.getType() == CommunicationType.EMAIL).map(CommonConverterHelper::convertEmailCommunication2Rest).filter(TextUtil::nonBlank).findFirst().orElse(null);
    }

    public static String convertEmailCommunication2Rest(Communication communication) {
        return communication == null ? null : communication.getSense();
    }

    public static BookingAirlineBonusCard convertRest2BookingAirlineBonusCard(BonusCard bonusCard) {
        BookingAirlineBonusCard card = new BookingAirlineBonusCard();
        card.setAirline(bonusCard.getAirline());
        card.setNumber(bonusCard.getNumber());
        card.setNameOnCard(bonusCard.getNameOnCard());
        return card;
    }

    public static AirlineBonusCard convertRest2AirlineBonusCard(BonusCard bonusCard) {
        AirlineBonusCard result = new AirlineBonusCard();
        result.setAirline(bonusCard.getAirline());
        result.setNumber(bonusCard.getNumber());
        result.setNameOnCard(bonusCard.getNameOnCard());
        return result;
    }

    public static BonusCard convertAirlineBonusCard2Rest(AirlineBonusCard airlineBonusCard) {
        BonusCard result = new BonusCard();
        result.setAirline(airlineBonusCard.getAirline());
        result.setNumber(airlineBonusCard.getNumber());
        result.setNameOnCard(airlineBonusCard.getNameOnCard());
        return result;
    }

    public static RailwayBonusCard convertRest2RailwayBonusCard(RailBonusCard railBonusCard) {
        RailwayBonusCard result = new RailwayBonusCard();
        result.setUid(railBonusCard.getUid());
        result.setNumber(railBonusCard.getNumber());
        result.setRailwayCarrierCode("\u0420\u0416\u0414");
        return result;
    }

    public static RailBonusCard convertRailwayBonusCard2Rest(RailwayBonusCard railBonusCard) {
        RailBonusCard result = new RailBonusCard();
        result.setUid(railBonusCard.getUid());
        result.setNumber(railBonusCard.getNumber());
        result.setCarrierCode(railBonusCard.getRailwayCarrierCode());
        return result;
    }

    public static <T> T findByLocale(Map<Locale, T> map, Locale locale) {
        Object temp = MiscUtil.findByLocale(map, (Locale)locale);
        if (temp == null) {
            temp = MiscUtil.findByLocale(map, (Locale)Locale.ENGLISH);
        }
        if (temp == null) {
            temp = CollectionUtil.head(map.values());
        }
        return (T)temp;
    }

    public static DocoDocaInformation convertRest2DocoDocaInformation(DocoDocaInfo docoDocaInfo, List<Traveller> travellers) {
        Traveller traveller = (Traveller)CollectionUtil.find(travellers, (String)docoDocaInfo.getTravellerUid());
        if (traveller == null) {
            throw Xeption.forDeveloper((String)"can't find traveller by uid {0}", (Object[])new Object[]{docoDocaInfo.getTravellerUid()});
        }
        DocoDocaInformation result = new DocoDocaInformation();
        result.setTravellerUid(docoDocaInfo.getTravellerUid());
        result.setDocaInformation(CommonConverterHelper.convertRest2DocaInformation(docoDocaInfo.getDocaInfo()));
        if (docoDocaInfo.getDocoInfo() != null) {
            result.setVisaNotNeeded(!docoDocaInfo.getDocoInfo().isVisa());
            result.setDocoInformation(CommonConverterHelper.convertRest2DocoInformation(docoDocaInfo.getDocoInfo()));
        }
        return result;
    }

    public static DocoInformation convertRest2DocoInformation(DocoInfo docoInfo) {
        if (docoInfo == null || !docoInfo.isVisa()) {
            return null;
        }
        DocoInformation result = new DocoInformation();
        result.setPlaceOfBirthCountry(docoInfo.getPlaceOfBirthCountry());
        result.setVisaNumber(docoInfo.getVisaNumber());
        if (docoInfo.getVisaIssueDate() != null) {
            result.setVisaIssueDate(docoInfo.getVisaIssueDate().toDate());
        }
        if (docoInfo.getVisaExpirationDate() != null) {
            result.setVisaExpirationDate(docoInfo.getVisaExpirationDate().toDate());
        }
        result.setVisaIssuePlace(docoInfo.getVisaIssuePlace());
        result.setVisaApplicableCountry(docoInfo.getVisaApplicableCountry());
        result.setVisa(docoInfo.isVisa());
        return result;
    }

    public static DocaInformation convertRest2DocaInformation(DocaInfo docaInfo) {
        if (docaInfo == null) {
            return null;
        }
        DocaInformation result = new DocaInformation();
        result.setCountry(docaInfo.getCountry());
        result.setStateProvince(docaInfo.getStateProvince());
        result.setCity(docaInfo.getCity());
        result.setStreet(docaInfo.getStreet());
        result.setZipPostalCode(docaInfo.getZipPostalCode());
        result.setType(docaInfo.getAddressType());
        return result;
    }

    public static com.gridnine.xtrip.common.model.booking.Customer convertRest2Customer(Customer customer) {
        com.gridnine.xtrip.common.model.booking.Customer result = new com.gridnine.xtrip.common.model.booking.Customer();
        if (customer.getFirstName() != null && customer.getLastName() != null) {
            result.setName(customer.getFirstName().concat(" ").concat(customer.getLastName()));
            Passport passport = new Passport();
            passport.setFirstName(customer.getFirstName());
            passport.setLastName(customer.getLastName());
            result.setPassport(passport);
        }
        result.setPreferredLocale(LocaleHelper.getCurrentLocale());
        if (TextUtil.nonBlank((String)customer.getEmail())) {
            result.getCommunications().add(CommonConverterHelper.convertRest2EmailCommunication(customer.getEmail(), Communication::new));
        }
        if (customer.getPhone() != null) {
            result.getCommunications().add(CommonConverterHelper.convertRest2PhoneCommunication(customer.getPhone(), CommunicationType.MOBILE, Communication::new));
        }
        result.setProfile(customer.getPersonRef());
        return result;
    }

    public static Customer convertCustomer2Rest(com.gridnine.xtrip.common.model.booking.Customer customer) {
        Customer result = new Customer();
        result.setPersonRef(customer.getProfile());
        result.setFirstName(customer.getPassport().getFirstName());
        result.setLastName(customer.getPassport().getLastName());
        result.setEmail(CommonConverterHelper.convertEmailCommunication2Rest(customer.getCommunications()));
        result.setPhone((Phone)CommonHelper.getPhone(customer.getCommunications(), CommunicationType.MOBILE).map(CommonConverterHelper::convertPhoneCommunication2Rest).orElse(null));
        return result;
    }

    public static boolean shouldExcludeFromSearchResults(TravelPolicyApplicable obj) {
        return obj != null && obj.getTravelPolicyImpositionResult() != null && obj.getTravelPolicyImpositionResult().getMatchType() == TravelPolicyMatchType.HIDE;
    }

    public static void addTravelPolicyInfo(TravelPolicyImpositionResult src, HasTravelPolicyCompliance dest) {
        if (src == null) {
            dest.setTravelPolicyCompliance(null);
            return;
        }
        TravelPolicyCompliance result = CommonConverterHelper.buildTravelPolicyCompliance(src);
        if (CollectionUtil.isEmpty((Collection)result.getRulesApplied())) {
            dest.setTravelPolicyCompliance(null);
            return;
        }
        dest.setTravelPolicyCompliance(result);
    }

    public static void mergeTravelPolicyInfo(TravelPolicyImpositionResult src, HasTravelPolicyCompliance dest) {
        if (src == null) {
            return;
        }
        TravelPolicyCompliance addTP = CommonConverterHelper.buildTravelPolicyCompliance(src);
        if (addTP == null || CollectionUtil.isEmpty((Collection)addTP.getRulesApplied())) {
            return;
        }
        TravelPolicyCompliance curTP = dest.getTravelPolicyCompliance();
        if (curTP == null) {
            dest.setTravelPolicyCompliance(addTP);
            return;
        }
        for (TravelPolicyAction action : TravelPolicyAction.values()) {
            if (!CommonConverterHelper.travelPolicyComplianceHasAction(addTP, action) || CommonConverterHelper.travelPolicyComplianceHasAction(curTP, action)) continue;
            curTP.getRulesApplied().add(CommonConverterHelper.findTravelPolicyComplianceRule(addTP, action));
        }
    }

    private static boolean travelPolicyComplianceHasAction(TravelPolicyCompliance travelPolicyCompliance, TravelPolicyAction action) {
        return travelPolicyCompliance != null && travelPolicyCompliance.getRulesApplied().stream().anyMatch(r -> r.getAction() == action);
    }

    private static TravelPolicyRule findTravelPolicyComplianceRule(TravelPolicyCompliance travelPolicyCompliance, TravelPolicyAction action) {
        if (travelPolicyCompliance == null) {
            return null;
        }
        return travelPolicyCompliance.getRulesApplied().stream().filter(r -> r.getAction() == action).findFirst().orElse(null);
    }

    private static TravelPolicyCompliance buildTravelPolicyCompliance(TravelPolicyImpositionResult src) {
        TravelPolicyRule rule;
        TravelPolicyCompliance result = new TravelPolicyCompliance();
        if (src.isRecommended()) {
            rule = new TravelPolicyRule();
            rule.setAction(TravelPolicyAction.RECOMMENDED);
            result.getRulesApplied().add(rule);
        }
        if (src.getMatchType() != null) {
            switch (src.getMatchType()) {
                case VIOLATION: {
                    rule = new TravelPolicyRule();
                    rule.setAction(TravelPolicyAction.VIOLATION);
                    rule.getRuleDetails().addAll(CommonConverterHelper.getRuleDetails(src));
                    result.getRulesApplied().add(rule);
                    break;
                }
                case STRICT_VIOLATION: {
                    rule = new TravelPolicyRule();
                    rule.setAction(TravelPolicyAction.STRICT_VIOLATION);
                    rule.getRuleDetails().addAll(CommonConverterHelper.getRuleDetails(src));
                    result.getRulesApplied().add(rule);
                    break;
                }
                case HIDE: {
                    rule = new TravelPolicyRule();
                    rule.setAction(TravelPolicyAction.HIDE);
                    rule.getRuleDetails().addAll(CommonConverterHelper.getRuleDetails(src));
                    result.getRulesApplied().add(rule);
                    break;
                }
            }
        }
        if (src.getAuthorizationParameters() != null) {
            rule = new TravelPolicyRule();
            rule.setAction(TravelPolicyAction.AUTHORIZATION_REQUIRED);
            result.getRulesApplied().add(rule);
        }
        return result;
    }

    private static List<String> getRuleDetails(TravelPolicyImpositionResult src) {
        String localizedText = SiteConverterHelper.getLocalizedText(src.getL10nMessage());
        return TextUtil.nonBlank((String)localizedText) ? Collections.singletonList(localizedText) : src.getRuleDetails();
    }

    public static String getTimeLimitCity(SMGeneralSettings generalSettings) {
        return CommonHelper.getTimeZone(generalSettings).getTimeZoneCity().toString(LocaleManager.get().getCurrentLocale());
    }

    public static void setCustomerAndOrder(BookingFormSettings result, EntityReference<BookingFile> bookingFileRef) {
        EntityContainer bookingFileCtr = EntityStorage.get().resolve(bookingFileRef);
        if (null == bookingFileCtr) {
            return;
        }
        com.gridnine.xtrip.common.model.booking.Customer bookingCustomer = ((BookingFile)bookingFileCtr.getEntity()).getCustomer();
        if (bookingCustomer != null) {
            Customer customer = new Customer();
            Passport passport = bookingCustomer.getPassport();
            if (passport != null) {
                customer.setFirstName(passport.getFirstName());
                customer.setLastName(passport.getLastName());
            }
            customer.setEmail((String)bookingCustomer.getCommunications().stream().filter(c -> c.getType() == CommunicationType.EMAIL).map(Communication::getSense).findFirst().orElse(null));
            Communication mobile = bookingCustomer.getCommunications().stream().filter(c -> c.getType() == CommunicationType.MOBILE).findFirst().orElse(null);
            if (mobile != null) {
                Phone phone = new Phone();
                phone.setCountryCode(mobile.getCountryCode());
                phone.setCityCode(mobile.getCityCode());
                phone.setNumber(mobile.getSense());
                customer.setPhone(phone);
            }
            result.setCustomer(customer);
        }
        result.setOrder(CommonConverterHelper.getOrder((EntityContainer<BookingFile>)bookingFileCtr));
    }

    public static Order getOrder(EntityReference<BookingFile> bookingFileRef) {
        EntityContainer bookingFileCtr = EntityStorage.get().resolve(bookingFileRef);
        if (null == bookingFileCtr) {
            return null;
        }
        return CommonConverterHelper.getOrder((EntityContainer<BookingFile>)bookingFileCtr);
    }

    private static Order getOrder(EntityContainer<BookingFile> bookingFileCtr) {
        Order order = new Order();
        CommonConverterHelper.populateOrder(order, bookingFileCtr);
        return order;
    }

    public static void populateOrder(Order order, EntityContainer<BookingFile> bookingFileCtr) {
        order.setBookingUid(bookingFileCtr.getUid());
        BookingFile bookingFile = (BookingFile)bookingFileCtr.getEntity();
        order.setNumber(TextUtil.buildFullNumber((CompositeNumber)bookingFile));
        order.setServiceCount((int)bookingFile.getReservations().stream().mapToLong(r -> r.getProducts().size()).sum());
    }

    public static ReasonCode getReasonCode(EntityReference<Organization> clientRef, RestReasonCode reasonCode, ReasonCodeType reasonType) {
        if (null == reasonCode || reasonCode.getUid() == null) {
            return null;
        }
        return ((Organization)EntityStorage.get().resolve(clientRef).getEntity()).getReasonCodes().stream().filter(r -> r.getType() == reasonType).filter(r -> Objects.equals(reasonCode.getUid(), r.getName())).findFirst().orElse(null);
    }

    public static RestReasonCode convertReasonCode2Rest(ReasonCode reasonCode) {
        if (reasonCode == null) {
            return null;
        }
        RestReasonCode value = new RestReasonCode();
        value.setUid(reasonCode.getName());
        String caption = reasonCode.getRemarks().toString();
        if (TextUtil.isBlank((String)caption)) {
            caption = reasonCode.getName();
        }
        value.setCaption(caption);
        return value;
    }

    public static Collection<PersonRestCostCode> convertCostCodesToRest(Reservation reservation, Traveller traveller) {
        List baseProducts;
        LinkedHashMap<String, PersonRestCostCode> map = new LinkedHashMap<String, PersonRestCostCode>();
        if (reservation != null && !(baseProducts = reservation.getProducts()).isEmpty()) {
            for (BaseProduct baseProduct : baseProducts) {
                StatisticalData statisticalData;
                ProductHandler handler = ProductHandler.of((BaseProduct)baseProduct);
                if (!handler.isStatisticalDataAvailable(baseProduct)) {
                    return Collections.emptyList();
                }
                if (!handler.getTravellers(baseProduct).contains(traveller) || (statisticalData = handler.getStatisticalData(baseProduct)) == null) continue;
                List costCodes = statisticalData.getTravellerCostCodes().stream().filter(tcc -> MiscUtil.equals((Object)tcc.getTraveller(), (Object)traveller)).flatMap(travellerCostCodes -> travellerCostCodes.getCostCodes().stream()).collect(Collectors.toList());
                List<PersonRestCostCode> restCostCodes = CommonConverterHelper.convertCostCodesToRest(costCodes.stream().filter(costCode -> costCode.getCostCodeProperties() != null).filter(costCode -> costCode.getCostCodeProperties().getCategory() != null).collect(Collectors.toList()));
                for (PersonRestCostCode restCostCode : restCostCodes) {
                    map.putIfAbsent(restCostCode.getCostCodeCategoryUid(), restCostCode);
                }
            }
        }
        return map.values();
    }

    public static List<PersonRestCostCode> convertCostCodesToRest(List<? extends CostCode> costCodes) {
        return costCodes.stream().map(CommonConverterHelper::convertCostCodeToRest).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static PersonRestCostCode convertCostCodeToRest(CostCode costCode) {
        return CommonConverterHelper.createRestCostCode(costCode.getCostCodeProperties(), CommonConverterHelper.defineValueFromCostCode(costCode));
    }

    public static PersonRestCostCode createRestCostCode(CostCodeProperties costCodeProperties, String value) {
        if (costCodeProperties == null) {
            return null;
        }
        PersonRestCostCode personRestCostCode = new PersonRestCostCode();
        personRestCostCode.setName(costCodeProperties.getName());
        personRestCostCode.setCostCodeCategoryUid((String)Optional.ofNullable(costCodeProperties.getCategory()).map(DictionaryReference::getCode).orElse(null));
        personRestCostCode.setCommon(costCodeProperties.isCommon());
        personRestCostCode.setValue(value);
        return personRestCostCode;
    }

    public static String defineValueFromCostCode(CostCode costCode) {
        if (!TextUtils.isBlank((CharSequence)costCode.getLocalValue())) {
            return costCode.getLocalValue();
        }
        if (!TextUtils.isBlank((CharSequence)costCode.getValue())) {
            return costCode.getValue();
        }
        if (!TextUtils.isBlank((CharSequence)costCode.getEnglishValue())) {
            return costCode.getEnglishValue();
        }
        return null;
    }

    public static KeyContact getKeyContact(EntityReference<Person> personRef) {
        if (personRef == null || personRef.getUid() == null) {
            return null;
        }
        Person person = (Person)EntityStorage.get().resolve(personRef).getEntity();
        KeyContact keyContact = new KeyContact();
        keyContact.setMail(ProfileHelper.getCommunicationEmail((List)person.getCommunications()));
        keyContact.setPhone(ProfileHelper.getCommunicationPhone((List)person.getCommunications()));
        keyContact.setProfile(personRef);
        return keyContact;
    }

    public static String getDefaultErrorMessage(SMGeneralSettings generalSettings, SalesContext salesContext) {
        EntityContainer client;
        String message = generalSettings.getDefaultDialogErrorMessage().toString();
        if (TextUtil.isBlank((String)message)) {
            return null;
        }
        EntityContainer subagency = EntityStorage.get().resolve(salesContext.getSubagency());
        if (subagency != null) {
            if (message.contains("$agencyFullName")) {
                String fullName = TextUtil.nonNullStr((String)((Organization)subagency.getEntity()).getFullName().toString());
                message = message.replace("$agencyFullName", fullName);
            }
            if (message.contains("$agencyShortName")) {
                String shortName = TextUtil.nonNullStr((String)((Organization)subagency.getEntity()).getShortName().toString());
                message = message.replace("$agencyShortName", shortName);
            }
            if (message.contains("$companyEmail")) {
                String email = TextUtil.nonNullStr((String)CommunicationHelper.email((Collection)((Organization)subagency.getEntity()).getCommunications()));
                message = message.replace("$companyEmail", email);
            }
            if (message.contains("$agencyPhone")) {
                String phone = TextUtil.nonNullStr((String)((Organization)subagency.getEntity()).getCommunications().stream().filter(communication -> CommunicationType.WORK_PHONE == communication.getType() || CommunicationType.AGENCY == communication.getType()).map(ProfileHelper::buildFullPhoneNumber).filter(TextUtil::nonBlank).collect(Collectors.joining("; ")));
                message = message.replace("$agencyPhone", phone);
            }
        }
        if ((client = EntityStorage.get().resolve(salesContext.getClient())) != null && message.contains("$clientCode")) {
            String code = TextUtil.nonNullStr((String)((Organization)client.getEntity()).getCode());
            message = message.replace("$clientCode", code);
        }
        return message;
    }

    public static RestMealInfo convertMealOption2Rest(FreeMealInfo mealInfo) {
        RestMealInfo res = new RestMealInfo();
        res.setDescription(mealInfo.getDescription());
        res.setCode(mealInfo.getCode());
        res.setName(mealInfo.getName());
        return res;
    }

    public static Collection<Rate> convertRatesToRest(List<com.gridnine.xtrip.server.ibecorp.common.components.Rate> rates) {
        return rates.stream().map(rate -> {
            Rate result = new Rate();
            result.setTotal(CommonConverterHelper.convertMoney2Rest(rate.getRate(), rate.getCurrency().getCode()));
            result.setSymbol(((CurrencyInfo)DictionaryCache.get().resolveReference(rate.getCurrency())).getDisplaySymbol());
            return result;
        }).collect(Collectors.toList());
    }

    public static RestAckMessage convertToRestAckMessage(AckMessage message) {
        if (message == null) {
            return null;
        }
        RestAckMessage result = new RestAckMessage();
        result.setId(message.getId());
        result.setText(message.getText());
        return result;
    }
}

