/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest;

import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.rest.TypeHandler;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.AirlineWithCodeReference;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.web.rest.JsonHelper;
import com.gridnine.xtrip.server.web.rest.JsonMarshaller;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.ISODateTimeFormat;
import org.json.JSONException;
import org.json.JSONObject;

public class CommonTypeHandler
implements TypeHandler {
    public boolean isAwareOf(Class<?> type) {
        return Enum.class.isAssignableFrom(type) || DictionaryReference.class.isAssignableFrom(type) || EntityReference.class.isAssignableFrom(type) || LocalDate.class.isAssignableFrom(type) || LocalDateTime.class.isAssignableFrom(type) || DateTime.class.isAssignableFrom(type) || LocalTime.class.isAssignableFrom(type) || AirlineWithCodeReference.class.isAssignableFrom(type);
    }

    public Object unmarshal(Object object, Class<?> type, Class<?> originalType) {
        if (Objects.isNull(object) || object.equals(JSONObject.NULL)) {
            return null;
        }
        if (Enum.class.isAssignableFrom(type) || DictionaryReference.class.isAssignableFrom(type) || EntityReference.class.isAssignableFrom(type)) {
            String uid;
            String caption = null;
            if (object instanceof JSONObject) {
                JSONObject jsonObject = (JSONObject)object;
                uid = jsonObject.getString("uid");
                caption = jsonObject.optString("caption", null);
            } else {
                uid = (String)object;
            }
            if (Enum.class.isAssignableFrom(type)) {
                if (!TextUtil.isBlank((String)uid)) {
                    try {
                        return Enum.valueOf(type, uid);
                    }
                    catch (IllegalArgumentException e) {
                        throw Xeption.forDeveloper((String)String.format("Invalid value of type %s", type.getSimpleName()), (Object[])new Object[0]);
                    }
                }
                return null;
            }
            if (DictionaryReference.class.isAssignableFrom(type)) {
                Class<?> dictionaryType = originalType;
                BaseDictionary dict = DictionaryCache.get().findByCode(dictionaryType, uid);
                if (dict == null && GeoLocation.class.isAssignableFrom(dictionaryType)) {
                    dict = DictionaryCache.get().lookup(dictionaryType, uid, new String[]{CodeSystem.IATA.name()}).stream().findFirst().orElse(null);
                }
                return Objects.nonNull(dict) ? dict.toReference() : null;
            }
            if (EntityReference.class.isAssignableFrom(type)) {
                return new EntityReference(uid, originalType, caption);
            }
        }
        if (LocalDate.class.isAssignableFrom(type)) {
            try {
                return ISODateTimeFormat.dateParser().parseLocalDate((String)object);
            }
            catch (Exception e) {
                throw Xeption.forDeveloper((String)String.format("Unable to parse LocalDate [%s]", (String)object), (Object[])new Object[0]);
            }
        }
        if (LocalDateTime.class.isAssignableFrom(type)) {
            try {
                return ISODateTimeFormat.dateTimeParser().parseLocalDateTime((String)object);
            }
            catch (Exception e) {
                throw Xeption.forDeveloper((String)String.format("Unable to parse LocalDateTime [%s]", (String)object), (Object[])new Object[0]);
            }
        }
        if (DateTime.class.isAssignableFrom(type)) {
            try {
                return ISODateTimeFormat.dateTimeParser().parseDateTime((String)object);
            }
            catch (Exception e) {
                throw Xeption.forDeveloper((String)String.format("Unable to parse DateTime [%s]", (String)object), (Object[])new Object[0]);
            }
        }
        if (LocalTime.class.isAssignableFrom(type)) {
            try {
                return ISODateTimeFormat.timeParser().parseLocalTime((String)object);
            }
            catch (Exception e) {
                throw Xeption.forDeveloper((String)String.format("Unable to parse LocalTime [%s]", (String)object), (Object[])new Object[0]);
            }
        }
        throw Xeption.forDeveloper((String)String.format("Invalid type [%s]", type.getSimpleName()), (Object[])new Object[0]);
    }

    public Object marshal(Object result, Object value, Map<String, Object> data, boolean isValid, List<Object> parents) throws JSONException {
        if (!isValid || Objects.isNull(value)) {
            return null;
        }
        try {
            parents.add(value);
            if (Enum.class.isInstance(value)) {
                JSONObject json = new JSONObject();
                json.put("uid", (Object)((Enum)value).name());
                json.put("caption", (Object)value.toString());
                JSONObject jSONObject = json;
                return jSONObject;
            }
            if (DictionaryReference.class.isInstance(value)) {
                JSONObject json = new JSONObject();
                json.put("uid", (Object)((DictionaryReference)value).getCode());
                json.put("caption", (Object)value.toString());
                JSONObject jSONObject = json;
                return jSONObject;
            }
            if (AirlineWithCodeReference.class.isInstance(value)) {
                JsonMarshaller jsonMarshaller = (JsonMarshaller)data.get(IBusRestContextKeys.JSON_MARSHALLER.name());
                CommonTypeHandler.updateAirlineCaption((AirlineWithCodeReference)value, data);
                Object object = jsonMarshaller.marshal(value, Collections.emptyMap(), isValid, true, "", new ArrayList());
                return object;
            }
            if (EntityReference.class.isInstance(value)) {
                JSONObject json = new JSONObject();
                json.put("uid", (Object)((EntityReference)value).getUid());
                json.put("caption", (Object)((EntityReference)value).getCaption());
                JSONObject jSONObject = json;
                return jSONObject;
            }
            if (LocalDate.class.isInstance(value)) {
                String string = ISODateTimeFormat.date().print((ReadablePartial)((LocalDate)value));
                return string;
            }
            if (LocalDateTime.class.isInstance(value)) {
                String string = ISODateTimeFormat.dateTimeNoMillis().print((ReadablePartial)((LocalDateTime)value));
                return string;
            }
            if (DateTime.class.isInstance(value)) {
                String string = ISODateTimeFormat.dateTime().print((ReadableInstant)((DateTime)value));
                return string;
            }
            if (LocalTime.class.isInstance(value)) {
                String string = ISODateTimeFormat.timeNoMillis().print((ReadablePartial)((LocalTime)value));
                return string;
            }
            throw Xeption.forDeveloper((String)String.format("Invalid value [%s]", String.valueOf(value)), (Object[])new Object[0]);
        }
        finally {
            parents.remove(value);
        }
    }

    public void validate(Object o, Class<?> cls) {
        JSONObject json = (JSONObject)o;
        if (Enum.class.isAssignableFrom(cls)) {
            JsonHelper.validateJson((JSONObject)json, cls, (String[])new String[]{(String)o});
        }
        if (DictionaryReference.class.isAssignableFrom(cls)) {
            JsonHelper.validateJson((JSONObject)json, cls, (String[])new String[]{(String)o});
        }
        if (EntityReference.class.isAssignableFrom(cls)) {
            JsonHelper.validateJson((JSONObject)json, cls, (String[])new String[]{(String)o});
        }
        throw Xeption.forDeveloper((String)"Invalid value [%s]", (Object[])new Object[]{String.valueOf(cls)});
    }

    private static void updateAirlineCaption(AirlineWithCodeReference airlineWithCodeReference, Map<String, Object> data) {
        Airline airline = (Airline)DictionaryCache.get().findByCode(Airline.class, airlineWithCodeReference.getUid());
        EntityReference site = (EntityReference)data.get(IBusIbecorpContextKeys.SITE.name());
        if (airline != null && site != null) {
            Locale locale = !MiscUtil.equals((Object)airline.getCountry(), (Object)DictHelper.getRuRef()) && CommonTypeHandler.isNoAirlineTranslation(data) ? LocaleHelper.EN_LOCALE : LocaleHelper.getCurrentLocale();
            String newCaption = (String)CommonConverterHelper.findByLocale(airline.getTranslations(), locale);
            if (TextUtil.nonBlank((String)newCaption) && !MiscUtil.equals((Object)airlineWithCodeReference.getCaption(), (Object)newCaption)) {
                airlineWithCodeReference.setCaption(newCaption);
            }
        }
    }

    private static boolean isNoAirlineTranslation(Map<String, Object> data) {
        Boolean noAirlineTranslation = (Boolean)data.get(IBusIbecorpContextKeys.NO_AIRLINE_TRANSLATION.name());
        if (noAirlineTranslation == null) {
            EntityReference site = (EntityReference)data.get(IBusIbecorpContextKeys.SITE.name());
            noAirlineTranslation = Objects.requireNonNull(CommonHelper.getStep1Settings((EntityReference<SMSite>)site)).isNoAirlineTranslation();
            data.put(IBusIbecorpContextKeys.NO_AIRLINE_TRANSLATION.name(), noAirlineTranslation);
        }
        return noAirlineTranslation;
    }
}

