/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.DocaAddressType;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdValidationMessages;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.PasswordPolicyHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.rest.Validatable;
import com.gridnine.xtrip.common.model.rules.TransliterationType;
import com.gridnine.xtrip.common.model.system.StandardValidationMessages;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.common.model.validation.ValidationMessage;
import com.gridnine.xtrip.common.system.model.RegionalType;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.BonusCard;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.BonusCardValidationMessages;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.Customer;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.DocaInfo;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.DocaValidationMessages;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.DocoInfo;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.DocoValidationMessages;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.PassportValidationMessages;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.Phone;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.PhoneValidationMessages;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.RestPassport;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.CreateBookingParametersValidationMessages;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.SearchFlightsParametersValidationMessages;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.cabinet.PersonValidationMessages;
import com.gridnine.xtrip.server.web.rest.ValidationHelper;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.Period;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.util.TextUtils;
import org.joda.time.ReadablePartial;

public final class CommonValidationHelper {
    public static final Pattern EMAIL_ADDRESS_PATTERN = Pattern.compile("([0-9A-Za-z-_]+\\.)*[0-9A-Za-z-_]+@((([0-9A-Za-z-_]+\\.)+[A-Za-z]+)|(\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}))");
    public static final Pattern EMAIL_ADDRESS_WITH_CYR_PATTERN = Pattern.compile("([0-9\u0410-\u042f\u0430-\u044f-_\u0401\u0451]+\\.)*[0-9\u0410-\u042f\u0430-\u044f-_\u0401\u0451]+@((([0-9\u0410-\u042f\u0430-\u044f-_\u0401\u0451]+\\.)+[\u0410-\u042f\u0430-\u044f\u0401\u0451]+)|(\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}))");
    private static final Pattern NAME_PATTERN = Pattern.compile("([\\p{Alpha}\u0410-\u042f\u0430-\u044f\u0401\u0451\\s-])*");
    private static final Pattern RU_NAME_PATTERN = Pattern.compile("[\u0410-\u042f\u0430-\u044f\u0401\u0451\\s-]*");
    private static final Pattern EN_NAME_PATTERN = Pattern.compile("[A-Za-z\\s-]*");
    private static final Pattern NUMBER_PATTERN = Pattern.compile("\\d+");
    private static final Pattern ALPHA_AND_SPACES_PATTERN = Pattern.compile("([A-Za-z ])*");
    private static final Pattern ALPHA_NUMERIC_PATTERN = Pattern.compile("([0-9A-Za-z])*");
    private static final Pattern NUMBER_PASSPORT_KZ_PATTERN = Pattern.compile("^\\w{1}\\d{8}$");
    private static final Pattern KZ_BIRTHDAY_NOTIFICATION_PATTERN = Pattern.compile("^\\d{7}$");
    private static final Pattern ALPHA_NUMERIC_AND_SPACES_PATTERN = Pattern.compile("([0-9A-Za-z ])*");
    private static final List<PassportType> PASSPORT_TYPES_FOR_RUS = Collections.singletonList(PassportType.SEAMANSID);

    public static void validatePassport(RestPassport passport, TransliterationType transliterationType) {
        RestPassport.RestPassportValidationContext validationContext = passport.getValidationContext();
        if (Objects.isNull(passport.getGender())) {
            validationContext.getGenderValidationMessages().add(PassportValidationMessages.getMissingGender());
            return;
        }
        if (!CommonValidationHelper.isValidName(passport.getFirstName(), true, transliterationType, passport.getValidationContext().getFirstNameValidationMessages())) {
            return;
        }
        if (!CommonValidationHelper.isValidName(passport.getSecondName(), false, transliterationType, passport.getValidationContext().getSecondNameValidationMessages())) {
            return;
        }
        if (!CommonValidationHelper.isValidName(passport.getLastName(), true, transliterationType, passport.getValidationContext().getLastNameValidationMessages())) {
            return;
        }
        if (!passport.isWithoutMiddleName() && !CommonValidationHelper.isValidName(passport.getMiddleName(), true, transliterationType, passport.getValidationContext().getMiddleNameValidationMessages())) {
            return;
        }
        if (!CommonValidationHelper.isValidPassportBirthDate(passport)) {
            return;
        }
        if (Objects.isNull(passport.getCitizenship())) {
            validationContext.getCitizenshipValidationMessages().add(PassportValidationMessages.getMissingCitizenship());
            return;
        }
        if (Objects.isNull(passport.getOriginCountry())) {
            validationContext.getOriginCountryValidationMessages().add(PassportValidationMessages.getMissingOrigin());
            return;
        }
        if (Objects.isNull(passport.getType())) {
            validationContext.getTypeValidationMessages().add(PassportValidationMessages.getMissingPassportType());
            return;
        }
        if (!CommonValidationHelper.isCalculateExpiredDate(passport.getType()) && !CommonValidationHelper.isValidPassportExpiredDate(passport.getExpiredDate(), passport.getValidationContext().getExpiredDateValidationMessages())) {
            return;
        }
        if (!CommonValidationHelper.isValidPassportNumber(passport)) {
            return;
        }
        if (!CommonValidationHelper.isValidPassportType(passport.getType(), (DictionaryReference<Country>)passport.getCitizenship(), validationContext.getTypeValidationMessages())) {
            return;
        }
    }

    public static boolean isValidName(String name, boolean isNameMandatory, TransliterationType transliterationType, Collection<ValidationMessage> validationMessages) {
        return CommonValidationHelper.isValidName(name, isNameMandatory, transliterationType, true, true, true, validationMessages);
    }

    public static boolean isValidName(String name, boolean isNameMandatory, TransliterationType transliterationType, boolean isSpaceValid, boolean isDashValid, boolean checkLengthLimit, Collection<ValidationMessage> validationMessages) {
        if (TextUtil.isBlank((String)name)) {
            if (isNameMandatory) {
                validationMessages.add(StandardValidationMessages.getMissingRequiredValue());
                return false;
            }
            return true;
        }
        if (!isSpaceValid && name.contains(" ")) {
            validationMessages.add(com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.PersonValidationMessages.getValueContainsSpace());
            return false;
        }
        if (!isDashValid && name.contains("-")) {
            validationMessages.add(com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.PersonValidationMessages.getValueIllegal());
            return false;
        }
        if (transliterationType == TransliterationType.LATIN && !EN_NAME_PATTERN.matcher(name).matches()) {
            validationMessages.add(com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.PersonValidationMessages.getValueNonLatin());
            return false;
        }
        if (transliterationType == TransliterationType.CYRILLIC && !RU_NAME_PATTERN.matcher(name).matches()) {
            validationMessages.add(com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.PersonValidationMessages.getValueIllegal());
            return false;
        }
        if (transliterationType == TransliterationType.LATIN_AND_CYRILLIC && !NAME_PATTERN.matcher(name).matches()) {
            validationMessages.add(com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.PersonValidationMessages.getValueIllegal());
            return false;
        }
        if (checkLengthLimit && !CommonValidationHelper.isValidNameLength(name)) {
            validationMessages.add(com.gridnine.xtrip.server.ibecorp.b2b.rest.model.cabinet.PersonValidationMessages.getValueLengthLimit());
            return false;
        }
        if (!RU_NAME_PATTERN.matcher(name).matches() && !EN_NAME_PATTERN.matcher(name).matches()) {
            validationMessages.add(PassportValidationMessages.getOnlyLatinOrCyrillic());
            return false;
        }
        return true;
    }

    public static boolean validateCustomer(Customer customer, boolean isLatinNameRequired, SMGeneralSettings settings) {
        if (TextUtil.isBlank((String)customer.getFirstName())) {
            customer.getValidationContext().getFirstNameValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
        }
        if (TextUtil.isBlank((String)customer.getLastName())) {
            customer.getValidationContext().getLastNameValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
        }
        CommonValidationHelper.isValidEmail(customer, settings);
        CommonValidationHelper.isValidPhone(customer);
        return ValidationHelper.isValid((Validatable)customer);
    }

    public static boolean isValidEmail(Customer customer, SMGeneralSettings settings) {
        if (TextUtil.isBlank((String)customer.getEmail())) {
            customer.getValidationContext().getEmailValidationMessages().add(CreateBookingParametersValidationMessages.getMissingContactEmail());
            return false;
        }
        if (!CommonValidationHelper.isValidEmailFormat(customer.getEmail())) {
            customer.getValidationContext().getEmailValidationMessages().add(CreateBookingParametersValidationMessages.getIllegalContactEmail());
            return false;
        }
        if (settings.getBannedEmail().stream().anyMatch(s -> s.equalsIgnoreCase(customer.getEmail()))) {
            customer.getValidationContext().getEmailValidationMessages().add(CreateBookingParametersValidationMessages.getIllegalContactEmail());
            return false;
        }
        return true;
    }

    public static boolean isValidPhone(Customer customer) {
        if (CommonHelper.isEmpty(customer.getPhone())) {
            customer.getValidationContext().getPhoneValidationMessages().add(CreateBookingParametersValidationMessages.getMissingPhone());
            return false;
        }
        return CommonValidationHelper.isValidPhone(customer.getPhone(), customer.getValidationContext().getPhoneValidationMessages());
    }

    private static boolean isValidNameLength(String name) {
        return name.length() <= 63;
    }

    private static boolean isValidPassportBirthDate(RestPassport passport) {
        Collection<ValidationMessage> validationMessages = CommonValidationHelper.isValidBirthDate(passport.getBirthDate());
        passport.getValidationContext().getBirthDateValidationMessages().addAll(validationMessages);
        return validationMessages.isEmpty();
    }

    public static Collection<ValidationMessage> isValidBirthDate(LocalDate date) {
        ArrayList<ValidationMessage> validationMessages = new ArrayList<ValidationMessage>();
        if (Objects.isNull(date)) {
            validationMessages.add(PassportValidationMessages.getMissingBirthDate());
            return validationMessages;
        }
        Period period = Period.between(date, LocalDate.now());
        int age = period.getYears();
        if (age < 0 || age > 150) {
            validationMessages.add(PassportValidationMessages.getIllegalBirthDate());
        }
        return validationMessages;
    }

    public static boolean isCalculateExpiredDate(PassportType passportType) {
        return passportType == PassportType.INTERNAL || passportType == PassportType.BIRTHDAY_NOTIFICATION;
    }

    public static boolean isValidPassportExpiredDate(LocalDate date, Collection<ValidationMessage> expiredDateValidationMessages) {
        if (Objects.isNull(date)) {
            expiredDateValidationMessages.add(PassportValidationMessages.getMissingPassportExpired());
            return false;
        }
        return true;
    }

    private static boolean isValidPassportNumber(RestPassport passport) {
        if (CommonValidationHelper.isMissingPassportNumber(passport.getNumber(), passport.getValidationContext().getNumberValidationMessages())) {
            return false;
        }
        return !CommonValidationHelper.isIllegalPassportNumber(passport.getType(), passport.getNumber(), passport.getValidationContext().getNumberValidationMessages());
    }

    public static boolean isMissingPassportNumber(String number, Collection<ValidationMessage> numberValidationMessages) {
        if (TextUtil.isBlank((String)number)) {
            numberValidationMessages.add(PassportValidationMessages.getMissingPassportNumber());
            return true;
        }
        return false;
    }

    public static boolean isIllegalPassportNumber(PassportType type, String number, Collection<ValidationMessage> numberValidationMessages) {
        if (!(type != PassportType.INTERNAL || CommonValidationHelper.isNumber(number) && number.length() == 10)) {
            numberValidationMessages.add(PassportValidationMessages.getIllegalInternalPassportNumber());
            return true;
        }
        if (!(type != PassportType.FOREIGN || CommonValidationHelper.isNumber(number) && number.length() == 9)) {
            numberValidationMessages.add(PassportValidationMessages.getIllegalForeignPassportNumber());
            return true;
        }
        if (!(type != PassportType.SEAMANSID || CommonValidationHelper.isNumber(number) && number.length() == 7)) {
            numberValidationMessages.add(PassportValidationMessages.getIllegalSeamansIdNumber());
            return true;
        }
        return false;
    }

    public static boolean isNumber(String str) {
        return NUMBER_PATTERN.matcher(str).matches();
    }

    public static boolean isKzPassport(String str) {
        return NUMBER_PASSPORT_KZ_PATTERN.matcher(str).matches();
    }

    public static boolean isValidKzBirthDateNotificationNumber(String number) {
        return KZ_BIRTHDAY_NOTIFICATION_PATTERN.matcher(number).matches();
    }

    public static boolean isValidPassportType(PassportType type, DictionaryReference<Country> citizenship, Collection<ValidationMessage> typeValidationMessages) {
        boolean isRusCitizenship = CommonValidationHelper.isRu(citizenship);
        if (PASSPORT_TYPES_FOR_RUS.contains(type) && !isRusCitizenship) {
            typeValidationMessages.add(PassportValidationMessages.getIncorrectDocumentTypeForCitizenship());
            return false;
        }
        return true;
    }

    public static void validationEmailMessages(List<String> emails, Map<Integer, Collection<ValidationMessage>> emailsValidationMessages) {
        for (int i = 0; emails.size() > i; ++i) {
            String email = emails.get(i);
            if (TextUtils.isBlank((CharSequence)email)) {
                emailsValidationMessages.put(i, Collections.singletonList(PersonValidationMessages.getEmptyEmail()));
                continue;
            }
            if (CommonValidationHelper.isValidEmailFormat(email)) continue;
            emailsValidationMessages.put(i, Collections.singletonList(PersonValidationMessages.getInvalidEmail()));
        }
        if (!emailsValidationMessages.isEmpty()) {
            throw new ValidationException();
        }
    }

    public static boolean isValidEmailFormat(String email) {
        if (email.length() > 64) {
            return false;
        }
        if (email.matches(".*[\\.\\-_][\\.\\-_].*")) {
            return false;
        }
        return EMAIL_ADDRESS_PATTERN.matcher(email).matches() || EMAIL_ADDRESS_WITH_CYR_PATTERN.matcher(email).matches();
    }

    public static String buildPhone2String(Phone phone) {
        return Stream.of(phone.getCountryCode(), phone.getCityCode(), phone.getNumber()).filter(TextUtil::nonBlank).collect(Collectors.joining());
    }

    public static boolean isValidPhone(Phone phone, Collection<ValidationMessage> messages) {
        if (TextUtil.isBlank((String)phone.getCountryCode())) {
            phone.getValidationContext().getCityCodeValidationMessages().add(PhoneValidationMessages.getMissingCountryCode());
        }
        if (TextUtil.isBlank((String)phone.getCityCode()) && phone.getNumber() != null && phone.getNumber().length() < 4) {
            phone.getValidationContext().getCityCodeValidationMessages().add(PhoneValidationMessages.getMissingCityCode());
        }
        if (TextUtil.isBlank((String)phone.getNumber())) {
            phone.getValidationContext().getCityCodeValidationMessages().add(PhoneValidationMessages.getMissingNumber());
        }
        if (!CommonValidationHelper.buildPhone2String(phone).chars().allMatch(Character::isDigit)) {
            messages.add(PhoneValidationMessages.getIllegalPhone());
        }
        return messages.isEmpty() && ValidationHelper.isValid((Validatable)phone);
    }

    public static boolean isRu(DictionaryReference<Country> citizenship) {
        return citizenship != null && "RU".equals(citizenship.getCode());
    }

    public static boolean isKz(DictionaryReference<Country> citizenship) {
        return citizenship != null && "KZ".equals(citizenship.getCode());
    }

    public static boolean isUa(DictionaryReference<Country> citizenship) {
        return citizenship != null && "UA".equals(citizenship.getCode());
    }

    public static Date calculateExpiredDate(DictionaryReference<Country> country, Date arriveDate) {
        if (CommonValidationHelper.isUa(country)) {
            return DateUtils.toJavaDate((LocalDate)LocalDate.of(2099, 12, 31));
        }
        return arriveDate == null ? null : MiscUtil.addYearsToDate((Date)MiscUtil.clearTime((Date)arriveDate), (int)1);
    }

    public static void isValidBonusCard(BonusCard bonusCard, Flight gdsFlight) {
        if (bonusCard.getAirline() == null) {
            bonusCard.getValidationContext().getAirlineValidationMessages().add(BonusCardValidationMessages.getIllegalBonusCard());
        }
        if (bonusCard.getNameOnCard() == null) {
            bonusCard.getValidationContext().getNameOnCardValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
        }
        if (TextUtil.isBlank((String)bonusCard.getNumber())) {
            bonusCard.getValidationContext().getNumberValidationMessages().add(BonusCardValidationMessages.getIllegalBonusCard());
        }
        if (!NUMBER_PATTERN.matcher(bonusCard.getNumber()).matches()) {
            bonusCard.getValidationContext().getNumberValidationMessages().add(BonusCardValidationMessages.getIllegalCardNumber());
        }
        if (bonusCard.getAirline() != null) {
            Set airlines = FlightHelper.getFlightSegmentsStream((Flight)gdsFlight).flatMap(s -> {
                HashSet<DictionaryReference> carriers = new HashSet<DictionaryReference>();
                carriers.add(s.getAirline());
                carriers.add(s.getAirline());
                return carriers.stream();
            }).collect(Collectors.toSet());
            if (!DictHelper.validateAlliances((DictionaryReference)bonusCard.getAirline(), airlines)) {
                bonusCard.getValidationContext().getAirlineValidationMessages().add(BonusCardValidationMessages.getIllegalBonusCard());
                bonusCard.getValidationContext().getNumberValidationMessages().add(BonusCardValidationMessages.getIllegalBonusCard());
            }
        }
    }

    public static boolean hasBonusCard(BonusCard bonusCard) {
        return bonusCard != null && (Objects.nonNull(bonusCard.getAirline()) || !TextUtil.isBlank((String)bonusCard.getNameOnCard()) || !TextUtil.isBlank((String)bonusCard.getNumber()));
    }

    public static void validateDocoInfo(DocoInfo docoInfo) {
        boolean emptyVisaIssuePlace;
        boolean emptyVisaNumber;
        boolean missingVisaExpirationDate;
        CommonValidationHelper.isEmptyDocoDocaField(docoInfo.getPlaceOfBirthCountry(), false, (Collection<ValidationMessage>)docoInfo.getValidationContext().getPlaceOfBirthCountryValidationMessages(), DocoValidationMessages.getMissingPlaceOfBirthCountry());
        CommonValidationHelper.isEmptyDocoDocaField(docoInfo.getVisaApplicableCountry(), docoInfo.isVisa(), (Collection<ValidationMessage>)docoInfo.getValidationContext().getVisaApplicableCountryValidationMessages(), DocoValidationMessages.getMissingVisaApplicableCountry());
        boolean missingVisaIssueDate = CommonValidationHelper.isEmptyDocoDocaField(docoInfo.getVisaIssueDate(), docoInfo.isVisa(), (Collection<ValidationMessage>)docoInfo.getValidationContext().getVisaIssueDateValidationMessages(), DocoValidationMessages.getMissingVisaIssueDate());
        if (!missingVisaIssueDate) {
            CommonValidationHelper.validateVisaIssueDate(docoInfo.getVisaIssueDate(), docoInfo.isVisa(), docoInfo.getValidationContext().getVisaIssueDateValidationMessages(), DocoValidationMessages.getIllegalVisaIssueDate());
        }
        if (!(missingVisaExpirationDate = CommonValidationHelper.isEmptyDocoDocaField(docoInfo.getVisaExpirationDate(), docoInfo.isVisa(), (Collection<ValidationMessage>)docoInfo.getValidationContext().getVisaExpirationDateValidationMessages(), DocoValidationMessages.getMissingVisaExpirationDate()))) {
            CommonValidationHelper.validateVisaExpirationDate(docoInfo.getVisaExpirationDate(), docoInfo.getVisaIssueDate(), docoInfo.isVisa(), docoInfo.getValidationContext().getVisaExpirationDateValidationMessages(), DocoValidationMessages.getIllegalVisaExpirationDate());
        }
        if (!(emptyVisaNumber = CommonValidationHelper.isEmptyDocoDocaField(docoInfo.getVisaNumber(), docoInfo.isVisa(), (Collection<ValidationMessage>)docoInfo.getValidationContext().getVisaNumberValidationMessages(), DocoValidationMessages.getMissingVisaNumber()))) {
            CommonValidationHelper.isIllegalDocoDocaField(docoInfo.getVisaNumber(), ALPHA_NUMERIC_PATTERN, docoInfo.getValidationContext().getVisaNumberValidationMessages(), DocoValidationMessages.getIllegalVisaNumber());
            CommonValidationHelper.isTooLongDocoDocaField(docoInfo.getVisaNumber(), 15, docoInfo.getValidationContext().getVisaNumberValidationMessages(), DocoValidationMessages.getTooLongVisaNumber());
        }
        if (!(emptyVisaIssuePlace = CommonValidationHelper.isEmptyDocoDocaField(docoInfo.getVisaIssuePlace(), docoInfo.isVisa(), (Collection<ValidationMessage>)docoInfo.getValidationContext().getVisaIssuePlaceValidationMessages(), DocoValidationMessages.getMissingVisaIssuePlace()))) {
            CommonValidationHelper.isIllegalDocoDocaField(docoInfo.getVisaIssuePlace(), ALPHA_AND_SPACES_PATTERN, docoInfo.getValidationContext().getVisaIssuePlaceValidationMessages(), DocoValidationMessages.getIllegalVisaIssuePlace());
            CommonValidationHelper.isTooLongDocoDocaField(docoInfo.getVisaIssuePlace(), 35, docoInfo.getValidationContext().getVisaIssuePlaceValidationMessages(), DocoValidationMessages.getTooLongVisaIssuePlace());
        }
    }

    public static PersonEmployment getPersonEmployment(Person person, EntityReference<Organization> client) {
        if (person != null) {
            return person.getEmployments().stream().filter(employment -> employment.getOrganization() != null && employment.getOrganization().equals((Object)client)).findFirst().orElse(null);
        }
        return null;
    }

    public static EntityReference<Organization> getEmployeeOrganization(Person person, EntityReference<Organization> client) {
        if (person == null) {
            return null;
        }
        List actualEmployments = person.getEmployments().stream().filter(employment -> employment.getOrganization() != null && MiscUtil.isBetween((Date)employment.getOpened(), (Date)employment.getClosed(), (Date)new Date())).collect(Collectors.toList());
        boolean clientEmploymentPresent = actualEmployments.stream().anyMatch(employment -> client.equals((Object)employment.getOrganization()));
        if (clientEmploymentPresent) {
            return client;
        }
        if (actualEmployments.size() == 1) {
            return ((PersonEmployment)actualEmployments.get(0)).getOrganization();
        }
        return actualEmployments.stream().filter(PersonEmployment::isMainEmployment).map(PersonEmployment::getOrganization).findFirst().orElse(null);
    }

    private static void validateVisaIssueDate(org.joda.time.LocalDate issueDate, boolean required, Collection<ValidationMessage> messages, ValidationMessage message) {
        org.joda.time.LocalDate currentDate = new org.joda.time.LocalDate();
        if (required && currentDate.isBefore((ReadablePartial)issueDate)) {
            messages.add(message);
        }
    }

    private static void validateVisaExpirationDate(org.joda.time.LocalDate expirationDate, org.joda.time.LocalDate issueDate, boolean required, Collection<ValidationMessage> messages, ValidationMessage message) {
        org.joda.time.LocalDate currentDate = new org.joda.time.LocalDate();
        if (required && (currentDate.isAfter((ReadablePartial)expirationDate) || issueDate != null && expirationDate.isBefore((ReadablePartial)issueDate))) {
            messages.add(message);
        }
    }

    public static void validateDocaInfo(DocaInfo docaInfo) {
        boolean emptyZipPostalCode;
        boolean emptyStreet;
        boolean emptyCity;
        CommonValidationHelper.isEmptyDocoDocaField(docaInfo.getCountry(), true, (Collection<ValidationMessage>)docaInfo.getValidationContext().getCountryValidationMessages(), DocaValidationMessages.getMissingCountry());
        boolean emptyStageProvince = CommonValidationHelper.isEmptyDocoDocaField(docaInfo.getStateProvince(), docaInfo.getAddressType() == DocaAddressType.DESTINATION, (Collection<ValidationMessage>)docaInfo.getValidationContext().getStateProvinceValidationMessages(), DocaValidationMessages.getMissingStateProvince());
        if (!emptyStageProvince) {
            CommonValidationHelper.isIllegalDocoDocaField(docaInfo.getStateProvince(), ALPHA_AND_SPACES_PATTERN, docaInfo.getValidationContext().getStateProvinceValidationMessages(), DocaValidationMessages.getIllegalStateProvince());
            CommonValidationHelper.isTooLongDocoDocaField(docaInfo.getStateProvince(), 35, docaInfo.getValidationContext().getStateProvinceValidationMessages(), DocaValidationMessages.getTooLongStateProvince());
        }
        if (!(emptyCity = CommonValidationHelper.isEmptyDocoDocaField(docaInfo.getCity(), docaInfo.getAddressType() == DocaAddressType.DESTINATION, (Collection<ValidationMessage>)docaInfo.getValidationContext().getCityValidationMessages(), DocaValidationMessages.getIllegalCity()))) {
            CommonValidationHelper.isIllegalDocoDocaField(docaInfo.getCity(), ALPHA_AND_SPACES_PATTERN, docaInfo.getValidationContext().getCityValidationMessages(), DocaValidationMessages.getIllegalCity());
            CommonValidationHelper.isTooLongDocoDocaField(docaInfo.getCity(), 35, docaInfo.getValidationContext().getCityValidationMessages(), DocaValidationMessages.getTooLongCity());
        }
        if (!(emptyStreet = CommonValidationHelper.isEmptyDocoDocaField(docaInfo.getStreet(), docaInfo.getAddressType() == DocaAddressType.DESTINATION, (Collection<ValidationMessage>)docaInfo.getValidationContext().getStreetValidationMessages(), DocaValidationMessages.getMissingStreet()))) {
            CommonValidationHelper.isIllegalDocoDocaField(docaInfo.getStreet(), ALPHA_NUMERIC_AND_SPACES_PATTERN, docaInfo.getValidationContext().getStreetValidationMessages(), DocaValidationMessages.getIllegalStreet());
            CommonValidationHelper.isTooLongDocoDocaField(docaInfo.getStreet(), 35, docaInfo.getValidationContext().getStreetValidationMessages(), DocaValidationMessages.getTooLongStreet());
        }
        if (!(emptyZipPostalCode = CommonValidationHelper.isEmptyDocoDocaField(docaInfo.getZipPostalCode(), false, (Collection<ValidationMessage>)docaInfo.getValidationContext().getZipPostalCodeValidationMessages(), DocaValidationMessages.getMissingZipPostalCode()))) {
            CommonValidationHelper.isIllegalDocoDocaField(docaInfo.getZipPostalCode(), ALPHA_NUMERIC_AND_SPACES_PATTERN, docaInfo.getValidationContext().getZipPostalCodeValidationMessages(), DocaValidationMessages.getIllegalZipPostalCode());
            CommonValidationHelper.isTooLongDocoDocaField(docaInfo.getZipPostalCode(), 17, docaInfo.getValidationContext().getZipPostalCodeValidationMessages(), DocaValidationMessages.getTooLongZipPostalCode());
        }
    }

    private static boolean isEmptyDocoDocaField(Object field, boolean required, Collection<ValidationMessage> messages, ValidationMessage message) {
        if (field == null) {
            if (required) {
                messages.add(message);
            }
            return true;
        }
        return false;
    }

    private static boolean isEmptyDocoDocaField(String field, boolean required, Collection<ValidationMessage> messages, ValidationMessage message) {
        if (TextUtil.isBlank((String)field)) {
            if (required) {
                messages.add(message);
            }
            return true;
        }
        return false;
    }

    private static boolean isIllegalDocoDocaField(String field, Pattern pattern, Collection<ValidationMessage> messages, ValidationMessage message) {
        if (pattern != null && !pattern.matcher(field).matches()) {
            messages.add(message);
            return true;
        }
        return false;
    }

    private static boolean isTooLongDocoDocaField(String field, int maxLength, Collection<ValidationMessage> messages, ValidationMessage message) {
        if (field.length() > maxLength) {
            messages.add(message);
            return true;
        }
        return false;
    }

    public static void validatePasswordPolicy(String password, Collection<ValidationMessage> messages) {
        if (!PasswordPolicyHelper.checkPassword((String)password)) {
            messages.add(PersonValidationMessages.getNotCorrespondPasswordPolicy((int)8));
        }
        if (PasswordPolicyHelper.hasInvalidCharacters((String)password)) {
            messages.add(PersonValidationMessages.getPasswordHasInvalidSymbols());
        }
    }

    public static ValidationMessage checkDatesForValid(PersonEmployment personEmployment) {
        if (personEmployment != null) {
            Date date = new Date();
            SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy");
            if (MiscUtil.isBefore((Date)personEmployment.getOpened(), (Date)personEmployment.getClosed(), (Date)date)) {
                return SearchFlightsParametersValidationMessages.getWrongStartWorkDate((String)formatter.format(personEmployment.getOpened()));
            }
            if (MiscUtil.isAfter((Date)personEmployment.getOpened(), (Date)personEmployment.getClosed(), (Date)date)) {
                return SearchFlightsParametersValidationMessages.getWrongEndWorkDate((String)formatter.format(personEmployment.getClosed()));
            }
        }
        return null;
    }

    public static void validatePersonIin(String iin, boolean isKzCitizenship, Collection<ValidationMessage> messages) {
        if (SystemHelper.containsInRegionalSettings((RegionalType)RegionalType.KZ)) {
            if (isKzCitizenship) {
                if (TextUtils.isBlank((CharSequence)iin)) {
                    messages.add(StandardValidationMessages.getMissingRequiredValue());
                } else if (!iin.matches("\\d{12}")) {
                    messages.add(RzdValidationMessages.getIvalidValueOnlyFixedNumbers((int)12));
                }
            }
        } else if (!TextUtils.isBlank((CharSequence)iin)) {
            throw Xeption.forDeveloper((String)"Installation is not Kz but field IIN was filled", (Object[])new Object[0]);
        }
    }
}

