/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.common.rest;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.web.rest.RestServiceErrorHandler;
import java.util.Map;

public class IbeRestServiceErrorHandler
implements RestServiceErrorHandler {
    public String getUserMessage(Map<String, Object> ibusData) {
        EntityReference site = (EntityReference)ibusData.get(IBusIbecorpContextKeys.SITE.name());
        SalesContext salesContext = (SalesContext)ibusData.get(IBusMidofficeContextKeys.SALES_CONTEXT.name());
        if (site == null || salesContext == null) {
            return this.getDefaultMessage();
        }
        SMGeneralSettings generalSettings = CommonHelper.getGeneralSettings((EntityReference<SMSite>)site);
        if (generalSettings == null) {
            return this.getDefaultMessage();
        }
        String message = CommonConverterHelper.getDefaultErrorMessage(generalSettings, salesContext);
        if (TextUtil.isBlank((String)message)) {
            return this.getDefaultMessage();
        }
        return message;
    }

    public boolean exceptionStackTraceRequired() {
        return true;
    }

    private String getDefaultMessage() {
        return L10nResourcesManager.getStr((String)"AN_ERROR_HAS_OCCURRED_CONTACT_SUPPORT", (Object[])new Object[0]);
    }

    public boolean isShowDeveloperExceptions(Map<String, Object> ibusData) {
        GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ibusData.get(IBusMidofficeContextKeys.GDS_TRACING_SETTINGS.name());
        if (gdsTracingSettings == null) {
            SalesContext salesContext = (SalesContext)ibusData.get(IBusMidofficeContextKeys.SALES_CONTEXT.name());
            gdsTracingSettings = CommonHelper.getGdsTracingSettings(salesContext);
        }
        return gdsTracingSettings != null ? gdsTracingSettings.isShowDeveloperExceptions() : false;
    }
}

